//////////////////////////////////
// name:	CharWrap.cpp
// purpose:	implementation of the cCharWrap class
//			intended to control the access to the chars[] by redefining 'chars' as follows:
//				extern cCharWrap cwrap;
//				#define chars (cwrap.prepare(__LINE__, DBGFILE))
//			Thus an access like 'chars[i].name' will be mapped to realchars[i].name, with
//			a chance of detecting a bad index value and logging the line & file where it came from.
//			Because bad idex values have to be directed to some place *within* the array, all chars are loaded '1 up',
//			leaving char[0] free (to take all the damage). And chars[i] is mapped to realchar[i+1]
// history:	init by Duke, 5.10.2000
//

#include "wolfpack.h"
#include "CharWrap.h"

#undef  DBGFILE 
#define DBGFILE "CharWrap.cpp"

cCharWrap::cCharWrap(){}

cCharWrap::~cCharWrap(){}

cChar& cCharWrap::operator[](long inx)
{
	if (inx<0 || inx>=charcount)
	{
		char tmp[222];
		sprintf(tmp,"bad char index %i in file %s line %i",inx, srcfile, srcline);
		LogError(tmp);
		return realchars[0];	// VERY bad for char 0, but it keeps the server alive ;-)
	}
	else
	{
		return realchars[inx+C_W_O_1];	// plus wrapping offset
	}
}

// remember line & file of the access and return an object that the operator overload can act on.
cCharWrap& cCharWrap::prepare(int line, char* fn)
{
	srcline = line;
	srcfile = fn;
	return *this;
}
