// Client.cpp: implementation of the cClient class.
//
//////////////////////////////////////////////////////////////////////

#include "wolfpack.h"
#include "Client.h"
#include "SndPkg.h"
#include "debug.h"

#undef  DBGFILE
#define DBGFILE "client.cpp"
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

cClient::cClient(int so)
{
	if (so < 0 || so > MAXCLIENT)
	{
		char tmp[50];
		sprintf(tmp,"Bad socket # <%d>",so);
		LogCritical(tmp);
	}
	else
		socket=so;
}

cClient::~cClient(){;}

UOXSOCKET	cClient::GetSocket()	{return socket;}
CHARACTER	cClient::GetCurrChar()	{return currchar[socket];}
P_CHAR		cClient::getPlayer()	{return &chars[currchar[socket]];}
bool		cClient::IsDragging()	{return (DRAGGED[socket]>0);}
void		cClient::SetDragging()	{DRAGGED[socket]=1;}
void		cClient::ResetDragging(){DRAGGED[socket]=0;}
void		cClient::SysMsg(char* text)	{sysmessage(socket,text);}
