//////////////////////////////////
// name:	ItemWrap.cpp
// purpose:	implementation of the ItemWrap class
//			intended to control the access to the items[] by redefining 'items' as follows:
//				extern cItemWrap iwrap;
//				#define items (iwrap.prepare(__LINE__, DBGFILE))
//			Thus an access like 'item[i].name' will be mapped to realitems[i].name, with
//			a chance of detecting a bad index value and logging the line & file where it came from.
//			Because bad index values have to be directed to some place *within* the array, all items are loaded '1 up',
//			leaving items[0] free (to take all the damage). And items[i] is mapped to realitems[i+1]
// history:	init by Duke, 30.9.2000
//			added offset feature Duke, 5.10.2000
//			added suppressing empty wsc messages Duke 11.4.2001
//

#include "wolfpack.h"

#undef  DBGFILE
#define DBGFILE "ItemWrap.cpp"

cItemWrap::cItemWrap(){}

cItemWrap::~cItemWrap(){}

cItem& cItemWrap::operator[](long inx)
{
	if (inx<0 || inx>=itemcount)
	{
		if (!(itemcount==0 && inx==0))	// suppress 4 messages when starting the server with NO worldfiles
		{
			char tmp[222];
			sprintf(tmp,"bad item index %i in file %s line %i itemcount %i",inx, srcfile, srcline,itemcount);
			LogError(tmp);
		}
		return realitems[0];	// VERY bad for item 0, but it keeps the server alive ;-)
	}
	else
	{
		return realitems[inx+I_W_O_1];	// plus 1 offset
	}
}

cItemWrap& cItemWrap::prepare(int line, char* fn)
{
	srcline = line;
	srcfile = fn;
	return *this;
}
