//////////////////////////////////////////////////////////////////////
// TmpEff.cpp: implementation of temporary effects
//				cut from Wolfpack.cpp by Duke, 25.10.2000


#include "TmpEff.h"

#undef  DBGFILE
#define DBGFILE "TmpEff.cpp"

static int TE_getDest(int te)	// te: index into teffects
{
	return calcserial(teffects[te].dest1, teffects[te].dest2, teffects[te].dest3, teffects[te].dest4);
}

void tempeffectsoff()
{
	unsigned int i;
	for (i=0;i<teffectcount;i++)
	{
		P_CHAR pc_s = FindCharBySerial(TE_getDest(i));
		if (pc_s != NULL) //lb
		{
			switch(teffects[i].num)
			{
			case 1:
				pc_s->priv2 &= 0xFD;
				break;
			case 2:
				pc_s->fixedlight='\xFF';
				break;
			case 3:
				pc_s->chgDex(teffects[i].more1);
				break;
			case 4:
				pc_s->in+=teffects[i].more1;
				break;
			case 5:
				pc_s->st+=teffects[i].more1;
				break;
			case 6:
				pc_s->chgDex(-1 * teffects[i].more1);
				break;
			case 7:
				pc_s->in-=teffects[i].more1;
				break;
			case 8:
				pc_s->st-=teffects[i].more1;
				break;
			case 11:
				pc_s->st-=teffects[i].more1;
				pc_s->chgDex(-1 * teffects[i].more2);
				pc_s->in-=teffects[i].more3;
				break;
			case 12:
				pc_s->st+=teffects[i].more1;
				pc_s->chgDex(teffects[i].more2);
				pc_s->in+=teffects[i].more3;
				break;
			default:
				break;
			}
		}
	} // end of !=-1
}

void tempeffectson()
{
	unsigned int i;
	for (i=0;i<teffectcount;i++)
	{
		P_CHAR pc_s = FindCharBySerial(TE_getDest(i));
		if (pc_s != NULL)
		{
			switch(teffects[i].num)
			{
			case 1:
				pc_s->priv2 |= 0x02;
				break;
			case 2:
				pc_s->fixedlight=worldbrightlevel;
				break;
			case 3:
				pc_s->chgDex(-1 * teffects[i].more1);
				break;
			case 4:
				pc_s->in-=teffects[i].more1;
				break;
			case 5:
				pc_s->st-=teffects[i].more1;
				break;
			case 6:
				pc_s->chgDex(teffects[i].more1);
				break;
			case 7:
				pc_s->in+=teffects[i].more1;
				break;
			case 8:
				pc_s->st+=teffects[i].more1;
				break;
			case 11:
				pc_s->st+=teffects[i].more1;
				pc_s->chgDex(teffects[i].more2);
				pc_s->in+=teffects[i].more3;
				break;
			case 12:
				pc_s->st-=teffects[i].more1;
				pc_s->chgDex(-1 * teffects[i].more2);
				pc_s->in-=teffects[i].more3;
				break;
			default:
				break;
			}
		}
	} // end of if !=-1
}
/////////////
// Name:	reverseIncognito
// Purpose:	undo the effects of the incognito spell
// History: by AntiChrist
//			isolated from two functions by Duke, 10.6.2001
//
static void reverseIncognito(P_CHAR pc)
{
	CHARACTER c = DEREF_P_CHAR(pc);

	if(pc->incognito)//let's ensure it's under incognito effect!
	{
		pc->id1=pc->xid1;	// SEX
		pc->id2=pc->xid2;
		
		pc->skin = pc->xskin;	// SKIN COLOR
		
		strcpy(pc->name,pc->orgname);	// NAME
		
		if(pc->hairserial>-1)//if hairs exist, restore hair style/color
		{
			P_ITEM pHair = FindItemBySerial(pc->hairserial);
			if(pHair)
			{
				if(pHair->incognito) //let's ensure it was marked as under incognito effect
				{
					//stores old hair values
					pHair->color1=pHair->moreb1;
					pHair->color2=pHair->moreb2;
					pHair->id1=pHair->moreb3;
					pHair->id2=pHair->moreb4;
					pHair->incognito=false;
				}
			}
		}
		
		if(pc->beardserial>-1)//if beard exists, restore beard style/color
		{
			P_ITEM pBeard = FindItemBySerial(pc->beardserial);
			if(pBeard)
			{
				if(pBeard->incognito) //let's ensure it was marked as under incognito effect
				{
					//restores old beard values
					pBeard->color1=pBeard->moreb1;
					pBeard->color2=pBeard->moreb2;
					pBeard->id1=pBeard->moreb3;
					pBeard->id2=pBeard->moreb4;
					pBeard->incognito=false;
				}
			}
		}
		
		//only refresh once, when poly finished
		teleport(c);
		int socket=calcSocketFromChar(c);//calculate only once
		if (socket!=-1)
		{
			wornitems(socket, c);//send update to current socket
			int j;
			for (j=0;j<now;j++)
			{//and to all inrange sockets (without re-sending to current socket)//AntiChrist
				if (perm[j] && inrange1p(c, currchar[j]) && (j!=socket))
					wornitems(j, c);
			}
		}
		pc->incognito=false;//AntiChrist
	}
}

void checktempeffects()
{
	int j, s, mortar,k,ccc;
	unsigned int i;
	j=uiCurrentTime;
	for(i=0;i<teffectcount;i++)
	{
		if (teffects[i].expiretime<=j)
		{
			s=calcCharFromSer(TE_getDest(i));
			if ((teffects[i].num != 9) && (teffects[i].num != 10) &&
				(teffects[i].num !=17))
			{
				//Added by TANiS to fix errors, memory corruption and door auto-close 10-6-98
				// Check to see if it's a dead char and delete the wrong effect, or if it's just
				// a door auto-close effect and process it the right way.
				if ( ((s < 0) || (s >= cmem)) && (teffects[i].num != 14) && (teffects[i].num != 13) && (teffects[i].num != 9) && (teffects[i].num != 10) )
				{
					memcpy(&teffects[i],&teffects[teffectcount-1],sizeof(teffect_st));
					teffectcount--;
					i--;
					break;
				} //End of TANiS' change
			}
//			P_CHAR pc_s = MAKE_CHARREF_LR(s);	// enabling this reveals a nasty bug I have not found yet: some effects will not work (Duke,13.8.01)
			P_CHAR pc_s = MAKE_CHAR_REF(s);
			int sk;
			switch(teffects[i].num)
			{
			case 1:
				if (pc_s->priv2&0x02)
				{
					pc_s->priv2 &= 0xFD;
					sk=calcSocketFromChar(s);
					if (sk!=-1) sysmessage(sk, "You are no longer frozen.");
					Magic->afterParticles(38, s); 			
				}
				break;
			case 2:
				pc_s->fixedlight='\xFF';
				dolight(calcSocketFromChar(s), worldbrightlevel);
				break;
			case 3:
				pc_s->chgDex(teffects[i].more1);
				statwindow(calcSocketFromChar(s), s);
				break;
			case 4:
				pc_s->in+=teffects[i].more1;
				statwindow(calcSocketFromChar(s), s);
				break;
			case 5:
				pc_s->st+=teffects[i].more1;
				statwindow(calcSocketFromChar(s), s);
				break;
			case 6:
				pc_s->chgDex(-1 * teffects[i].more1);
				pc_s->stm=min(pc_s->stm, (int)pc_s->effDex());
				statwindow(calcSocketFromChar(s), s);
				break;
			case 7:
				pc_s->in-=teffects[i].more1;
				pc_s->mn=min(pc_s->mn, pc_s->in);
				statwindow(calcSocketFromChar(s), s);
				break;
			case 8:
				pc_s->st-=teffects[i].more1;
				pc_s->hp=min(pc_s->hp, pc_s->st);
				statwindow(calcSocketFromChar(s), s);
				break;
			case 9:
				switch(teffects[i].more1)
				{
				case 0:
					if (teffects[i].more2!=0)
					{
						sprintf((char*)temp, "*%s continues grinding.*", pc_s->name);
						npcemoteall(s, (char*)temp,1);
					}
					soundeffect2(s, 0x02, 0x42);
					break;
				}
				break;
			case 10:
				s=calcCharFromSer(teffects[i].sour1, teffects[i].sour2, teffects[i].sour3, teffects[i].sour4);
				mortar=calcItemFromSer(TE_getDest(i));
				if(mortar>-1) //AntiChrist - to prevent crashes
				Skills->CreatePotion(s, teffects[i].more1, teffects[i].more2, mortar);
				break;
			case 11:
				pc_s->st-=teffects[i].more1;
				pc_s->hp=min(pc_s->hp, pc_s->st);
				pc_s->chgDex(-1 * teffects[i].more2);
				pc_s->stm=min(pc_s->stm, (int)pc_s->effDex());
				pc_s->in-=teffects[i].more3;
				pc_s->mn=min(pc_s->mn, pc_s->in);
				statwindow(calcSocketFromChar(s), s);
				break;
			case 12:
				pc_s->st+=teffects[i].more1;
				pc_s->chgDex(teffects[i].more2);
				pc_s->in+=teffects[i].more3;
				statwindow(calcSocketFromChar(s), s);
				break;
			case 13:
				{
				P_ITEM pDoor = FindItemBySerial(TE_getDest(i));// door
				if (pDoor)
				{
					if (pDoor->dooropen==0)
						break;
					pDoor->dooropen=0;
					dooruse(calcSocketFromChar(s), DEREF_P_ITEM(pDoor));
				}
				break;
				}
			case 14: //- training dummies Tauriel check to see if item moved or not before searching for it
				{
				P_ITEM pTrainDummy = FindItemBySerial(TE_getDest(i));
				if (pTrainDummy)
				{
					if (pTrainDummy->id()==0x1071)
					{
						pTrainDummy->setId(0x1070);
						pTrainDummy->gatetime=0;
						RefreshItem(pTrainDummy);//AntiChrist
					}
					else if (pTrainDummy->id()==0x1075)
					{
						pTrainDummy->setId(0x1074);
						pTrainDummy->gatetime=0;
						RefreshItem(pTrainDummy);//AntiChrist
					}
				}
				}
				break;
			case 15: //reactive armor
				pc_s->ra=0;
				break;
			case 16: //Explosion potion messages	Tauriel
				sprintf((char*)temp, "%i", teffects[i].more3);
				sysmessage(calcSocketFromChar(s), (char*)temp); // crashfix, LB
				break;
			case 17: //Explosion potion explosion	Tauriel			
				s=calcCharFromSer(teffects[i].sour1, teffects[i].sour2,
					teffects[i].sour3, teffects[i].sour4);
				explodeitem(calcSocketFromChar(s), calcItemFromSer(TE_getDest(i))); //explode this item
//				explodeitem(calcSocketFromChar(s), teffects[i].itemptr); //explode this item
				break;
			case 18: //Polymorph spell by AntiChrist 9/99
				if(pc_s->polymorph)//let's ensure it's under polymorph effect!
				{
					pc_s->id1=pc_s->xid1;
					pc_s->id2=pc_s->xid2;
					pc_s->polymorph=false;
					teleport(s);
				}
				break;
			case 19: //Incognito spell by AntiChrist 12/99
				reverseIncognito(pc_s);
				break;

			case 20: // LSD potions, LB 5'th nov 1999
				k=calcSocketFromChar(s);
				if (k==-1) return;
				LSD[k]=0;
				sysmessage(k,"LSD has worn off");
				pc_s->stm=3; // stamina near 0
				pc_s->mn=3;
				pc_s->hp=pc_s->hp/7;
				impowncreate(k,s,0);
				all_items(k); // absolutely necassairy here !!!
				for (ccc =0; ccc<charcount; ccc++) // that hurts, but there's no other good way
				{
					if (chardist(s,ccc)<15 && ( online(ccc) || chars[ccc].npc ) ) updatechar(ccc);
				}

			    break;

			case 21:
				int toDrop;
				toDrop = teffects[i].more1; //Effect->more1;
				if( ( pc_s->baseskill[PARRYING] - toDrop ) < 0 )
					pc_s->baseskill[PARRYING] = 0;
				else
					pc_s->baseskill[PARRYING] -= toDrop;
				break;

			case 33: // delayed hiding for gms after flamestrike effect
				k=calcSocketFromChar(s);
				sysmessage(k,"You have hidden yourself well.");
				pc_s->hidden=1;
				updatechar(s);
				break;
				
			case 34: // delayed unhide for gms
				// Changed to be uniform with delayed hideing  (Aldur)
				k = calcSocketFromChar(s); 
				sysmessage(k, "You are now visible."); 
				pc_s->hidden = 0; 
				updatechar(s); 
				break;

			 case 35: //heals some pf - solarin
				int iHp;
				iHp=(int)teffects[i].more1;
				pc_s->hp+=iHp;
				updatestats(s, 0);
				if (!teffects[i].more2)
					tempeffect(s,s,35,teffects[i].more1+1,1,teffects[i].more3,0);
				break;

			default:
				clConsole.send("ERROR: Fallout of switch statement without default(teffects[i].num = %i). TmpEff.cpp, checktempeffects()\n", teffects[i].num); //Morrolan
				break;
			}
			memcpy(&teffects[i],&teffects[teffectcount-1],sizeof(teffect_st));
			teffectcount--;
			i--;

			Items->CheckEquipment(s); //AntiChrist - checks equipments for stats requirements
		}
	}
}

static void reverse_effect(int i)	// i = teffect[i] from checktempeffects()	// Morrolan bugfix
{
	int s = calcCharFromSer(TE_getDest(i));

	P_CHAR pc_s = MAKE_CHARREF_LR(s);
	switch(teffects[i].num)
	{
	case 1:
		pc_s->priv2=pc_s->priv2&0xFD;
		break;
	case 2:
		pc_s->fixedlight='\xFF';
		break;
	case 3:
		pc_s->chgDex(teffects[i].more1);
		break;
	case 4:
		pc_s->in+=teffects[i].more1;
		break;
	case 5:
		pc_s->st+=teffects[i].more1;
		break;
	case 6:
		pc_s->chgDex(-1 * teffects[i].more1);
		break;
	case 7:
		pc_s->in-=teffects[i].more1;
		break;
	case 8:
		pc_s->st-=teffects[i].more1;
		break;
	case 11:
		pc_s->st-=teffects[i].more1;
		pc_s->chgDex(-1 * teffects[i].more2);
		pc_s->in-=teffects[i].more3;
		break;
	case 12:
		pc_s->st+=teffects[i].more1;
		pc_s->chgDex(teffects[i].more2);
		pc_s->in+=teffects[i].more3;
		break;
	case 18: //Polymorph spell by AntiChrist
		if(pc_s->polymorph)
		{
			pc_s->id1=pc_s->xid1;
			pc_s->id2=pc_s->xid2;
			pc_s->polymorph=false;
			teleport(s);
		}
		break;
	case 19: //Incognito spell by AntiChrist
		reverseIncognito(pc_s);
		break;

	case 21:
		int toDrop;
		toDrop = teffects[i].more1; //Effect->more1;
		if( ( pc_s->baseskill[PARRYING] - toDrop ) < 0 )
			pc_s->baseskill[PARRYING] = 0;
		else
			pc_s->baseskill[PARRYING] -= toDrop;
		
	default:
		clConsole.send("ERROR: Fallout of switch statement without default. wolfpack.cpp, reverse_effect()\n"); //Morrolan
		return;
	}//switch
	memcpy(&teffects[i],&teffects[teffectcount-1],sizeof(teffect_st));
	teffectcount--;
	
	Items->CheckEquipment(s); //AntiChrist - checks equipments for stats requirements
}

unsigned char tempeffect(int source, int dest, int num, unsigned char more1, unsigned char more2, unsigned char more3, short dur)
{
	unsigned int ic; // antichrist' changes
	int color, color1, color2, socket; //used for incognito spell
	int	loopexit=0;

	P_CHAR pc_source = MAKE_CHARREF_LRV(source, 0);
	P_CHAR pc_dest   = MAKE_CHARREF_LRV(dest, 0); 
	if (teffectcount>=cmem*5)
		return 0;

	for (ic=0;ic<teffectcount;ic++)	// If there is already an effect of the same or similar kind, reverse it first (Duke)
	{
		if(TE_getDest(ic)==pc_dest->serial)
		{
			if( (teffects[ic].num==3&&num==3)||
				(teffects[ic].num==4&&num==4)||
				(teffects[ic].num==5&&num==5)||
				(teffects[ic].num==6&&num==6)||
				(teffects[ic].num==7&&num==7)||
				(teffects[ic].num==8&&num==8)||
				(teffects[ic].num==11&&num==11)||
				(teffects[ic].num==12&&num==12)||
				(teffects[ic].num==18&&num==18)|| //added Poly reverse - AntiChrist (9/99)
				(teffects[ic].num==21&&num==21)||
				(teffects[ic].num==19&&num==19)|| //added Incognito reverse - AntiChrist (12/99)
				(teffects[ic].num==18&&num==19)|| //reverse poly effect if we have to use incognito - AntiChrist (12/99)
				(teffects[ic].num==19&&num==18) ) reverse_effect(ic); //reverse incognito effect if we have to use poly - AntiChrist (12/99)
		}
	}

	teffects[teffectcount].sour1=pc_source->ser1;
	teffects[teffectcount].sour2=pc_source->ser2;
	teffects[teffectcount].sour3=pc_source->ser3;
	teffects[teffectcount].sour4=pc_source->ser4;
	teffects[teffectcount].dest1=pc_dest->ser1;
	teffects[teffectcount].dest2=pc_dest->ser2;
	teffects[teffectcount].dest3=pc_dest->ser3;
	teffects[teffectcount].dest4=pc_dest->ser4;

	switch (num)
	{
	case 1:
		pc_dest->priv2=pc_dest->priv2|0x02;
		teffects[teffectcount].expiretime=uiCurrentTime+((pc_source->skill[MAGERY]/100)*MY_CLOCKS_PER_SEC);
		teffects[teffectcount].num=1;
		teffects[teffectcount].more1=0;
		teffects[teffectcount].more2=0;
		teffects[teffectcount].dispellable=1;
		break;
	case 2:	// night sight
		pc_dest->fixedlight=worldbrightlevel;
		dolight(calcSocketFromChar(dest), worldbrightlevel);
		Magic->afterParticles(6, dest); // shows particles for UO:3D clients, like On OSI servers

		if(dur > 0)		// if a duration is given (potions), use that (Duke, 30.12.2000)
			teffects[teffectcount].expiretime=uiCurrentTime+(dur*MY_CLOCKS_PER_SEC);
		else
			teffects[teffectcount].expiretime=uiCurrentTime+((pc_source->skill[MAGERY]*10)*MY_CLOCKS_PER_SEC);
		teffects[teffectcount].num=2;
		teffects[teffectcount].more1=0;
		teffects[teffectcount].more2=0;
		teffects[teffectcount].dispellable=1;
		break;
	case 3:
		if (pc_dest->effDex()<more1)
			more1=pc_dest->effDex();
		pc_dest->chgDex(-1 * more1);
		pc_dest->stm=min(pc_dest->stm, (int)pc_dest->effDex());
		statwindow(calcSocketFromChar(dest), dest);
		teffects[teffectcount].expiretime=uiCurrentTime+((pc_source->skill[MAGERY]/10)*MY_CLOCKS_PER_SEC);
		teffects[teffectcount].num=3;
		teffects[teffectcount].more1=more1;
		teffects[teffectcount].more2=0;
		teffects[teffectcount].dispellable=1;
		break;
	case 4:
		if (pc_dest->in<more1)
			more1=pc_dest->in;
		pc_dest->in-=more1;
		pc_dest->mn=min(pc_dest->mn, pc_dest->in);
		statwindow(calcSocketFromChar(dest), dest);
		teffects[teffectcount].expiretime=uiCurrentTime+((pc_source->skill[MAGERY]/10)*MY_CLOCKS_PER_SEC);
		teffects[teffectcount].num=4;
		teffects[teffectcount].more1=more1;
		teffects[teffectcount].more2=0;
		teffects[teffectcount].dispellable=1;
		break;
	case 5:
		if (pc_dest->st<more1)
			more1=pc_dest->st;
		pc_dest->st-=more1;
		pc_dest->hp=min(pc_dest->hp, pc_dest->st);
		statwindow(calcSocketFromChar(dest), dest);
		teffects[teffectcount].expiretime=uiCurrentTime+((pc_source->skill[MAGERY]/10)*MY_CLOCKS_PER_SEC);
		teffects[teffectcount].num=5;
		teffects[teffectcount].more1=more1;
		teffects[teffectcount].more2=0;
		teffects[teffectcount].dispellable=1;
		break;
	case 6:
		if (pc_dest->effDex()+more1>250)
			more1=250-pc_dest->effDex();
		pc_dest->chgDex(more1);
		statwindow(calcSocketFromChar(dest), dest);
		if(dur > 0)		// if a duration is given (potions), use that (Duke, 31.10.2000)
			teffects[teffectcount].expiretime=uiCurrentTime+(dur*MY_CLOCKS_PER_SEC);
		else
			teffects[teffectcount].expiretime=uiCurrentTime+((pc_source->skill[MAGERY]/10)*MY_CLOCKS_PER_SEC);
		teffects[teffectcount].num=6;
		teffects[teffectcount].more1=more1;
		teffects[teffectcount].more2=0;
		teffects[teffectcount].dispellable=1;
		break;
	case 7:
		if (pc_dest->in+more1>255)
			more1=pc_dest->in-255;
		pc_dest->in+=more1;
		statwindow(calcSocketFromChar(dest), dest);
		teffects[teffectcount].expiretime=uiCurrentTime+((pc_source->skill[MAGERY]/10)*MY_CLOCKS_PER_SEC);
		teffects[teffectcount].num=7;
		teffects[teffectcount].more1=more1;
		teffects[teffectcount].more2=0;
		teffects[teffectcount].dispellable=1;
		break;
	case 8:
		if (pc_dest->st+more1>255)
			more1=pc_dest->st-255;
		pc_dest->st+=more1;
		statwindow(calcSocketFromChar(dest), dest);
		if(dur > 0)		// if a duration is given (potions), use that (Duke, 31.10.2000)
			teffects[teffectcount].expiretime=uiCurrentTime+(dur*MY_CLOCKS_PER_SEC);
		else			// else use caster's skill
			teffects[teffectcount].expiretime=uiCurrentTime+((pc_source->skill[MAGERY]/10)*MY_CLOCKS_PER_SEC);
		teffects[teffectcount].num=8;
		teffects[teffectcount].more1=more1;
		teffects[teffectcount].more2=0;
		teffects[teffectcount].dispellable=1;
		break;
	case 9:
		teffects[teffectcount].expiretime=uiCurrentTime+(more2*MY_CLOCKS_PER_SEC);
		teffects[teffectcount].num=9;
		teffects[teffectcount].more1=more1;
		teffects[teffectcount].more2=more2;
		teffects[teffectcount].dispellable=0;
		break;
	case 10:
		teffects[teffectcount].expiretime=uiCurrentTime+(12*MY_CLOCKS_PER_SEC);
		teffects[teffectcount].dispellable=0;
		teffects[teffectcount].more1=more1;
		teffects[teffectcount].more2=more2;
		teffects[teffectcount].num=10;
		break;
	case 11: // Bless
		if (pc_dest->st+more1>255)
			more1=pc_dest->st-255;
		if (pc_dest->effDex()+more2>250)
			more2=250-pc_dest->effDex();
		if (pc_dest->in+more3>255)
			more3=pc_dest->in-255;
		pc_dest->st+=more1;
		pc_dest->chgDex(more2);
		pc_dest->in+=more3;
		statwindow(calcSocketFromChar(dest), dest);
		teffects[teffectcount].expiretime=uiCurrentTime+((pc_source->skill[MAGERY]/10)*MY_CLOCKS_PER_SEC);
		teffects[teffectcount].num=11;
		teffects[teffectcount].more1=more1;
		teffects[teffectcount].more2=more2;
		teffects[teffectcount].more3=more3;
		teffects[teffectcount].dispellable=1;
		break;
	case 12: // Curse
		if (pc_dest->st<more1)
			more1=pc_dest->st;
		if (pc_dest->effDex()<more2)
			more2=pc_dest->effDex();
		if (pc_dest->in<more3)
			more3=pc_dest->in;
		pc_dest->st-=more1;
		pc_dest->chgDex(-1 * more2);
		pc_dest->in-=more3;
		statwindow(calcSocketFromChar(dest), dest);
		teffects[teffectcount].expiretime=uiCurrentTime+((pc_source->skill[MAGERY]/10)*MY_CLOCKS_PER_SEC);
		teffects[teffectcount].num=12;
		teffects[teffectcount].more1=more1;
		teffects[teffectcount].more2=more2;
		teffects[teffectcount].more3=more3;
		teffects[teffectcount].dispellable=1;
		break;
	case 15: // Reactive armor
		teffects[teffectcount].expiretime=uiCurrentTime+((pc_source->skill[MAGERY]/10)*MY_CLOCKS_PER_SEC);
		teffects[teffectcount].num=15;
		teffects[teffectcount].dispellable=1;
		break;
	case 16: //Explosion potions	Tauriel
		teffects[teffectcount].expiretime=uiCurrentTime+(more2*MY_CLOCKS_PER_SEC);
		teffects[teffectcount].num=16;
		teffects[teffectcount].more1=more1; //item/potion
		teffects[teffectcount].more2=more2; //seconds
		teffects[teffectcount].more3=more3; //countdown#
		teffects[teffectcount].dispellable=0;
		break;
	case 18: //Polymorph - AntiChrist 09/99
		teffects[teffectcount].expiretime=uiCurrentTime+(polyduration*MY_CLOCKS_PER_SEC);
		teffects[teffectcount].num=18;
		teffects[teffectcount].dispellable=0;

		int c1,b,k;
		//Grey flag when polymorphed - AntiChrist (9/99)
		pc_dest->crimflag=(polyduration*MY_CLOCKS_PER_SEC)+uiCurrentTime;
		if(pc_dest->onhorse) k=unmounthorse(dest);
		k=(more1<<8)+more2;

		pc_dest->xid1=pc_dest->id1;//let's backup previous id
		pc_dest->xid2=pc_dest->id2;

		if (k>=0x000 && k<=0x3e1) // lord binary, body-values >0x3e crash the client
		{
			pc_dest->id1=k>>8; // allow only non crashing ones
			pc_dest->id2=k%256;

			c1 = pc_dest->skin; // transparency for monsters allowed, not for players,
														 // if polymorphing from monster to player we have to switch from transparent to semi-transparent
			b=c1&0x4000;
			if (b==16384 && (k >=0x0190 && k<=0x03e1))
			{
				if (c1!=0x8000)
				{
					pc_dest->skin = pc_dest->xskin = 0xF000;
				}
			}
		}
		pc_dest->polymorph=true;
		break;
	case 19://incognito spell - AntiChrist (10/99)//revised by AntiChrist - 9/12/99
		teffects[teffectcount].expiretime=uiCurrentTime+(90*MY_CLOCKS_PER_SEC);//90 seconds
		teffects[teffectcount].num=19;
		teffects[teffectcount].dispellable=0;

		//AntiChrist 11/11/99
		//If char is already under polymorph effect, let's reverse the
		//polymorph effect to avoid problems
		if(pc_dest->polymorph)
		{
			pc_dest->id1=pc_dest->xid1;
			pc_dest->id2=pc_dest->xid2;
			pc_dest->polymorph=false;
			teleport(dest);
		}
		int j,i,ci;
		i=dest;

		//first: let's search for beard and hair serial
		//(we could use alredy saved serials...but it's better
		//to recalculate them)
		pc_dest->hairserial=-1;
		pc_dest->beardserial=-1;

		ci=0;
		loopexit=0;
		P_ITEM pi;
		while ( ((pi=ContainerSearch(pc_dest->serial,&ci)) != NULL) && (++loopexit < MAXLOOPS) )
		{
			if(pi->layer==0x10)//beard
				pc_dest->beardserial=pi->serial;
			if(pi->layer==0x0B)//hairs
				pc_dest->hairserial=pi->serial;
		}

		// ------ SEX ------
		pc_dest->xid1=pc_dest->id1;
		pc_dest->xid2=pc_dest->id2;
		pc_dest->id1=0x01;
		//if we already have a beard..can't turn to female
		if(chars[i].beardserial>-1)
		{//if character has a beard...only male
			pc_dest->id2='\x90';//male
		} else
		{//if no beard let's randomly change
			if((rand()%2)==0) pc_dest->id2='\x90';//male
			else pc_dest->id2='\x91';//or female
		}

		// --- SKINCOLOR ---
		pc_dest->xskin = pc_dest->skin;
		color=rand()%6;
		switch(color)
		{
			case 0:				pc_dest->skin = 0x83EA;				break;
			case 1:				pc_dest->skin = 0x8405;				break;
			case 2:				pc_dest->skin = 0x83EF;				break;
			case 3:				pc_dest->skin = 0x83F5;				break;
			case 4:				pc_dest->skin = 0x841C;				break;
			case 5:				pc_dest->skin = 0x83FB;				break;
			default:												break;
		}

		// ------ NAME -----
		strcpy(pc_dest->orgname,pc_dest->name);

		if(pc_dest->id2==0x90) setrandomname(dest,"1");//get a name from male list
		else setrandomname(dest,"2");//get a name from female list

		//
		//damn..this formula seems to include also some bad color...
		//i'll test this later
		//AntiChrist
		//
		//use unique color for hair&beard
		//color=0x044E+(rand()%(0x04AD-0x044E));

		//i had to track down some valid value
		//for hair/beard colors, cause that
		//formula contained some bad value =(
		//but now it works perfectly :)
		//AntiChrist-11/11/99
		color=rand()%8;
		switch(color)
		{
			case 0:	color=0x044e;	break;
			case 1:	color=0x0455;	break;
			case 2:	color=0x045e;	break;
			case 3:	color=0x0466;	break;
			case 4:	color=0x046a;	break;
			case 5:	color=0x0476;	break;
			case 6:	color=0x0473;	break;
			case 7:	color=0x047c;	break;
			default://it should not go here...but..who nows =P
				color=0x044e;
		}
		color1=color>>8;
		color2=color%256;

		// ------ HAIR -----
		if(pc_dest->hairserial>-1)//if hairs exist
		{//change hair style/color
			P_ITEM pHair = FindItemBySerial(pc_dest->hairserial);
			if(pHair)
			{
				//stores old hair values...
				pHair->moreb1=pHair->color1;
				pHair->moreb2=pHair->color2;
				pHair->moreb3=pHair->id1;
				pHair->moreb4=pHair->id2;

				//and change them with random ones
				switch(rand()%10)
				{
					case 0: pHair->id2='\x3B'; break;
					case 1: pHair->id2='\x3C'; break;
					case 2:	pHair->id2='\x3D'; break;
					case 3:	pHair->id2='\x44'; break;
					case 4:	pHair->id2='\x45'; break;
					case 5:	pHair->id2='\x46'; break;
					case 6:	pHair->id2='\x47'; break;
					case 7:	pHair->id2='\x48'; break;
					case 8:	pHair->id2='\x49'; break;
					case 9:	pHair->id2='\x4A'; break;
					default: pHair->id2='\x4A'; break;
				}

				//random color
				pHair->color1=color>>8;
				pHair->color2=color%256;
				//let's check for invalid values
				if ((((pHair->color1<<8)+pHair->color2)<0x044E) ||
					(((pHair->color1<<8)+pHair->color2)>0x04AD) )
				{
					pHair->color1=0x04;
					pHair->color2=0x4E;
				}

				pHair->incognito=true;//AntiChrist
			}//if j!=-1
		}//if hairserial!=-1


		// -------- BEARD --------
		if(pc_dest->id2==0x90)// only if a man
		if(pc_dest->beardserial>-1)//if beard exist
		{//change beard style/color
			P_ITEM pBeard = FindItemBySerial(pc_dest->beardserial);
			if(pBeard)
			{
				//clConsole.send("BEARD FOUND!!\n");
				//stores old beard values
				pBeard->moreb1=pBeard->color1;
				pBeard->moreb2=pBeard->color2;
				pBeard->moreb3=pBeard->id1;
				pBeard->moreb4=pBeard->id2;

				//changes them with random ones
				switch(rand()%7)
				{
					case 0: pBeard->id2='\x3E'; break;
					case 1: pBeard->id2='\x3F'; break;
					case 2:	pBeard->id2='\x40'; break;
					case 3:	pBeard->id2='\x41'; break;
					case 4:	pBeard->id2='\x4B'; break;
					case 5:	pBeard->id2='\x4C'; break;
					case 6:	pBeard->id2='\x4D'; break;
					default:pBeard->id2='\x4D'; break;
				}

				//random color
				pBeard->color1=color>>8;
				pBeard->color2=color%256;

				if ((((pBeard->color1<<8)+pBeard->color2)<0x044E) ||
					(((pBeard->color1<<8)+pBeard->color2)>0x04AD) )
				{
					pBeard->color1=0x04;
					pBeard->color2=0x4E;
				}

				pBeard->incognito=true;//AntiChrist
			}//if j!=-1
		}//if beardserial!=-1

		//only refresh once
		teleport(dest);

		socket=calcSocketFromChar(dest);

		wornitems(socket, dest);//send update to current socket

		for (j=0;j<now;j++)
		{//and to all inrange sockets (without re-sending to current socket)//AntiChrist
			if (perm[j] && inrange1p(dest, currchar[j]) && (j!=socket))
				wornitems(j, dest);
		}

		pc_dest->incognito=true;//AntiChrist
		break;

	case 20: // LSD potions, LB 5'th nov 1999
		k=calcSocketFromChar(source);
		if (k==-1) return 0;
		sysmessage(k,"Hmmm, tasty, LSD");
		LSD[k]=1;
		pc_source->hp=pc_source->st;
		pc_source->mn=pc_source->in;
		impowncreate(k,source,0);
		teffects[teffectcount].expiretime=uiCurrentTime+(90*MY_CLOCKS_PER_SEC);//90 seconds
		teffects[teffectcount].num=20;
		teffects[teffectcount].dispellable=0;
		break;

	case 21:		// protection
		teffects[teffectcount].expiretime=uiCurrentTime+(12*MY_CLOCKS_PER_SEC);
		teffects[teffectcount].dispellable=1;
		teffects[teffectcount].more1=more1;
		teffects[teffectcount].num=21;
		pc_dest->baseskill[PARRYING] += more1;
		break;

	case 33: // gm hiding
		teffects[teffectcount].expiretime=uiCurrentTime+(more1*MY_CLOCKS_PER_SEC);
		teffects[teffectcount].dispellable=0;
		teffects[teffectcount].more1=more1;
		teffects[teffectcount].num=33;
		break;

	case 34: // gm un hiding
		teffects[teffectcount].expiretime=uiCurrentTime+(more1*MY_CLOCKS_PER_SEC);
		teffects[teffectcount].dispellable=0;
		teffects[teffectcount].more1=more1;
		teffects[teffectcount].num=34;
		break;

	case 35:
	    //heals some hp in 9 seconds - Solarin
		k=calcSocketFromChar(source);
		teffects[teffectcount].expiretime=uiCurrentTime+(more3*MY_CLOCKS_PER_SEC);
		if (!more2)
			sysmessage(k,"You start healing yourself...");
		else
			sysmessage(k,"You continue to heal...");

		teffects[teffectcount].num=35;
		teffects[teffectcount].more1=more1; //hp to give back
		teffects[teffectcount].more2=more2; //# of call to decide which string to display on checktempeffect
		teffects[teffectcount].more3=more3; //delay#
		teffects[teffectcount].dispellable=0;
		break;

	case 44: // special fencing paralyzation -Frazurbluu-
		pc_dest->priv2=pc_dest->priv2|0x02;
		teffects[teffectcount].expiretime=uiCurrentTime+(5*MY_CLOCKS_PER_SEC);
		teffects[teffectcount].num=1;
		teffects[teffectcount].more1=0;
		teffects[teffectcount].more2=0;
		teffects[teffectcount].dispellable=0;
		break;

	case 45: // special sword use concussion intelligence loss -Frazurbluu-
		if (pc_dest->in<more1)
			more1=pc_dest->in;
		pc_dest->in-=more1;
		pc_dest->mn=min(pc_dest->mn, pc_dest->in);
		statwindow(calcSocketFromChar(dest), dest);
		teffects[teffectcount].expiretime=uiCurrentTime+(30*MY_CLOCKS_PER_SEC);
		teffects[teffectcount].num=4;
		teffects[teffectcount].more1=more1;
		teffects[teffectcount].more2=0;
		teffects[teffectcount].dispellable=0;
		break;

	default:
		LogErrorVar("Fallout of switch! Value (%d)",num);
		return 0;
	}
	teffectcount++;
	return 1;
}

unsigned char tempeffect2(int source, P_ITEM piDest, int num, unsigned char more1, unsigned char more2, unsigned char more3)
{
	
	if (teffectcount>(cmem*5)) return 0;

	P_CHAR pc_source = MAKE_CHARREF_LRV(source, 0);

	teffects[teffectcount].sour1=pc_source->ser1;
	teffects[teffectcount].sour2=pc_source->ser2;
	teffects[teffectcount].sour3=pc_source->ser3;
	teffects[teffectcount].sour4=pc_source->ser4;
	teffects[teffectcount].dest1=piDest->ser1;
	teffects[teffectcount].dest2=piDest->ser2;
	teffects[teffectcount].dest3=piDest->ser3;
	teffects[teffectcount].dest4=piDest->ser4;
	switch (num)
	{
	case 10:
		teffects[teffectcount].expiretime=uiCurrentTime+(12*MY_CLOCKS_PER_SEC);
		teffects[teffectcount].dispellable=0;
		teffects[teffectcount].more1=more1;
		teffects[teffectcount].more2=more2;
		teffects[teffectcount].num=10;
		break;
	case 13:
		if (piDest->dooropen)
		{
			piDest->dooropen=0;
			return 0;
		}
		teffects[teffectcount].expiretime=uiCurrentTime+(10*MY_CLOCKS_PER_SEC);
		teffects[teffectcount].num=13;
		teffects[teffectcount].dispellable=0;
		piDest->dooropen=1;
		break;
	case 14: //Tauriel training dummies swing for 5(?) seconds
		teffects[teffectcount].expiretime=uiCurrentTime+(5*MY_CLOCKS_PER_SEC);
		teffects[teffectcount].num=14;
		teffects[teffectcount].dispellable=0;
		teffects[teffectcount].more2=0;
		break;
	case 17: //Explosion potion (explosion)	Tauriel (explode in 4 seconds)
		teffects[teffectcount].expiretime=uiCurrentTime+(4*MY_CLOCKS_PER_SEC);
		teffects[teffectcount].num=17;
		teffects[teffectcount].more1=more1;
		teffects[teffectcount].more2=more2;
		teffects[teffectcount].dispellable=0;
		break;
	default:
		clConsole.send("ERROR: Fallout of switch statement without default. TmpEff.cpp, tempeffect2()\n"); //Morrolan
		return 0;
	}
	teffectcount++;
	return 1;
}
