
#ifndef __ACCOUNTS_H__
#define __ACCOUNTS_H__
//Platform specifics
#include "platform.h"


//System include

#include "stl_headers_start.h"
#include <fstream>
#include <string>
#include <map>
#include <sys/stat.h>
#include "stl_headers_end.h"

using namespace std;

// Third Party


// Forward Class declaration
class cAccount;


// Wolfpack Includes

#include "wolfpack.h"
#include "debug.h"



// Authenticate return codes

#define LOGIN_NOT_FOUND -3
#define BAD_PASSWORD -4
#define ACCOUNT_BANNED -5
#define ACCOUNT_WIPE -6


using namespace std;
struct account_st
{
	unsigned int number;
	string name;
	string pass;
	bool ban;
	bool remoteadmin;
};

class cAccount
{
private:
	map<string, account_st> acctlist;
	map<int, string> acctnumbers_sp;

	struct acctman_st {
		bool online;
		CHARACTER character;
	};
	map<int, acctman_st> acctman;
	int lastusedacctnum;
	unsigned int unsavedaccounts;
	unsigned int saveratio;

	void LoadAccount ( int acctnumb );
public:
	unsigned int lasttimecheck;

	cAccount( void );
	~cAccount( void );
	void SetSaveRatio ( int );
	bool IsOnline( int );
	CHARACTER GetInWorld( int );
	void SetOnline( int, CHARACTER );
	void SetOffline( int acctnum );
	void LoadAccounts( void );
	void SaveAccounts( void );
	void CheckAccountFile(void);
	int Count();
	bool RemoteAdmin(int acctnum);
	signed int Authenticate(string username, string password);
	unsigned int CreateAccount(string username, string password);
};


#endif // __ACCOUNTS_H__

