#if !defined(__BOATS_H__)
#define __BOATS_H__

// Platform specifics
#include "platform.h"


// System Includes

#include "stl_headers_start.h"
#include <iostream>
#include <cmath>
#include "stl_headers_end.h"

using namespace std ;


// Forward class Declaration

class cBoat;

// Wolfpack files
#include "wolfpack.h"
#include "SndPkg.h"
#include "boats.h"

//For iSizeShipOffsets->
#define PORT_PLANK 0
#define STARB_PLANK 1
#define HOLD 2
#define TILLER 3

//For iShipItems->
#define PORT_P_C 0//Port Plank Closed
#define PORT_P_O 1//Port Planl Opened
#define STAR_P_C 2//Starboard Plank Closed
#define STAR_P_O 3//Starb Plank Open
#define TILLERID 5//Tiller
#define HOLDID 4//Hold

extern signed short int iSmallShipOffsets[4][4][2];
extern signed short int iMediumShipOffsets[4][4][2];
extern signed short int iLargeShipOffsets[4][4][2];
extern char cShipItems[4][6];


class cBoat 
{
	private:
		void LeaveBoat(int, int);		
		bool Block(int, short int, short int,int);
		void TurnStuff(int, int, int, int);

	public:
		cBoat();
		int GetBoat(int);
		virtual ~cBoat();
		char Speech(int, char *);
		//void Speech(int, char *);
		void OpenPlank(int);
		void PlankStuff(int, int);
		bool Build(int, int, char);
		void Move(int, int, int);
		void Turn(int, int);
};
#endif

