// WOLFPACK - Bounty System
// FILE - bounty.cpp
// DATE - July 17, 2000
//   By - Dupois (dupois@home.com)
//
#include "bounty.h"

#undef  DBGFILE
#define DBGFILE "bounty.cpp"

//////////////////////////////////////////////////////////////////////////////
// FUNCTION:    BountyAskVictim( int nVictimSerial, int nMurdererSerial )
//
// PURPOSE:     Used to ask the murder victim whether they would like to place
//              a bounty on the head of the murderer.
// 
// PARAMETERS:  nVictimSerial   Victim characters serial number
//              nMurdererSerial Murderer characters serial number
//
// RETURNS:     void
//////////////////////////////////////////////////////////////////////////////
void BountyAskVictim( int nVictimSerial, int nMurdererSerial )
{
  int nAmount     = 0;
  int nVictimIdx  = calcCharFromSer( nVictimSerial );
  int nMurderIdx  = calcCharFromSer( nMurdererSerial );
  int err2;
 
  PC_CHAR pcc_nVictimIdx=MAKE_CHARREF_LOGGED(nVictimIdx,err);
  PC_CHAR pcc_nMurderIdx=MAKE_CHARREF_LOGGED(nMurderIdx,err2);

  if (err || err2) return;

  // Indicate that the victim is being asked if they want to place a bounty
  sprintf((char*)temp, "BountyAskVictim():  %s is attempting to place a bounty of %i on %s\n",
          pcc_nVictimIdx->name, nAmount, pcc_nMurderIdx->name );
  LogMessage((char*)temp);

  // If the amount of the bounty is larger than zero, create a bounty posting
  if( nAmount > 0 )
  {
     if( BountyCreate( pcc_nMurderIdx->serial, nAmount ) )
	 {
         sprintf((char*)temp, "BountyAskVictim():  %s has placed a bounty of %i on %s\n",
                pcc_nVictimIdx->name,
                nAmount,
                pcc_nMurderIdx->name );
		 LogMessage((char*)temp);
	 }

     else
	 {
       sprintf((char*)temp, "BountyAskVictim():  %s FAILED to place a bounty of %i on %s\n",
               pcc_nVictimIdx->name,
               nAmount,
               pcc_nMurderIdx->name );
	   LogMessage((char*)temp);
	 }
  }

  return;

} // BountyAskVictim()


//////////////////////////////////////////////////////////////////////////////
// FUNCTION:    BountyCreate( int nMurdererSerial, int nRewardAmount )
//
// PURPOSE:     Used to create the bounty posting message on the global
//              bulletin board for all to see.
// 
// PARAMETERS:  nMurdererSerial Murderer characters serial number
//              nRewardAmount   Bounty placed on the murderers head
//
// RETURNS:     TRUE  Bounty post successfully created
//              FALSE Bounty post could not be created
//////////////////////////////////////////////////////////////////////////////
bool BountyCreate( int nMurdererSerial, int nRewardAmount )
{
  int   nIndex      = calcCharFromSer( nMurdererSerial );
  int   nPostSerial = 0;
  
  P_CHAR pc_nIndex = MAKE_CHARREF_LOGGED(nIndex,err);
  if (err) return false;

  // Check that we have a reward amount greater than zero
  if( nRewardAmount > 0 )
  {
    // Check that this murderer doesn't already have a bounty on them
    if( pc_nIndex->questBountyReward > 0 )
    {
      // This murderer already has a bounty on them because they 
      // have a reward amount on their head, so delete old bounty
      // and add the new (updated) one
      nRewardAmount += pc_nIndex->questBountyReward;
      BountyDelete( nMurdererSerial );
    }

    // Attempt to post the message first
    pc_nIndex->questBountyReward = nRewardAmount;
    nPostSerial = MsgBoardPostQuest( nMurdererSerial, BOUNTYQUEST );

    // If we received a valid serial number then the post was successfull
    if( nPostSerial > 0 )
    {
      pc_nIndex->questBountyPostSerial = nPostSerial;
      return true;
    }
  }

  // Failed to post bounty
  sprintf((char*)temp, "BountyCreate():  FAILED to place a bounty of %i on %s (PostSerial=%x)\n",
          nRewardAmount,
          pc_nIndex->name,
          nPostSerial );
  LogWarning((char*)temp);

  // Post must have failed
  return false;

} // BountyCreate()


bool BountyDelete( int nMurdererSerial )
{
  bool  bReturn = true;
  int   nIndex  = calcCharFromSer( nMurdererSerial );

  P_CHAR pc_nIndex=MAKE_CHARREF_LOGGED(nIndex, err);
  if (err) return false;


  // Find and mark the post associated with this bounty as deleted
  // so that the bulletin board maintenance routine can clean it up
  bReturn = MsgBoardRemoveGlobalPostBySerial( pc_nIndex->questBountyPostSerial );

  // Reset all bounty values for this character
  pc_nIndex->questBountyReward     = 0;
  pc_nIndex->questBountyPostSerial = 0;

  return bReturn;

} // BountyDelete()


bool BountyWithdrawGold( P_CHAR pVictim, int nAmount )
{
	int has = pVictim->CountBankGold();
	if (has < nAmount)
		return false;

	P_ITEM pBox = pVictim->GetBankBox();
	if (!pBox)
		return false;	// shouldn't happen coz it's needed in CountBankGold...

	pBox->DeleteAmount(nAmount,0x0EED);
	return true;
}
/*
bool BountyWithdrawGold( int nVictimSerial, int nAmount )
{
  unsigned int counter1;
  int j,serhash,ci;
  long int goldCount = 0;
 // int nIndex = calcCharFromSer( nVictimSerial );
 // int err;


  serhash = nVictimSerial%HASHMAX;
  
  for( ci = 0; ci < ownsp[serhash].max; ci++ )
	{
    j = ownsp[serhash].pointer[ci];

    if (j!=-1)
  	{
      if( ( items[j].ownserial == nVictimSerial ) &&
          ( items[j].type      == 1             ) &&
          ( items[j].morex     == 1             ) &&
          ( items[j].layer     == 0x1D          )    ) // bank box
      {
        for( counter1 = 0; counter1 < itemcount; counter1++ )
        {
          if( items[counter1].contserial == items[j].serial )
          {
            if( items[counter1].id() == 0x0EED )
            {
              goldCount += items[counter1].amount;
            }
          }
        }
      }
    }
  }

  // Check that the victim has the gold for the bounty
  if( goldCount >= nAmount )
  {
    int nRequired = nAmount;

    for( ci = 0; ci < ownsp[serhash].max; ci++ )
	  {
      j = ownsp[serhash].pointer[ci];

      if (j!=-1)
  	  {
        if( ( items[j].ownserial == nVictimSerial ) &&
            ( items[j].type      == 1             ) &&
            ( items[j].morex     == 1             ) &&
            ( items[j].layer     == 0x1D          )    ) // bank box
        {
          for( counter1 = 0; counter1 < itemcount; counter1++ )
          {
            if( items[counter1].contserial == items[j].serial )
            {
              if( items[counter1].id1 == 0x0EED )
              {
                // If this pile of gold is larger than the amount needed
                // then subtract the amount and exit
                if( items[counter1].amount > nRequired )
                {
                  items[counter1].amount -= nRequired;
                  nRequired = 0;
                  break;
                }
                else
                {
                  // This pile of gold isn't enough so take the pile 
                  // and delete the item
                  nRequired -= items[counter1].amount;
                  Items->DeleItem(counter1);
                }
              }
            }
          }

          // If we have removed all of the gold, then return
          if( nRequired <= 0 )
            return true;
        }
      }
    }
  }

  return false;

} // BountyWithdrawGold()

*/
