#if !defined (__BOUNTY_H__)
#define __BOUNTY_H__

// WOLFPACK - Bounty System
// FILE - bounty.h
// DATE - July 17, 2000
//   By - Dupois (dupois@home.com)
//
// Platform Specific
#include "platform.h"

// System includes

#include "stl_headers_start.h"
#include <iostream>
#include "stl_headers_end.h"

using namespace std ;

// Forward Class Declaration


// Wolfpack includes
#include "wolfpack.h"
#include "bounty.h"


// Ask victim if they want to post a bounty on the
// murderer, and if so, then return the amount of the
// reward they want to place on the murderers head.
void BountyAskVictim  ( int nVictimSerial,
                        int nMurdererSerial );

// Create the bounty on the murderer
bool BountyCreate     ( int nMurdererSerial,
                        int nRewardAmount );

// Remove the bounty from the murderer
bool BountyDelete     ( int nMurdererSerial );

// Check and then withdraw the bounty amount
bool BountyWithdrawGold( P_CHAR pVictim, int nAmount );

#endif

