#ifndef __CHAR_ARRAY
#define __CHAR_ARRAY

#include "wolfpack.h" // needs global var schei___ and item_st *TYPE*
#include "debug.h"    // for logg macro

// typedefs

typedef       cChar *P_CHAR;
typedef const cChar *PC_CHAR;

// macros

#define MAKE_CHAR_REF(i) CharArray->MakeCharref(i)
#define LOG_INVALID_C_REF(err,meSSage) if(err=CharArray->GetError()) { strcpy(schei___, meSSage); strcat(schei___," errorcode:%i\n"); LogCritical(schei___ _ err); } // strcpy stuff to prevent const string crashes 
#define GET_C_ERROR(err) err=CharArray->GetError()

#define MAKE_CHARREF_LOGGED(i,err)  CharArray->MakeCharref(i); err=CharArray->GetError(); if (err) { strcpy(schei___, "invalid char index "); strcat(schei___," errorcode:%i\n"); LogCritical(schei___ _ err); } 
#define MAKE_CHARREF_C(i)			CharArray->MakeCharref(i); int err=CharArray->GetError(); if (err) { continue;}
#define MAKE_CHARREF_LR(i)			CharArray->MakeCharref(i); {int err=CharArray->GetError(); if (err) { strcpy(schei___, "invalid char index <%i>\n"); LogCritical(schei___ _ i); return;} }
#define MAKE_CHARREF_LRV(i,retval)	CharArray->MakeCharref(i); {int err=CharArray->GetError(); if (err) { strcpy(schei___, "invalid char index <%i>\n"); LogCritical(schei___ _ i); return retval;} }

#define DEREF_P_CHAR(pc) ((pc-realchars)-C_W_O_1)
// class definiton

class cCharArray
{
   private:
		int error;

   public:		
	    inline int GetError() { return error; }
		P_CHAR MakeCharref(CHARACTER i);

		cCharArray() ;
		virtual ~cCharArray();

};

#endif

