// dragdrop.cpp: implementation of dragging and dropping
// cut from wolfpack.cpp by Duke, 23.9.2000
//////////////////////////////////////////////////////////////////////

#include "debug.h"
#include "basics.h"
#include "wolfpack.h"
#include "SndPkg.h"
#include "speech.h"
#include "itemid.h"
#include "bounty.h"

#undef  DBGFILE
#define DBGFILE "dragdrop.cpp"

//#include "dragdrop.h"

typedef struct _PKGx08
{
//0x08 Packet
//Drop Item(s) (14 bytes) 
//* BYTE cmd 
//* BYTE[4] item id 
	long Iserial;
//* BYTE[2] xLoc 
	short TxLoc;
//* BYTE[2] yLoc 
	short TyLoc;
//* BYTE zLoc 
	signed char TzLoc;
//* BYTE[4] Move Into (FF FF FF FF if normal world) 
	long Tserial;
} PKGx08;

// moved here from cWeight by Duke, 12.5.2001 (not sure what this is good for ...:((
// if the item is equipped or in primary backpack return true
static bool CheckWhereItem( int pack, P_ITEM pi, int s)
{
	if (pi && pack!=-1 && s!=-1) //LB
	{
		if (!( pi->contserial==items[pack].serial ||
			chars[currchar[s]].Wears(pi)))
			
			return 1;
		else
			return 0;
	}
	return 0;
}

void UpdateStatusWindow(UOXSOCKET s, P_ITEM pi)
{
	int packnum=packitem(currchar[s]);
	if (CheckWhereItem(packnum, pi, s))
		statwindow(s,currchar[s]);
}

static void Sndbounce5(UOXSOCKET s)
{
	bounce[1]=5;
	Xsend(s, bounce, 2);
}
// Name:	item_bounce3
// Purpose:	holds some statements that were COPIED some 50 times
// Remarks:	temporary functions to revamp the 30 occurences of the 'bouncing bugfix'
// History:	init Duke, 10.8.2000
static void item_bounce3(const P_ITEM pi)
{
	pi->SetContSerial(pi->oldcontserial);
	pi->x=pi->oldx;
	pi->y=pi->oldy;
	pi->z=pi->oldz;
	pi->layer=pi->oldlayer;
	P_CHAR pc = FindCharBySerial(pi->oldcontserial);

	if (pi->layer > 0 && pc != NULL)
	{
		pc->st += pi->st2;
		pc->chgDex(pi->dx2);
		pc->in += pi->in;
	}
}

static void item_bounce4(const UOXSOCKET s, const P_ITEM pi)
{
	item_bounce3(pi);
	if (pi->id1>=0x40)
		senditem(s, pi);
}

static void item_bounce5(const UOXSOCKET s, const P_ITEM pi)
{
	item_bounce3(pi);
	if(pi->isInWorld())
	{
		if (pi->id1>=0x40)
			senditem(s, pi);
	}
	else
		senditem(s, pi);
}

static void item_bounce6(const P_CLIENT ps, const P_ITEM pi)
{
	UOXSOCKET s=ps->GetSocket();
	Sndbounce5(s);
	if (ps->IsDragging())
	{
		ps->ResetDragging();
		item_bounce4(s,pi);
	}
}


// this function SCREAMES for a rewrite !! LB !!

void get_item(P_CLIENT ps) // Client grabs an item
{
	int x,  npc=-1, c, amount, update = 0, serial;
	tile_st tile;
	int z;// antichrist for trade fix
	UOXSOCKET s = ps->GetSocket();
	int cc = ps->GetCurrChar();
	P_CHAR pc_currchar = MAKE_CHARREF_LR(cc);
	
	
	serial = calcserial(buffer[s][1], buffer[s][2], buffer[s][3], buffer[s][4]);
	if (serial==-1 || buffer[s][1] < 0x40)
		return;	// landscape or a character
	const PC_ITEM pi = FindItemBySerial(serial);
	if (pi == NULL)
		return;
	
	pc_currchar->disturbMed(s); // Meditation
	
	// Zippy's stealing changes  
	int i = DEREF_P_ITEM(pi);
	x = DEREF_P_ITEM(pi);
	if (!items[x].isInWorld())  // Find character owning item
	{
		int loopexit = 0;
		do  // Find character owning item
		{
			if (isCharSerial(items[x].contserial))
			{
				npc = calcCharFromSer(items[x].contserial);
			}
			else  // its an item
			{
				if (items[x].isInWorld())
				{
					npc=-1;
					break;
				}
				x = calcItemFromSer(items[x].contserial);
				// ANTICHRIST -- SECURE TRADE FIX
				if (x!=-1) // LB overwriting x is essential here, dont change it!!!
				{
					if (items[x].layer == 0 && items[x].id() == 0x1E5E)
					{
						// Trade window???
						serial = calcserial(items[x].moreb1, items[x].moreb2, items[x].moreb3, items[x].moreb4);
						if (serial==-1)
							return;
						z = calcItemFromSer(serial);
						if (z!=-1)
							if ((items[z].morez || items[x].morez))
							{
								items[z].morez = 0;
								items[x].morez = 0;
								sendtradestatus(z, x);
							}
					}
					// Blackwinds Looting is crime implementation
					// changed slightly by Ripper
					if (items[x].corpse != 0 && !pc_currchar->Owns(&items[x])) 
					{ 
						P_CHAR co = FindCharBySerial(items[x].ownserial);
						if (items[x].more2 == 1 && Guilds->Compare(cc, DEREF_P_CHAR(co)) == 0) 
						{ 
							pc_currchar->karma -= 5; 
							criminal(cc);
							sysmessage(s, "You lost some karma!"); 
						} 
						npc = 0;
					} // Criminal stuff
					if (items[x].corpse != 0)
						npc = 0;
				} // end if x!=-1
				
				if (x==-1)
					npc = 0; 
			}
		} while ((npc==-1) &&(++loopexit < MAXLOOPS));
	}
	
	if (npc>0) // 0=corpse, hence >0 ..
	{
		if (!(pc_currchar->isGM()) && npc != cc && ! pc_currchar->Owns(&chars[npc]))
		{// Own serial stuff by Zippy -^ Pack aniamls and vendors.
			bounce[1] = 0;
			Xsend(s, bounce, 2);
			if (ps->IsDragging())
			{
				ps->ResetDragging();
				item_bounce3(&items[i]);
				items[i].magic = 3;
			} 
			return;
		}
	}
	// End Zippy's change
	
	// Boats->
	if (x!=-1 && npc!=-1)
	{
		if (items[x].multis>0)
			removefromptr(&imultisp[items[x].multis%HASHMAX], x);
		items[x].startDecay();
		// End Boats Change
		
		// AntiChrist -- for poisoned items
		if (items[x].layer>0)
		{
			chars[npc].removeItemBonus(&items[x]);	// remove BONUS STATS given by equipped special items
		}
		if ((items[x].trigon==1) && (items[x].layer != 0) && (items[x].layer != 15) && (items[x].layer < 19))// -Frazurbluu- Trigger Type 2 is my new trigger type *-
		{
			triggerwitem(s, DEREF_P_ITEM(pi), 1); // trigger is fired
		}	
			// AntiChrist -- for poisoned items
		if (items[x].poisoned)
		{
			chars[npc].poison -= items[x].poisoned;
			if (chars[npc].poison < 0)
				chars[npc].poison = 0;
		}
	}
	if (i!=-1)
	{
		if (items[i].corpse != 1)
		{
			UpdateStatusWindow(s, &items[i]);
			
			Map->SeekTile(items[i].id(), &tile);
			if ((((items[i].magic == 2) || ((tile.weight == 255) && (items[i].magic != 1))) && ((pc_currchar->priv2&1) == 0)) ||
				((items[i].magic == 3|| items[i].magic == 4) && !pc_currchar->Owns(&items[i])))
			{
				bounce[1] = 0;
				Xsend(s, bounce, 2);
				if (ps->IsDragging()) // only restore item if it got draggged before !!!
				{
					ps->ResetDragging();
					item_bounce4(s, &items[i]);
				}
			}
			else
			{
				// AntiChrist bugfix for the bad bouncing bug ( disappearing items when bouncing )
				DRAGGED[s] = 1;
				
				items[i].oldx = items[i].x;	// first let's save the position
				items[i].oldy = items[i].y;
				items[i].oldz = items[i].z;
				items[i].oldcontserial = items[i].contserial;	// then let's save the container
				items[i].oldlayer = items[i].layer;	// then the layer
				
				items[i].layer = 0;
				if (!items[i].isInWorld())
					soundeffect(s, 0x00, 0x57);
				if (items[i].amount>1)
				{
					amount = (buffer[s][5] << 8) + buffer[s][6];
					if (amount>items[i].amount)
						amount = items[i].amount;
					if (amount < items[i].amount)
					{
						c=Items->MemItemFree();
						items[c].Init(0);
						memcpy(&items[c], &items[i], sizeof(cItem));  // Tauriel reduce code faster too
						items[c].SetSerial(itemcount2);
						itemcount2++;

						items[c].amount = items[i].amount - amount;
						// Tauriel sorry, there is no way to make this call the item creation stuff
// Why doing it twice?
//						setptr(&itemsp[itemcount2%HASHMAX], c);
//						itemcount2++; // important bugfix for items disappearing, lb
						if (!items[c].isInWorld())
							setptr(&contsp[items[c].contserial%HASHMAX], c);
						if (items[c].ownserial!=-1)
							setptr(&ownsp[items[c].ownserial%HASHMAX], c);
						if (items[c].spawnserial!=-1)
							setptr(&spawnsp[items[c].spawnserial%HASHMAX], c);
						
						statwindow(s,cc);
						RefreshItem(c);//AntiChrist
					}
					
					if (items[i].id() == 0x0EED) // gold coin
					{
						int packnum = packitem(currchar[s]);
						if (packnum!=-1) // lb
							if (items[i].contserial == items[packnum].serial)
								update = 1;
					}
					
					items[i].amount = amount;
				}
				
				// Tauriel remove item from world mapcells
				mapRegions->RemoveItem(i); // remove this item from a map cell
				items[i].x = 0;
				items[i].y = 0;
				items[i].z = 0;
				
				items[i].SetContSerial(-1);
				if (i!=-1) // Ripper...adds weight to the players cursor when carrying a item.
				{
					int amt = 0, wgt;
					wgt = (int)Weight->LockeddownWeight(&items[i], &amt, 0);
					pc_currchar->weight += wgt;
					update = 1;
				}
			}
		}
	} // end of if i!=-1
	if (update)
		statwindow(s, cc);
}

void wear_item(P_CLIENT ps) // Item is dropped on paperdoll
{
	int j, k;
	tile_st tile;
	int serial, serhash, ci, i2, letsbounce=0; // AntiChrist (5) - new ITEMHAND system
	UOXSOCKET s=ps->GetSocket();
	int cc=ps->GetCurrChar();
	P_CHAR pc_currchar = MAKE_CHARREF_LR(cc);

	int cserial=calcserial(buffer[s][6],buffer[s][7],buffer[s][8],buffer[s][9]);
	if(cserial==-1) return;
	k=calcCharFromSer( cserial );
	
	if( chars[k].dead )  //Exploit fix: Dead ppl can't equip anything.
		return;
	
	P_ITEM pi=FindItemBySerPtr(buffer[s]+1);
	if (!pi) return;

	if (clientDimension[s]==3)
	{
		Map->SeekTile(pi->id(), &tile);
		
		// sprintf(temp, "Tiledata: name: %s flag1: %i flag2: %i flag3: %i flag4: %i layer: %i\n", tile.name, tile.flag1, tile.flag2, tile.flag3, tile.flag4, tile.layer);
		// clConsole.send(temp);
		
		if (tile.layer==0)
		{
			sysmessage(s,"You can't wear that");
			Sndbounce5(s);
			if (ps->IsDragging())
			{
				ps->ResetDragging();
				item_bounce4(s,pi);
				UpdateStatusWindow(s,pi);
			}
			return;
		}
	}

	if (pi->id1>=0x40) return; // LB, client crashfix if multi-objects are moved to PD

	if (k==cc || pc_currchar->isGM()) 
	{
		if (k!=-1) //lb
			if (k==cc && pi->st>chars[k].st)
			{
				sysmessage(s,"You are not strong enough to use that.");
				Sndbounce5(s);
				if (ps->IsDragging())
				{
					ps->ResetDragging();
					item_bounce4(s,pi);
					UpdateStatusWindow(s,pi);
				}
				return;
			}
			
			if (pc_currchar->id1==0x01 && pc_currchar->id2==0x90) // Ripper...so males cant wear female armor
			if (pi->id1==0x1c && ( pi->id2==0x00 || pi->id2==0x02 || pi->id2==0x04 ||
                pi->id2==0x06 || pi->id2==0x08 || pi->id2==0x0a || pi->id2==0x0c))
			{
				sysmessage(s,"You cant wear female armor!");
				Sndbounce5(s);
				if (ps->IsDragging())
                {
					ps->ResetDragging();
					item_bounce4(s,pi);				  
					UpdateStatusWindow(s,pi);
				}
				return;
			}

			if (clientDimension[s]==2) Map->SeekTile(pi->id(), &tile);
			if ((((pi->magic==2)||((tile.weight==255)&&(pi->magic!=1)))&&((pc_currchar->priv2&1)==0)) ||
				( (pi->magic==3|| pi->magic==4) && !pc_currchar->Owns(pi)))
			{
				item_bounce6(ps,pi);
				return;
			}
		

		// - AntiChrist (4) - checks for new ITEMHAND system
		// - now you can't equip 2 hnd weapons with 1hnd weapons nor shields!!
		serial=pc_currchar->serial;
		serhash=serial%HASHMAX;
	  	for (ci=0;ci<contsp[serhash].max;ci++)
		{
			i2=contsp[serhash].pointer[ci];
			if (i2!=-1 && items[i2].contserial==serial)
			{
				if (items[i2].itmhand==1 && pi->itmhand==1)
				{
					sysmessage(s,"You already have a weapon equipped!");
					letsbounce=1;
				}
				else if (items[i2].itmhand==2 && pi->itmhand==1)
				{
					sysmessage(s,"Your hands are both occupied!");
					letsbounce=1;
				}
				else if (items[i2].itmhand==1 && pi->itmhand==2)
				{
					sysmessage(s,"You cannot equip a two handed weapon with a weapon equipped!");
					letsbounce=1;
				}
				else if (items[i2].itmhand==2 && pi->itmhand==2)
				{
					sysmessage(s,"You cannot equip a two handed weapon with a two handed weapon equipped!");
					letsbounce=1;
				}
				else if (items[i2].itmhand==2 && pi->itmhand==3)
				{
					sysmessage(s,"You cannot equip a shield with a two handed weapon equipped!");
					letsbounce=1;
				}
				else if (items[i2].itmhand==3 && pi->itmhand==2)
				{
					sysmessage(s,"You cannot equip a two handed weapon with a shield equipped!");
					letsbounce=1;
				}
				else if (items[i2].layer == tile.layer) 
				{
 					sysmessage(s, "You already have an armor equipped!");
					letsbounce = 1;
				}
			}
			if(letsbounce)//Let's bounce the item
			{
				Sndbounce5(s);
				if (ps->IsDragging())
				{
					ps->ResetDragging();
					item_bounce4(s,pi);
					UpdateStatusWindow(s,pi);
					itemsfx(s, pi->id());		// antichrist
				}
				return;
			} 
		}
		// - AntiChrist (5) - ITEMHAND CHECKS END -
		// probably these next checks could be removed with the ITEMHAND thing - AntiChrist
		/*if ( pc_currchar->getShield() && (buffer[s][5]==2) ) //Morrolan test
		{
			sysmessage(s, "You already have a shield equiped! You must unequip it to use this.");
			item_bounce6(ps,pi);
			return;
		}
		if ( pc_currchar->getWeapon() && (buffer[s][5]==1) )//Morrolan test
		{
			sysmessage(s, "You already have a weapon equiped!");
			item_bounce6(ps,pi);
			return;
		}*/
		if (!(pc_currchar->isGM())) //Ripper..players cant equip items on other players or npc`s paperdolls.
		{
			if ((k!=cc)&&(chars[s].npc!=k))
			{
				sysmessage(s, "You cant put items on other players!");
				item_bounce6(ps,pi);
				return;
			}
		}
		pi->SetContSerial(LongFromCharPtr(buffer[s]+6));
		pi->layer=buffer[s][5];
		// AntiChrist - now the STAT BONUS works -
		pc_currchar->st = (pc_currchar->st + pi->st2);
		pc_currchar->chgDex(pi->dx2);
		pc_currchar->in = (pc_currchar->in + pi->in2);
		if (pi->trigtype==2) // -Frazurbluu- Trigger Type 2 is my new trigger type *-
		{
			triggerwitem(s, DEREF_P_ITEM(pi), 1); // trigger is fired
		}	
		// AntiChrist -- for poisoned items
		if(pi->poisoned)
		{
			if(pc_currchar->poison< (pi->poisoned))
				pc_currchar->poison=pi->poisoned;
		}
		if (showlayer)	clConsole.send("Item equipped on layer %i.\n",pi->layer);
		
		SndRemoveitem(pi->serial);
		
		LongToCharPtr(pi->serial,wearitem+1);
		ShortToCharPtr(pi->id(),wearitem+5);
		wearitem[8]=pi->layer;
		LongToCharPtr(pi->contserial,wearitem+9);
		wearitem[13]=pi->color1;
		wearitem[14]=pi->color2;
		Xsend(s, wearitem, 15);
		wornitems(s, k);//send update to current socket
		// -Frazurbluu- Worn item triggers will need code here
		// Trigger cod ewill also need the adjustments made for skill adding
		// An apply/unapply type of variable must be added for skill gains
		// Spell Item will have to be considered, like a necklace of reflection

		for (j=0;j<now;j++)
		{
			if (perm[j] && inrange1p(k, currchar[j]) && (j!=s))//and to all inrange sockets (without re-sending to current socket)//AntiChrist
				wornitems(j, k);
		}
		
		itemsfx(s, pi->id());	// Dupois - see itemsfx() for details	// Added Oct 09, 1998
		Weight->NewCalc(cc);	// Ison 2-20-99
		statwindow(s,cc);
		
		if (pi->glow>0)
		{
			pc_currchar->removeHalo(pi); // if gm equips on differnt player it needs to be deleted out of the hashteble
			chars[k].addHalo(pi);
			chars[k].glowHalo(pi);
		}
    }
}

static bool ItemDroppedOnPet(P_CLIENT ps, PKGx08 *pp, P_ITEM pi)
{
	UOXSOCKET s=ps->GetSocket();
	CHARACTER cc=ps->GetCurrChar();
	int t=calcCharFromSer(pp->Tserial);

	if(chars[t].hunger<6 && pi->type==14)//AntiChrist new hunger code for npcs
	{
		soundeffect2(cc, 0x00, 0x3A+(rand()%3));	//0x3A - 0x3C three different sounds

		if((pi->poisoned)&&(chars[t].poisoned<pi->poisoned)) 
		{
			soundeffect2(t, 0x02, 0x46); //poison sound - SpaceDog
			chars[t].poisoned=pi->poisoned;
			chars[t].poisontime=uiCurrentTime+(MY_CLOCKS_PER_SEC*(40/chars[t].poisoned)); // a lev.1 poison takes effect after 40 secs, a deadly pois.(lev.4) takes 40/4 secs - AntiChrist
			chars[t].poisonwearofftime=chars[t].poisontime+(MY_CLOCKS_PER_SEC*SrvParms->poisontimer); //wear off starts after poison takes effect - AntiChrist
			impowncreate(s,t,1); //Lb, sends the green bar ! 
		}
		
		if(pi->name[0]=='#') pi->getName(temp2);
		sprintf((char*)temp,"* You see %s eating %s *",chars[t].name,temp2);
		chars[t].emotecolor1=0x00;
		chars[t].emotecolor2=0x26;
		npcemoteall(t,(char*)temp,1);
		chars[t].hunger++;
	} else
	{
		sysmessage(s,"It doesn't appear to want the item");
		Sndbounce5(s);
		if (ps->IsDragging())
		{
			ps->ResetDragging();
			item_bounce5(s,pi);
		}
	}
	return true;
}

static bool ItemDroppedOnGuard(P_CLIENT ps, PKGx08 *pp, P_ITEM pi)
{
	UOXSOCKET s=ps->GetSocket();
	CHARACTER cc=ps->GetCurrChar();
	P_CHAR pc_currchar = MAKE_CHARREF_LRV(cc,true);
	int t=calcCharFromSer(pp->Tserial);
	// Search for the key word "the head of"
	if( strstr( pi->name, "the head of" ) )
	{
		// This is a head of someone, see if the owner has a bounty on them
		int nCharIdx = calcCharFromSer( pi->ownserial );
		
		if( chars[nCharIdx].questBountyReward > 0 )
		{
			// Give the person the bounty assuming that they are not the
			// same person as the reward is for
			if( pc_currchar->serial != chars[nCharIdx].serial )
			{
				// give them the gold for bringing the villan to justice
				addgold( s, chars[nCharIdx].questBountyReward );
				goldsfx( s, chars[nCharIdx].questBountyReward );
				
				// Now thank them for their hard work
				sprintf((char*) temp, "Excellent work! You have brought us the head of %s. Here is your reward of %d gold coins.",
					chars[nCharIdx].name,
					chars[nCharIdx].questBountyReward );
				npctalk( s, t, (char*)temp, 0);
				
				// Delete the Bounty from the bulletin board
				BountyDelete( chars[nCharIdx].serial );
				
				// Adjust their karma and fame back to what it was before the beheading!
				pc_currchar->fame   += 100;
				pc_currchar->karma  += 100;
			}
			else
				npctalk(s, t, "You can not claim that prize scoundrel. You are lucky I don't strike you down where you stand!",0);
			
			// Delete the item
			Items->DeleItem(pi);
			return true;
		}
	}
	return true;
}

static bool ItemDroppedOnBeggar(P_CLIENT ps, PKGx08 *pp, P_ITEM pi)
{
	UOXSOCKET s=ps->GetSocket();
	CHARACTER cc=ps->GetCurrChar();
	P_CHAR pc_currchar = MAKE_CHARREF_LRV(cc,true);
	int t=calcCharFromSer(pp->Tserial);
	if(pi->id()!=0x0EED)
	{
		sprintf((char*)temp,"Sorry %s i can only use gold",pc_currchar->name);
		npctalk(s,t,(char*)temp,0);
		Sndbounce5(s);
		if (ps->IsDragging())
		{
			ps->ResetDragging();
			item_bounce5(s,pi);
			return true;
		}
	}
	else
	{
		sprintf((char*)temp,"Thank you %s for the %i gold!",pc_currchar->name,pi->amount);
		npctalk(s,t,(char*)temp,0);
		if(pi->amount<=100)
		{
			pc_currchar->karma += 10;
			sysmessage(s,"You have gain a little karma!");
		}
		else if(pi->amount>100)
		{
			pc_currchar->karma += 50;
			sysmessage(s,"You have gain some karma!");
		}
		Items->DeleItem(pi);
		return true;
	}
	return true;
}

static bool ItemDroppedOnTrainer(P_CLIENT ps, PKGx08 *pp, P_ITEM pi)
{
	UOXSOCKET s=ps->GetSocket();
	CHARACTER cc=ps->GetCurrChar();
	P_CHAR pc_currchar = MAKE_CHARREF_LRV(cc,true);
	int t=calcCharFromSer(pp->Tserial);

	if( pi->id() ==0x0EED )
	{ // They gave the NPC gold
		char sk=chars[t].trainingplayerin;
		npctalk(s, t, "I thank thee for thy payment. That should give thee a good start on thy way. Farewell!",0);

		int sum = pc_currchar->getSkillSum();
		int delta = chars[t].getTeachingDelta(pc_currchar, sk, sum);

		if(pi->amount>delta) // Paid too much
		{
			pi->amount-=delta;
			Sndbounce5(s);
			if (ps->IsDragging())
			{
				ps->ResetDragging();
				item_bounce5(s,pi);
			}
		}
		else
		{
			if(pi->amount < delta)		// Gave less gold
				delta = pi->amount;		// so adjust skillgain
			Items->DeleItem(pi);
		}
		pc_currchar->baseskill[sk]+=delta;
		Skills->updateSkillLevel(cc, sk);
		updateskill(s,sk);

		pc_currchar->trainer=-1;
		chars[t].trainingplayerin='\xFF';
		itemsfx(s, pi->id());//AntiChrist - do the gold sound
		return true;
	}
	else // Did not give gold
	{
		npctalk(s, t, "I am sorry, but I can only accept gold.",0);
		Sndbounce5(s);
		if (ps->IsDragging())
		{
			ps->ResetDragging();
			item_bounce5(s,pi);
			return true;
		}
		else
			return true;
	}//if items[i]=gold
	return true;
}

static bool ItemDroppedOnSelf(P_CLIENT ps, PKGx08 *pp, P_ITEM pi)
{
	UOXSOCKET s=ps->GetSocket();
	CHARACTER cc=ps->GetCurrChar();
	P_CHAR pc_currchar = MAKE_CHARREF_LRV(cc,true);
	
	if (pi->id1>=0x40) // crashfix , prevents putting multi-objects ni your backback
	{
		sysmessage(s,"Hey, putting houses in your pack crashes your back and client !");
		pi->MoveTo(pc_currchar->x,pc_currchar->y,pc_currchar->z);
		RefreshItem(pi);//AntiChrist
		return true;
	}
	
	if (pi->glow>0) // glowing items
	{
		pc_currchar->addHalo(pi);
		pc_currchar->glowHalo(pi);
	}
	
	int pack=packitem(cc); // LB ...
	if (pack==-1) // if player has no pack, put it at its feet
	{ 
		pi->MoveTo(pc_currchar->x,pc_currchar->y,pc_currchar->z);
		RefreshItem(pi);//AntiChrist
	}
	else
	{
		items[pack].AddItem(pi); // player has a pack, put it in there
		
		Weight->NewCalc(cc);//AntiChrist bugfixes
		statwindow(s,cc);
		itemsfx(s, pi->id());
	}
	return true;
}

static bool ItemDroppedOnChar(P_CLIENT ps, PKGx08 *pp, P_ITEM pi)
{
	UOXSOCKET s=ps->GetSocket();
	CHARACTER cc=ps->GetCurrChar();
	P_CHAR pc_currchar = MAKE_CHARREF_LRV(cc,true);
	P_CHAR pTC=FindCharBySerial(pp->Tserial);	// the targeted character
	if (!pTC) return true;

	if (DEREF_P_CHAR(pTC)!=cc)
	{
		if (pTC->npc)
		{
			if(!pTC->isHuman())						
			{
				ItemDroppedOnPet( ps, pp, pi);
			}
			else	// Item dropped on a Human character
			{
				// Item dropped on a Guard (possible bounty quest)
				if( ( pTC->npc == 1 ) && ( pTC->npcaitype == 4 ) )
				{
					ItemDroppedOnGuard( ps, pp, pi);
				}
				if ( pTC->npcaitype == 5 )
				{
					ItemDroppedOnBeggar( ps, pp, pi);
				}
				
				//This crazy training stuff done by Anthracks (fred1117@tiac.net)
				if(pc_currchar->trainer!=pTC->serial)
				{
					npctalk(s, DEREF_P_CHAR(pTC), "Thank thee kindly, but I have done nothing to warrant a gift.",0);
					Sndbounce5(s);
					if (ps->IsDragging())
					{
						ps->ResetDragging();
						item_bounce5(s,pi);
					}
					return true;
				}
				else // The player is training from this NPC
				{
					ItemDroppedOnTrainer( ps, pp, pi);
				}
			}//if human or not
		}
		else // dropped on another player
		{
			// By Polygon: Avoid starting the trade if GM drops item on logged on char (crash fix)
			if ((pc_currchar->isGM()) && !online(DEREF_P_CHAR(pTC)))
			{
				// Drop the item in the players pack instead
				// Get the pack
				int pack = packitem(DEREF_P_CHAR(pTC));
				if (pack != -1)	// Valid pack?
				{
					items[pack].AddItem(pi);	// Add it
					Weight->NewCalc(DEREF_P_CHAR(pTC));
				}
				else	// No pack, give it back to the GM
				{
					pack = packitem(DEREF_P_CHAR(pc_currchar));
					if (pack != -1)	// Valid pack?
					{
						items[pack].AddItem(pi);	// Add it
						Weight->NewCalc(DEREF_P_CHAR(pc_currchar));
					}
					else	// Even GM has no pack?
					{
						// Drop it to it's feet
						pi->MoveTo(pc_currchar->x, pc_currchar->y, pc_currchar->z);
						RefreshItem(pi);
					}
				}
			}
			else
			{
				int j=tradestart(s, DEREF_P_CHAR(pTC)); //trade-stuff
				pi->SetContSerial(items[j].serial);
				pi->x=30;
				pi->y=30;
				pi->z=9;
				SndRemoveitem(pi->serial);
				RefreshItem(pi);
			}
		}


	}
	else // dumping stuff to his own backpack !
	{
		ItemDroppedOnSelf( ps, pp, pi);
	}
	return true;
}

void dump_item(P_CLIENT ps, PKGx08 *pp) // Item is dropped on ground or a character
{
	tile_st tile;
	UOXSOCKET s=ps->GetSocket();
	CHARACTER cc=ps->GetCurrChar();
	P_CHAR pc_currchar = MAKE_CHARREF_LR(cc);
	
	P_ITEM pi=FindItemBySerial(pp->Iserial);
	if (!pi)
	{
		LogErrorVar("client sent bad itemserial %d",pp->Iserial);
		return;
	}
	if(pi!=NULL)
	{
		Weight->NewCalc(cc);
		statwindow(s,cc);
	}
	
	//Ripper...so order/chaos shields disappear when on ground.
	if( pi->id1 == 0x1B && ( pi->id2 == 0xC3 || pi->id2 == 0xC4 ) )
	{
		soundeffect2(cc, 0x01, 0xFE);
		staticeffect(cc, 0x37, 0x2A, 0x09, 0x06);
		Items->DeleItem( pi );
		return;
	}
	
	//test UOP blocking Tauriel 1-12-99
	if (!pi->isInWorld())
	{
		item_bounce6(ps,pi);
		return;
	}
	
	Map->SeekTile(pi->id(), &tile);
	if (((pi->magic==2 || (tile.weight==255 && pi->magic!=1))&&((pc_currchar->priv2&1)==0)) ||
		( (pi->magic==3 || pi->magic==4) && !pc_currchar->Owns(pi)))
	{
		item_bounce6(ps,pi);
		return;
	}
	
	if (buffer[s][5]!=(unsigned char)'\xFF')
	{
		pi->MoveTo(pp->TxLoc,pp->TyLoc,pp->TzLoc);
		pi->SetContSerial(-1);
		
		if (pi->glow)
		{
			pc_currchar->removeHalo(pi);
			pc_currchar->glowHalo(pi);
		}		
		SndRemoveitem(pi->serial);
		RefreshItem(pi);
	}
	else
	{
		ItemDroppedOnChar(ps, pp, pi);
		
		Weight->NewCalc(cc);  // Ison 2-20-99
		statwindow(s,cc);
		itemsfx(s, pi->id());	// Dupois - see itemsfx() for details// Added Oct 09, 1998
		
		//Boats !
		if (pc_currchar->multis>0) //How can they put an item in a multi if they aren't in one themselves Cut lag by not checking everytime something is put down
		{
			int multi = calcItemFromSer( pc_currchar->multis );
			if (multi!=-1)
			{
				multi=findmulti(pi->x,pi->y,pi->z);
				if (multi!=-1)
					setserial(DEREF_P_ITEM(pi),multi,7);
			}
		}
		//End Bots
	}
}

void pack_item(P_CLIENT ps, PKGx08 *pp) // Item is put into container
{
	int nCont=-1, nItem=-1;
	int j, z, serial, serhash;
	tile_st tile;
	bool abort=false;
	UOXSOCKET s=ps->GetSocket();
	CHARACTER cc=ps->GetCurrChar();
	P_CHAR pc_currchar = MAKE_CHARREF_LR(cc);
	
	serial=pp->Tserial;
	if(serial==-1) abort=true;
	serhash=serial%HASHMAX;
	nCont = calcItemFromSer( serial );
	
	serial=pp->Iserial;
	if(serial==-1) abort=true;
	serhash=serial%HASHMAX;
	nItem = calcItemFromSer( serial );
	
	if (nCont==-1)
	{
		RefreshItem(nCont);//AntiChrist
		return;
	} 
	
	if (nItem==-1) return; //LB
	const P_ITEM pCont=MAKE_ITEMREF_LR(nCont);	// on error return  (This one could be const ! Duke)
	const P_ITEM pItem=MAKE_ITEMREF_LR(nItem);	// on error return

	if (pItem->id1>=0x40) 
	{ 
	   abort=true; // LB crashfix that prevents moving multi objcts in BP's
       sysmessage(s,"Hey, putting houses in your pack crashes your back and client!");
	}
	j=GetPackOwner(nCont);
	if (j>-1)
	if (chars[j].npcaitype==17 && chars[j].npc && !pc_currchar->Owns(&chars[j]))
	{
	   abort=true;
	   sysmessage(s,"This aint your vendor!");				
	}

	if(abort)
	{//AntiChrist to preview item disappearing
		item_bounce6(ps,pItem);
		return;
	}

	if (pCont->layer==0 && pCont->id() == 0x1E5E &&
		pc_currchar->Wears(pCont))
	{
		// Trade window???
		serial=calcserial(pCont->moreb1, pCont->moreb2, pCont->moreb3, pCont->moreb4);
		if(serial==-1) return;
		z = calcItemFromSer( serial );
		
		if (z!=-1)
			if ((items[z].morez || pCont->morez))
			{
				items[z].morez=0;
				pCont->morez=0;
				sendtradestatus(z, nCont);
			}
	}
	
	//
	//AntiChrist - Special Bank Stuff
	//
	//if morey==123  - gold only bank	
	//
	if(SrvParms->usespecialbank)//only if special bank is activated
	{
		if(pCont->morey==123 && pCont->morex==1 && pCont->type==1)
		{
			if ( pItem->id() == 0x0EED )
			{//if they're gold ok
				goldsfx(s, 2);
			} else
			{//if they're not gold..bounce on ground
				sysmessage(s,"You can only put golds in this bank box!");

				pItem->SetContSerial(-1);
				pItem->MoveTo(pc_currchar->x,pc_currchar->y,pc_currchar->z);
				RefreshItem(nItem);//AntiChrist
				itemsfx(s,pItem->id());
				return;
			}
		}
	}
	
	//testing UOP Blocking Tauriel 1-12-99
	if (!pItem->isInWorld())
	{
		item_bounce6(ps,pItem);
		return;
	}
	
	Map->SeekTile(pItem->id(), &tile);
	if ((((pItem->magic==2)||((tile.weight==255)&&(pItem->magic!=1)))&&((pc_currchar->priv2&1)==0)) ||
				( (pItem->magic==3|| pItem->magic==4) && !pc_currchar->Owns(pItem)))
	{
		Sndbounce5(s);
		if (ps->IsDragging())
		{
			ps->ResetDragging();
			item_bounce3(pItem);
			if (pCont->id1>=0x40)
				senditem(s, nCont);
		}
		return;
	}
	// - Trash container
	if (pCont->type==87)
	{
		Items->DeleItem(nItem);
		sysmessage(s, "As you let go of the item it disappears.");
		return;
	}
	// - Spell Book
	if (pCont->type==9)
	{
		if (!IsSpellScroll72(pItem->id()))
		{
			sysmessage(s, "You can only place spell scrolls in a spellbook!");
			Sndbounce5(s);
			if (ps->IsDragging())
			{
				ps->ResetDragging();
				item_bounce3(pItem);
			}
			if (pCont->id1>=0x40)
				senditem(s, nCont);
			return;
		}
		z=packitem(cc);
		if (z!=-1) // lb
		{
			if (!pc_currchar->Wears(pCont) &&
				(!(pCont->contserial==items[z].serial)) && (!(pc_currchar->canSnoop())))
			{
				sysmessage(s, "You cannot place spells in other peoples spellbooks.");
				item_bounce6(ps,pItem);
				return;
			}
			
			if(pItem->name[0]=='#')
				pItem->getName(temp2);
			else
				strcpy((char*)temp2,pItem->name);

			for (int i=0;i<contsp[pCont->serial%HASHMAX].max;i++) // antichrist , bugfix for inscribing scrolls
			{
				int ci=contsp[pCont->serial%HASHMAX].pointer[i];
				if (ci!=-1)
				{
					if(items[ci].name[0]=='#')
						items[ci].getName(temp);
					else
						strcpy((char*)temp,items[ci].name);

					if(!(strcmp((char*)temp,(char*)temp2)) || !(strcmp((char*)temp,"All-Spell Scroll")))
					{
						sysmessage(s,"You already have that spell!");
						item_bounce6(ps,pItem);
						return;
					}
				}
			}
		}
	}
	
	// player run vendors
	if (!(pCont->pileable && pItem->pileable && pCont->id()==pItem->id()
		|| (pCont->type!=1 && pCont->type!=9)))
	{
		j=GetPackOwner(nCont);
		if (j>-1) // bugkilling, LB, was j=!-1, arghh, C !!!
		{
			if (chars[j].npcaitype==17 && chars[j].npc && pc_currchar->Owns(&chars[j]))
			{
				pc_currchar->fx1=nItem;
				pc_currchar->fx2=17;
				sysmessage(s, "Set a price for this item.");
			}
		}

		short xx=pp->TxLoc;
		short yy=pp->TyLoc;

		pCont->AddItem(pItem,xx,yy);
		
		itemsfx(s, pItem->id());// see itemsfx() for details - Dupois Added Oct 09, 1998
		statwindow(s,cc);
	}
	// end of player run vendors
	
	else
		// - Unlocked item spawner or unlockable item spawner
		if (pCont->type==63 || pCont->type==65 || pCont->type==66)
		{
			pItem->SetContSerial(pp->Tserial);

			// lb bugfix
			pItem->x=pp->TxLoc;
			pItem->y=pp->TyLoc;
			pItem->z=pp->TzLoc;
			
			SndRemoveitem(pItem->serial);
			RefreshItem(nItem);//AntiChrist
			itemsfx(s, pItem->id());
			
		}
		else  // - Pileable
			if (pCont->pileable && pItem->pileable && pCont->id()==pItem->id())
			{		
				if ((pCont->amount+pItem->amount) > 65535)
				{
					pItem->amount -= (65535-pCont->amount);
					Commands->DupeItem(s, nCont, pItem->amount);
					pCont->amount = 65535;
					Items->DeleItem(nItem);
				}
				else
				{
					pCont->amount=pCont->amount+pItem->amount;
					itemsfx(s, pItem->id());
					Items->DeleItem(nItem);
				}
				SndRemoveitem(pItem->serial);
				RefreshItem(nCont);//AntiChrist
			}
			else
			{
				pItem->x=pp->TxLoc;
				pItem->y=pp->TyLoc;
				pItem->z=pp->TzLoc;
//				pItem->SetContSerial(-1);
				pItem->SetContSerial(pp->Tserial);
				// Tauriel add item to world mapcells
				mapRegions->AddItem(nItem); //add this item to a map cell
				
				SndRemoveitem(pItem->serial);
				RefreshItem(nCont);//AntiChrist
			}
			
			// - Spell Book
	
			if (pCont->type==9)
				Magic->SpellBook(s,nCont); // LB, bugfix for showing(!) the wrong spell (clumsy) when a new spell is put into opened spellbook

			if (pItem->glow>0) // LB's glowing items stuff
			{
				int p=GetPackOwner(nCont); 
				pc_currchar->removeHalo(pItem); // if gm put glowing object in another pack, handle glowsp correctly !
				//removefromptr(&glowsp[pc_currchar->serial%HASHMAX],nItem);
				if (p!=-1) 
				{
					chars[p].addHalo(pItem);
					chars[p].glowHalo(pItem);
				}		   
				
			}	
}

void drop_item(P_CLIENT ps) // Item is dropped
{
	UOXSOCKET s=ps->GetSocket();
//	CHARACTER cc=ps->GetCurrChar();

	PKGx08 pkgbuf, *pp=&pkgbuf;

	pp->Iserial=LongFromCharPtr(buffer[s]+1);
	pp->TxLoc=ShortFromCharPtr(buffer[s]+5);
	pp->TyLoc=ShortFromCharPtr(buffer[s]+7);
	pp->TzLoc=buffer[s][9];
	pp->Tserial=LongFromCharPtr(buffer[s]+10);

    //#define debug_dragg
	
	if (clientDimension[s]==3)
	{
	  // UO:3D clients send SOMETIMES two dragg packets for a single dragg action. 
	  // sometimes we HAVE to swallow it, sometimes it has to be interpreted
	  // if UO:3D specific item loss problems are reported, this is probably the code to blame :)
	  // LB
	  ITEM i = calcItemFromSer(pp->Iserial);

	  #ifdef debug_dragg 
	    if (i!=-1) { sprintf(temp, "%04x %02x %02x %01x %04x i-name: %s EVILDRAG-old: %i\n",pp->Iserial, pp->TxLoc, pp->TyLoc, pp->TzLoc, pp->Tserial, items[i].name, EVILDRAGG[s]); clConsole.send(temp); }
		else { sprintf(temp, "blocked: %04x %02x %02x %01x %04x i-name: invalid item EVILDRAG-old: %i\n",pp->Iserial, pp->TxLoc, pp->TyLoc, pp->TzLoc, pp->Tserial, EVILDRAGG[s]); clConsole.send(temp); }
      #endif

	  if  ( (pp->TxLoc==-1) && (pp->TyLoc==-1) && (pp->Tserial==0)  && (EVILDRAGG[s]==1) ) 
	  { 
		  EVILDRAGG[s]=0; 
          #ifdef debug_dragg
		    clConsole.send("Swallow only\n"); 
          #endif
		  return; 
	  }	 // swallow! note: previous evildrag !

	  else if ( (pp->TxLoc==-1) && (pp->TyLoc==-1) && (pp->Tserial==0)  && (EVILDRAGG[s]==0) ) 
	  {
          #ifdef debug_dragg
		    clConsole.send("Bounce & Swallow\n"); 
          #endif

		  item_bounce6(ps, &items[i]); 
		  return; 
	  }
	  else if ( ( (pp->TxLoc!=-1) && (pp->TyLoc!=-1) && ( pp->Tserial!=-1)) || ( (pp->Iserial>=0x40000000) && (pp->Tserial>=0x40000000) ) ) EVILDRAGG[s]=1; // calc new evildrag value
	  else EVILDRAGG[s]=0;
	} 

	#ifdef debug_dragg 
	  else
	  {
		 ITEM i = calcItemFromSer( pp->Iserial );
	     if (i!=-1) { sprintf(temp, "blocked: %04x %02x %02x %01x %04x i-name: %s EVILDRAG-old: %i\n",pp->Iserial, pp->TxLoc, pp->TyLoc, pp->TzLoc, pp->Tserial, items[i].name, EVILDRAGG[s]); clConsole.send(temp); }
	  }
    #endif

	if ( (buffer[s][10]>=0x40) && (buffer[s][10]!=0xff) )
		pack_item(ps,pp);
	else 
		dump_item(ps,pp);
}
