/* House code for deed creation by Tal Strake, revised by Cironian */

#include "wolfpack.h"
#include "SndPkg.h"
#include "debug.h"
#include "utilsys.h"
#undef  DBGFILE
#define DBGFILE "house.cpp"

bool CheckBuildSite(int x, int y, int z, int sx, int sy);

void mtarget(int s, int a1, int a2, int a3, int a4, char b1, char b2, char *txt)
{
	char multitarcrs[27]="\x99\x01\x40\x01\x02\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x02\x00\x00\x00\x00\x00\x00";

	targetok[s]=1; 
	multitarcrs[2]=a1;
	multitarcrs[3]=a2;
	multitarcrs[4]=a3;
	multitarcrs[5]=a4;
	multitarcrs[18]=b1;
	multitarcrs[19]=b2;
	sysmessage(s, txt);
	Xsend(s, multitarcrs, 26);
}

//o---------------------------------------------------------------------------o
//|   Function    -  void buildhouse(int s, int i)
//|   Date        -  UnKnown - Rewrite Date 1/24/99
//|   Programmer  -  UnKnown - Rewrite by Zippy (onlynow@earthlink.net)
//|   Lots of client crash fixes by LB, 25-dec 1999
//o---------------------------------------------------------------------------o
//|   Purpose     -  Triggered by double clicking a deed-> the deed's moreX is read
//|                  for the house section in house.scp. Extra items can be added
//|                  using HOUSE ITEM, (this includes all doors!) and locked "LOCK"
//|                  Space around the house with SPACEX/Y and CHAR offset CHARX/Y/Z
//o---------------------------------------------------------------------------o
void buildhouse(int s, int i)
{
	int ii,x,y,key,loopexit=0;//where they click, and the house/key items
	signed char z;
	int sx=0,sy=0;                                  //space around the house needed
	int k,l,tmp;                                            //Temps
	int hitem[100],icount=0;//extra "house items" (up to 100)
	char sect[512];                         //file reading
	unsigned char id1,id2;                                   //house ID
	char itemsdecay = 0;            // set to 1 to make stuff decay in houses
	static int looptimes=0;         //for targeting
	long int pos;                                   //for files...
	int cx=0,cy=0,cz=8;             //where the char is moved to when they place the house (Inside, on the steps.. etc...)(Offset)
	int boat=0;//Boats
	int hdeed=0;//deed id #		
	int norealmulti=0,nokey=0,othername=0;
	char name[512];
	
	if(buffer[s][11]==0xFF && buffer[s][12]==0xFF && buffer[s][13]==0xFF && buffer[s][14]==0xFF) return; // do nothing if user cancels, avoids CRASH!
	
	hitem[0]=0;//avoid problems if there are no HOUSE_ITEMs by initializing the first one as 0
	if (i)
	{
		openscript("house.scp");
		sprintf(sect, "HOUSE %d", i);//and BTW, .find() adds SECTION on there for you....
		if (!(i_scripts[house_script]->find(sect)))
		{
			closescript();
			return;
		}
		do
		{
			read2();
			if (script1[0]!='}')
			{
				if (!(strcmp((char*)script1,"ID")))
				{
					tmp=hstr2num(script2);
					id1 = (unsigned char)(tmp>>8);
					id2 = (unsigned char)(tmp%256);
				}
				else if (!(strcmp((char*)script1,"SPACEX")))
				{
					sx=str2num(script2)+1;
				}
				else if (!(strcmp((char*)script1,"SPACEY")))
				{
					sy=str2num(script2)+1;
				}
				else if (!(strcmp((char*)script1,"CHARX")))
				{
					cx=str2num(script2);
				}
				else if (!(strcmp((char*)script1,"CHARY")))
				{
					cy=str2num(script2);
				}
				else if (!(strcmp((char*)script1,"CHARZ")))
				{
					cz=str2num(script2);
				}
				else if( !(strcmp((char*)script1, "ITEMSDECAY" )))
				{
					itemsdecay = str2num( script2 );
				}
				else if (!(strcmp((char*)script1,"HOUSE_ITEM")))
				{
					hitem[icount]=str2num(script2);
					icount++;
				}
				else if (!(strcmp((char*)script1, "HOUSE_DEED")))
				{
					hdeed=str2num(script2);
				}							
				else if (!(strcmp((char*)script1, "BOAT"))) boat=1;//Boats
				
				else if (!(strcmp((char*)script1, "NOREALMULTI"))) norealmulti=1; // LB bugfix for pentas crashing client
				else if (!(strcmp((char*)script1, "NOKEY"))) nokey=1;
				else if (!(strcmp((char*)script1, "NAME"))) 
				{ 
					strcpy((char*)name,(char*)script2);
					othername=1;
				}
			}
		}
		while ( (strcmp((char*)script1,"}")) && (++loopexit < MAXLOOPS) );
		closescript();
		
		if (!id1)
		{
			clConsole.send("ERROR: Bad house script # %i!\n",i);
			return;
		}
	}
	
	if(!looptimes)
	{
		if (i)
		{
			
			addid1[s]=0x40;addid2[s]=100;//Used in addtarget
			if (norealmulti) target(s, 0, 1, 0, 245, "Select a place for your structure: "); else
				mtarget(s, 0, 1, 0, 0, id1-0x40, id2, "Select location for building.");
			
		}
		else
		{
			mtarget(s, 0, 1, 0, 0, addid1[s]-0x40, addid2[s], "Select location for building.");
		}
		looptimes++;//for when we come back after they target something
		return;
	}
	if(looptimes)
	{
		looptimes=0;
		if(!chars[currchar[s]].isGM() && SrvParms->houseintown==0)
		{
		    if (chars[currchar[s]].inGuardedArea() && ishouse(id1, id2) ) // popy
			{
			    sysmessage(s," You cannot build houses in town!");
			    return;
			}
		}
		
		x=(buffer[s][11]<<8)+buffer[s][12];//where they targeted
		y=(buffer[s][13]<<8)+buffer[s][14];
		z=buffer[s][16]+Map->TileHeight((buffer[s][17]<<8)+buffer[s][18]);
		
		
		if ( (( x<200 && y <200 ) || ( x>6200 || y >4200 ))  )			
		{
			sysmessage(s, "You cannot build your structure there!");
			return;
		}
		
		
		/*
		if (ishouse(id1, id2)) // strict checking only for houses ! LB
		{
			if(!(CheckBuildSite(x,y,z,sx,sy)))
			{
				sysmessage(s,"Can not build a house at that location (CBS)!");
				return;
			}
		}*/
		
		for (k=-sx;k<sx;k++)//check the SPACEX and SPACEY to make sure they are valid locations....
		{
			for (l=-sy;l<sy;l++)
			{
				if ((!validNPCMove(x+k,y+l,z,currchar[s]))&&
					((chars[currchar[s]].x!=x+k)&&(chars[currchar[s]].y!=y+l)))
					/*This will take the char making the house out of the space check, be careful 
					you don't build a house on top of your self..... this had to be done So you 
					could extra space around houses, (12+) and they would still be buildable.*/
				{
					sysmessage(s, "You cannot build your stucture there.");
					return;
					//clConsole.send("Invalid %i,%i [%i,%i]\n",k,l,x+k,y+l);
				} //else clConsole.send("DEBUG: Valid at %i,%i [%i,%i]\n",k,l,x+k,y+l);
				
				ii=findmulti(x+k,y+l,z);
				if (ii!=-1 && !(norealmulti))
				{
					sysmessage(s,"You cant build structures inside structures");
					return;
				}
			}
		}
		
		//Boats ->
		if(id2>=18) sprintf((char*)temp,"%s's house",chars[currchar[s]].name);//This will make the little deed item you see when you have showhs on say the person's name, thought it might be helpful for GMs.
		else strcpy((char*)temp, "a mast");
		if(norealmulti) strcpy((char*)temp, name);
		//--^
		
		if (othername) strcpy((char*)temp,name);
		
		P_ITEM pHouse=Items->SpawnItem(currchar[s], 1,(char*)temp,0,(id1<<8)+id2,0,0);
		if (!pHouse) return;		
		
		
		chars[currchar[s]].making=0;
		
		pHouse->MoveTo(x,y,z);
		pHouse->priv=0;
		pHouse->more4 = itemsdecay; // set to 1 to make items in houses decay
		pHouse->morex=hdeed; // crackerjack 8/9/99 - for converting back *into* deeds
		pHouse->SetOwnSerial(chars[currchar[s]].serial);
		if (!hitem[0] && !boat)
		{
			teleport(currchar[s]);
			all_items(s);
			return;//If there's no extra items, we don't really need a key, or anything else do we? ;-)
		}
		
		if(boat) //Boats
		{
			if(!Boats->Build(s,DEREF_P_ITEM(pHouse), id2))
			{
				Items->DeleItem(pHouse);
				return;
			} 
		}
		
		if (i)//Boats->.. Moved from up there ^
			Items->DeleItem(chars[currchar[s]].fx1); // this will del the deed no matter where it is
		
		chars[currchar[s]].fx1=-1; //reset fx1 so it does not interfere
		// bugfix LB ... was too early reseted 
		
		//Key...
		
		if (id2>=112&&id2<=115) key=Items->SpawnItem(s, currchar[s], 1, "a tent key", 0, 0x10, 0x10,0, 0,1,1);//iron key for tents
		else if(id2<=0x18) key=Items->SpawnItem(s,currchar[s],1,"a ship key",0,0x10,0x13,0,0,1,1);//Boats -Rusty Iron Key
		else key=Items->SpawnItem(s, currchar[s], 1, "a house key", 0, 0x10, 0x0F, 0, 0,1,1);//gold key for everything else;
		
		items[key].more1=pHouse->ser1;//use the house's serial for the more on the key to keep it unique
		items[key].more2=pHouse->ser2;
		items[key].more3=pHouse->ser3;
		items[key].more4=pHouse->ser4;
		items[key].type=7;
		items[key].priv=2; // Newbify key..Ripper
        
		ITEM key2=Items->SpawnItem(s, currchar[s], 1, "a house key", 0, 0x10, 0x0F, 0, 0,1,1);
		P_ITEM bankbox = chars[currchar[s]].GetBankBox();
		P_ITEM p_key=MAKE_ITEMREF_LR(key2);
		p_key->more1=pHouse->ser1;
		p_key->more2=pHouse->ser2;
		p_key->more3=pHouse->ser3;
		p_key->more4=pHouse->ser4;
		p_key->type=7;
		p_key->priv=2;
		bankbox->AddItem(p_key);
		
		if(nokey) 
		{
			Items->DeleItem(key); // No key for .. nokey items
			Items->DeleItem(key2);
		}
		
		for (k=0;k<icount;k++)//Loop through the HOUSE_ITEMs
		{
			openscript("house.scp");
			sprintf(sect,"HOUSE ITEM %i",hitem[k]);
			if (!i_scripts[house_script]->find(sect))
			{
				closescript();
			}
			else
			{
				loopexit=0;
				do 
				{
					read2();
					if (script1[0]!='}')
					{
						if (!(strcmp((char*)script1,"ITEM")))
						{
							pos=ftell(scpfile);// To prevent accidental exit of loop.
							closescript();
							l=Items->CreateScriptItem(s,str2num(script2),0);//This opens the item script... so we gotta keep track of where we are with the other script.
							openscript("house.scp");
							fseek(scpfile, pos, SEEK_SET);
							strcpy((char*)script1, "ITEM");
							items[l].magic=2;//Non-Movebale by default
							items[l].priv=0;//since even things in houses decay, no-decay by default
							items[l].x=x;
							items[l].y=y;
							items[l].z=z;
							items[l].SetOwnSerial(chars[currchar[s]].serial);
						}
						if (!(strcmp((char*)script1,"DECAY")))
						{
							items[l].priv |= 0x01;
						}
						if (!(strcmp((char*)script1,"NODECAY")))
						{
							items[l].priv=0;
						}
						if (!(strcmp((char*)script1,"PACK")))//put the item in the Builder's Backpack
						{
							items[l].SetContSerial(items[packitem(currchar[s])].serial);
							items[l].x=rand()%90+31;
							items[l].y=rand()%90+31;
							items[l].z=9;
						}
						if (!(strcmp((char*)script1,"MOVEABLE")))
						{
							items[l].magic=1;
						}
						if (!(strcmp((char*)script1,"LOCK")))//lock it with the house key
						{
							items[l].more1=pHouse->ser1;
							items[l].more2=pHouse->ser2;
							items[l].more3=pHouse->ser3;
							items[l].more4=pHouse->ser4;
						}
						if (!(strcmp((char*)script1,"X")))//offset + or - from the center of the house:
						{
							items[l].x=x+str2num(script2);
						}
						if (!(strcmp((char*)script1,"Y")))
						{ 
							items[l].y=y+str2num(script2);
						}
						if (!(strcmp((char*)script1,"Z")))
						{
							items[l].z=z+str2num(script2);
						}
					}
				}
				while ( (strcmp((char*)script1,"}")) && (++loopexit < MAXLOOPS) );
				
				if (items[l].isInWorld()) mapRegions->AddItem(l);  //add to mapRegions
				closescript();
			}
		}
		all_items(s);//make sure they have all the items Sent....

		if (!(norealmulti))
		{
			chars[currchar[s]].x=x+cx; //move char inside house
			chars[currchar[s]].y=y+cy;
			chars[currchar[s]].dispz=chars[currchar[s]].z=z+cz;
			//clConsole.send("Z: %i Offset: %i Char: %i Total: %i\n",z,cz,chars[currchar[s]].z,z+cz);
			teleport(currchar[s]);
		}
	}
}

// turn a house into a deed if possible. - crackerjack 8/9/99
// s = socket of player
// i = house item # in items[]
// morex on the house item must be set to deed item # in items.scp.
void deedhouse(UOXSOCKET s, int i) // Ripper & AB
{
	int ii,loopexit=0;
	int x1, y1, x2, y2;
	unsigned char ser1, ser2, ser3, ser4;
	int playerCont, keyCount = 0;
	if( i == -1 ) return;
	P_CHAR pc = MAKE_CHARREF_LR(currchar[s]);
	playerCont = packitem( currchar[s] );
	int mapitemptr,mapitem,mapchar,a,checkgrid,increment,StartGrid,getcell,ab, index;		
	if(pc->Owns(&items[i]) || pc->isGM())
	{
		Map->MultiArea(i, &x1,&y1,&x2,&y2);
		
		ii=Items->SpawnItemBackpack2(s, items[i].morex, 0);        // need to make before delete
		if( ii == -1 ) return;
		sprintf((char*)temp, "Demolishing House %s", items[i].name);
		sysmessage( s, (char*)temp );
		ser1 = items[i].ser1;
		ser2 = items[i].ser2;
		ser3 = items[i].ser3;
		ser4 = items[i].ser4;
		Items->DeleItem(i);
		sprintf((char*)temp, "Converted into a %s.", items[ii].name);
		sysmessage(s, (char*)temp); 
		// door/sign delete
		StartGrid=mapRegions->StartGrid(pc->x, pc->y);
		getcell=mapRegions->GetCell(pc->x, pc->y);
		
		increment=0;
		ab=0;
		for (checkgrid=StartGrid+(increment*mapRegions->GetColSize());increment<3;increment++, checkgrid=StartGrid+(increment*mapRegions->GetColSize()))
		{       
			for (a=0;a<3;a++)
			{                                       
				mapitemptr=-1;
				mapitem=-1;
				mapchar=-1;
				loopexit=0;
				do //check all items in this cell
				{
					mapchar=-1;
					mapitemptr=mapRegions->GetNextItem(checkgrid+a, mapitemptr);
					if (mapitemptr==-1) break;
					mapitem=mapRegions->GetItem(checkgrid+a, mapitemptr);
					if(mapitem>999999) mapchar=mapitem-CharacterOffset;
					if (mapitem!=-1 && mapitem>=CharacterOffset)
					{
						index=mapchar;                  
						if( chars[index].x >= x1 && chars[index].y >= y1 && chars[index].x <= x2 && chars[index].y <= y2 )
						{
							if( chars[index].npcaitype == 17 ) // player vendor in right place
							{
								sprintf( (char*)temp, "A vendor deed for %s", chars[index].name );
								P_ITEM pPvDeed = Items->SpawnItem(currchar[s], 1, (char*)temp, 0, 0x14F0, 0, 1);
								pPvDeed->type = 217;
								pPvDeed->value = 2000;
								RefreshItem( pPvDeed );
								sprintf((char*)temp, "Packed up vendor %s.", chars[index].name);
								Npcs->DeleteChar( index );
								sysmessage(s, (char*)temp);
							}
						}
					}
					else if( mapitem != -1 )
					{
						if( items[mapitem].x >= x1 && items[mapitem].y >= y1 && items[mapitem].x <= x2 && items[mapitem].y <= y2 )
						{
							Items->DeleItem(mapitem);
						}
					}
				} while( mapitemptr != -1 && (++loopexit < MAXLOOPS) );    // keep going to make sure we got all the vendors
			}
		}
		killkeys(items[i].serial);
		sysmessage(s,"All house items and keys removed.");
		
		pc->z = pc->dispz = Map->MapElevation(pc->x, pc->y);
		teleport(currchar[s]);
		return;
	}
}

// removes houses - without regions. slow but necassairy for house decay
// LB 19-September 2000
void killhouse(ITEM i)
{
	P_ITEM pi;
	P_CHAR pc;
	int x1, y1, x2, y2;
	Map->MultiArea(i, &x1, &y1, &x2, &y2);
	
	pi = MAKE_ITEM_REF(i);
	SERIAL serial = pi->serial;
	
	unsigned int a;
	for (a = 0; a < charcount; a++) // deleting npc-vendors attched to the decying house
	{
		pc = MAKE_CHARREF_LR(a);
		if (pc->x >= x1 && pc->y >= y1 && pc->x <= x2 && pc->y <= y2 && !pc->free)
		{
			if (pc->npcaitype == 17) // player vendor in right place, delete !
			{
				Npcs->DeleteChar(a);
			}
		}                                           
	}
	
	for (a = 0; a < itemcount; a++) // deleting itmes inside house
	{
		pi = MAKE_ITEM_REF(a);
		if (pi->x >= x1 && pi->y >= y1 && pi->x <= x2 && pi->y <= y2 && !pi->free)
		{
			if (pi->type != 202) // dont delete guild stones !
			{
				Items->DeleItem(a);        
			}
		}
	}
	
	// deleting house keys
	killkeys(serial);   
}

// helper functiion for houde-decay.
// cause houses have no special type or more value we have to check all
// house item'ids
// LB 19-September 2000

bool ishouse(ITEM i)
{
  PC_ITEM pci = MAKE_ITEMREF_LRV(i,false);

  if (pci->id1 < 0x40) return false;
  
  if ( (pci->id2 >= 0x64) && (pci->id2 <= 0x7f) ) return true;

  switch(pci->id2)
  {
     case 0x87:
     case 0x8c:
	 case 0x8d:
	 case 0x96:
	 case 0x98:
	 case 0x9a:
	 case 0x9c:
	 case 0x9e:
	 case 0xa0:
	 case 0xa2:
	 case 0xbb8:
	 case 0x1388: return true;
  }  
   
  return false;
}


bool ishouse(int id1, int id2)
{

  if (id1 < 0x40) return false;
  
  if ( (id2 >= 0x64) && (id2 <= 0x7f) ) return true;

  switch(id2)
  {
     case 0x87:
     case 0x8c:
	 case 0x8d:
	 case 0x96:
	 case 0x98:
	 case 0x9a:
	 case 0x9c:
	 case 0x9e:
	 case 0xa0:
	 case 0xa2:
	 case 0xbb8:
	 case 0x1388: return true;
  }  
   
  return false;
}

// does all the work for house decay.
// checks all items if they are houses 
// if so, check its time stamp. if its too old remove it
// LB 19-September 2000
int check_house_decay()
{
   bool is_house;
   int houses=0;   
   int decayed_houses=0;
   unsigned long int timediff;
   unsigned long int ct=getNormalizedTime();
   
   AllItemsIterator iter_items;
   for (iter_items.Begin(); iter_items.GetData() != iter_items.End(); iter_items++) 
   {   
	 P_ITEM pi = iter_items.GetData(); // there shouldnt be an error here !		 
     is_house = ishouse(DEREF_P_ITEM(pi));	 
	 if (is_house && !pi->free)
	 {
       
		// its a house -> check its unused time

		//clConsole.send("id2: %x time_unused: %i max: %i\n",pi->id2,pi->time_unused,server_data.housedecay_secs);

		if (pi->time_unused>SrvParms->housedecay_secs) // not used longer than max_unused time ? delete the house
		{          
			decayed_houses++;
            sprintf((char*)temp,"%s decayed! not refreshed for > %i seconds!\n",pi->name,SrvParms->housedecay_secs);
			LogMessage((char*)temp);
			killhouse(DEREF_P_ITEM(pi));
		}
		else // house ok -> update unused-time-attribute
		{
           timediff=(ct-pi->timeused_last)/MY_CLOCKS_PER_SEC;
		   pi->time_unused+=timediff; // might be over limit now, but it will be cought next check anyway

		   pi->timeused_last=ct;	// if we don't do that and housedecay is checked every 11 minutes,
									// it would add 11,22,33,... minutes. So now timeused_last should in fact
									// be called timeCHECKED_last. but as there is a new timer system coming up
									// that will make things like this much easier, I'm too lazy now to rename
									// it (Duke, 16.2.2001)
		}
	
		houses++;
       
	 }
	 
   }
  
   //delete Watch;
   return decayed_houses;
}

void killkeys(SERIAL serial) // Crackerjack 8/11/99
{
	if (serial == -1)
		return;
	AllItemsIterator iter_items;
	for (iter_items.Begin(); iter_items.GetData() != iter_items.End(); iter_items++)
	{
		P_ITEM pi = iter_items.GetData();
		if (pi->type == 7 && calcserial(pi->more1, pi->more2, pi->more3, pi->more4) == serial)
		{
			Items->DeleItem(DEREF_P_ITEM(pi));
		}
	}
	return;
}

// Crackerjack 8/12/99 - House List Functions

// Checks if somebody is on the house list.
// on_hlist(int h (items[] index for house), unsigned char s1, s2, s3, s4 (char serial),
//		int *li (pointer to variable to put items[] index of list item in or NULL))
// Returns:
// 0 - Character is not on house list
// Anything else - Character is on house list, type # is returned.
int on_hlist(int h, unsigned char s1, unsigned char s2, unsigned char s3, unsigned char s4, int *li)
{
	
	   int ci=-1,loopexit=0;

	   int  StartGrid=mapRegions->StartGrid(items[h].x,items[h].y);
	   int  getcell=mapRegions->GetCell(items[h].x,items[h].y);	
	   unsigned int increment=0;
	   for (unsigned int checkgrid=StartGrid+(increment*mapRegions->GetColSize());increment<3;increment++, checkgrid=StartGrid+(increment*mapRegions->GetColSize()))
	   {
		for (int a=0;a<3;a++)
		{
			int mapitemptr=-1;
			int mapitem=-1;
			int mapchar=-1;
			loopexit=0;
			do //check all items in this cell
			{
				mapchar=-1;
				mapitemptr=mapRegions->GetNextItem(checkgrid+a, mapitemptr);
				if (mapitemptr==-1) break;
				mapitem=mapRegions->GetItem(checkgrid+a, mapitemptr);
				if(mapitem>999999) mapchar=mapitem-CharacterOffset;
				if (mapitem!=-1 && mapitem<CharacterOffset)
				{
				   ci=mapitem;
				   	if((items[ci].morey==items[h].serial)&&
				       (items[ci].more1==s1)&&(items[ci].more2==s2)&&
				       (items[ci].more3==s3)&&(items[ci].more4==s4)) 
					{
				       if(li!=NULL) *li=ci;
				       return items[ci].morex;
					}		          
				}								
					
		} while (mapitem!=-1 && (++loopexit < MAXLOOPS) );
	   }
	  } // end of mapregions loop
	
	return 0;

}
/*
int on_hlist(int h, unsigned char s1, unsigned char s2, unsigned char s3, unsigned char s4, int *li)
{
	int cc;
	int cl=-1;
	int ci=-1;

	cc=mapRegions->GetCell(items[h].x,items[h].y);
	do {
		cl=mapRegions->GetNextItem(cc, cl);
		if(cl==-1) break;
		ci=mapRegions->GetItem(cc, cl);
		if(ci<1000000) {
			if((items[ci].contserial==items[h].serial)&&
				(items[ci].more1==s1)&&(items[ci].more2==s2)&&
				(items[ci].more3==s3)&&(items[ci].more4==s4)) 
			{
				if(li!=NULL) *li=ci;
				return items[ci].morex;
			}
		}
	} while(ci!=-1);
	return 0;
}
*/
// Adds somebody to a house list.
// add_hlist(int c (chars[] index), int h (items[] index for house), int t (list type))
// Returns:
// 1 - Successful addition to house list
// 2 - Character is already on a house list
// 3 - Character is not on property
int add_hlist(int c, int h, int t)
{
	int sx, sy, ex, ey, i;

	if(on_hlist(h, chars[c].ser1, chars[c].ser2, chars[c].ser3, chars[c].ser4, NULL))
		return 2;

	Map->MultiArea(h, &sx,&sy,&ex,&ey);
	// Make an object with the character's serial & the list type
	// and put it "inside" the house item.
	if(chars[c].x>=sx&&chars[c].y>=sy&&chars[c].x<=ex&&chars[c].y<=ey)
	{
		i=Items->MemItemFree();	
		items[i].Init();

		items[i].morex=t;
		items[i].more1=chars[c].ser1;
		items[i].more2=chars[c].ser2;
		items[i].more3=chars[c].ser3;
		items[i].more4=chars[c].ser4;
		items[i].morey=items[h].serial;

		items[i].priv=0; // no decay !!
		items[i].visible=0;
		strcpy(items[i].name,"friend of house");

		items[i].x=items[h].x;
		items[i].y=items[h].y;
		items[i].z=items[h].z;

		mapRegions->AddItem(i);
		return 1;
	}

	return 3;
}
// Removes somebody from a house list.
// del_hlist(int c (chars[] index), int h (items[] index for house))
// Returns:
// 0 - Player was not on a list
// # - What list the player was on if any.
int del_hlist(int c, int h)
{
	int hl, li;

	hl=on_hlist(h, chars[c].ser1, chars[c].ser2, chars[c].ser3, chars[c].ser4, &li);
	if(hl) {
		mapRegions->RemoveItem(li);
		Items->DeleItem(li);
	}
	return(hl);
}

// Handles house commands from friends of the house. - Crackerjack 8/12/99
void house_speech(int s, char *talk)
{
	int i, fr;
	char msg[512];
	if(s<0 || s>MAXCLIENT) return;
	i=findmulti(chars[currchar[s]].x,chars[currchar[s]].y,chars[currchar[s]].z);
	if(i==-1) return; // not in a house, so we don't care.
	fr=on_hlist(i, chars[currchar[s]].ser1, chars[currchar[s]].ser2,
		chars[currchar[s]].ser3, chars[currchar[s]].ser4, NULL);
	if(fr!=H_FRIEND && !chars[currchar[s]].Owns(&items[i]) )
		return; // not a friend or owner, so we don't care.
	strcpy(msg, talk);//Capitalize the msg
	strcpy(msg, strupr(msg));
	if(strstr(msg, "I BAN THEE")) { // house ban
		addid1[s]=items[i].ser1;
		addid2[s]=items[i].ser2;
		addid3[s]=items[i].ser3;
		addid4[s]=items[i].ser4;
		target(s, 0, 1, 0, 229, "Select person to ban from house.");
		return;
	}
	if(strstr(msg, "REMOVE THYSELF")) { // kick out of house
		addid1[s]=items[i].ser1;
		addid2[s]=items[i].ser2;
		addid3[s]=items[i].ser3;
		addid4[s]=items[i].ser4;
		target(s, 0, 1, 0, 228, "Select person to eject from house.");
		return;
	}
	//if ((chars[currchar[s]].serial==items[i].ownserial) || (fr==H_FRIEND)) // strictly owner only as ripper demanded :-) !!!
	//{
	   if (strstr(msg,"I WISH TO LOCK THIS DOWN")) 
	   { // lock down code AB/LB
          target(s, 0, 1, 0, 232, "Select item to lock down");           
	   }

	   if (strstr(msg,"I WISH TO RELEASE THIS")) 
	   { // lock down code AB/LB
          target(s, 0, 1, 0, 233, "Select item to release"); 
	   }
	   if (strstr(msg,"I WISH TO SECURE THIS")) 
	   { // lock down code AB/LB
          target(s, 0, 1, 0, 234, "Select item to secure"); 
	   }
	   //} else if (strstr(msg,"I WISH TO ")) sysmessage(s,"Only the house owner can lock down items!");
	//} else sysmessage(s,"Only the house owner can lock down items!");
}

bool CheckBuildSite(int x, int y, int z, int sx, int sy)
{
signed int checkz;
//char statc;
int checkx;
int checky;
int ycount=0;
bool statb=false;
checkx=x-(sx/2);
for (;checkx<(x+(sx/2));checkx++)
{
	checky=y-(sy/2);
	for (;checky<(y+(sy/2));checky++)
	{
		checkz=Map->MapElevation(checkx,checky);
		if ((checkz>(z-2))&&(checkz<(z+2)))
		{
			ycount++;
		}
	//	statc=Map->StaHeight(checkx,checky,checkz);
	//	if (statc>0)
	//		statb=true;
	}
}
if (ycount==(sx*sy)) //&& (statb==false))
	return true;
else
	return false;
}
