
#ifndef __NETWORK_H__
#define __NETWORK_H__
//Platform specifics
#include "platform.h"

// System Includes

#include "stl_headers_start.h"
#include <iostream>
#include "stl_headers_end.h"

using namespace std ;

//Forward class Declaration
class cNetworkStuff;



//Wolfpack includes

//#include "netsys.h"
#include "wolfpack.h"
#include "verinfo.h"
#include "debug.h"
#include "speech.h"
#include "dragdrop.h"
#include "sregions.h"
#include "rcvpkg.h"
#include "SndPkg.h"


/*
#if defined(__unix__)
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/ioctl.h>
#endif
*/
#include "utilsys.h"


#include "typedefs.h"

class cNetworkStuff
{
public:
	cNetworkStuff();

	void startchar(UOXSOCKET s);
	void LoginMain(UOXSOCKET s);
	void xSend(UOXSOCKET s, void *point, int length, int test);
	void Disconnect(UOXSOCKET s);
	void ClearBuffers();
	void CheckConn();
	void CheckMessage();
	void SockClose();
	void FlushBuffer(UOXSOCKET s);
	void LoadHosts_deny( void );
	void Initialize(void) { sockInit(); }

	int kr,faul; // needed because global varaibles cant be changes in constructores LB
	bool CheckForBlockedIP(sockaddr_in ip_address);

private:
	char pass1[256];
	char pass2[256];

	void SendUOX3(UOXSOCKET s, void *point, int length, int test);
	void SendOSI(UOXSOCKET s, void *point, int length, int test);
	void SendSMARTWOLF(UOXSOCKET s, void *point, int length, int test);
	void CountPackets(UOXSOCKET s, int &numpackets, long int & offsetlastfullpacket, bool & dataerror);
    bool CheckPacket(UOXSOCKET s, unsigned char packetnumber, int length, unsigned long int offset);
	void SendGoodByeMessageRaw(UOXSOCKET s);

	std::vector<ip_block_st> hosts_deny;

	signed long Authenticate( const char *username, const char *pass );
	void DoStreamCode(UOXSOCKET s);
	int  Pack(void *pvIn, void *pvOut, int len);
	void Login2(int s);
	void Relay(int s);
	void GoodAuth(int s);   
	void charplay (int s);
	void CharList(int s);
	int  Receive(int s, int x, int a);
	void GetMsg(int s);
	char LogOut(int s);
	void pSplit(char *pass0);
	void sockInit();

protected:

};
#endif
