#include "wolfpack.h"
#include "itemid.h"
#include "sregions.h"
#include "SndPkg.h"
#include "debug.h"
#include "utilsys.h"

#undef  DBGFILE
#define DBGFILE "npcs.cpp"

#define CHAR_RESERVE 100	// minimum of free slots that should be left in the array.
							// otherwise, more memory will be allocated in the mainloop (Duke)

int addrandomcolor(int s, char *colorlist)
{
	char sect[512];
	int i,j,storeval;
	i=0; j=0;
	openscript("colors.scp");
	sprintf(sect, "RANDOMCOLOR %s", colorlist);
	if (!i_scripts[colors_script]->find(sect))
	{
		closescript();

		//sprintf(chars[s].name, "Error Colorlist %s Not Found(1)", colorlist);
		// LB: wtf should this do apart from crashing ? copying an error message in a chars name ??
		// very weired! think it should look like this:

		clConsole.send("Error Colorlist %s not found on character: %s\n",colorlist,chars[s].name);

		return 0;
	}
	int loopexit=0;
	do
	{
		read1();
		if (script1[0]!='}')
		{
			i++;
		}
	}
	while ( (script1[0]!='}') && (++loopexit < MAXLOOPS) );

	closescript();
	if(i>0)
	{
		i=rand()%i;
		i++;
		openscript("colors.scp");
		if(!i_scripts[colors_script]->find(sect))
		{
			closescript();
			//sprintf(chars[s].name, "Error Colorlist %s Not Found(2)", colorlist);
			clConsole.send("Error Colorlist %s not found on character: %s\n",colorlist,chars[s].name);
			return 0;
		}
		loopexit=0;
		do
		{
			read1();
			if (script1[0]!='}')
			{
				j++;
				if(j==i)
				{
					storeval=hstr2num(script1);
				}
			}
		}
		while ( (script1[0]!='}') && (++loopexit < MAXLOOPS) );
		closescript();
	}
	return (storeval);
}

static int addrandomhaircolor(int s, char *colorlist)
{
	char sect[512];
	int i,j,haircolor;
	i=0; j=0;
	openscript("colors.scp");
	sprintf(sect, "RANDOMCOLOR %s", colorlist);
	if (!i_scripts[colors_script]->find(sect))
	{
		closescript();
		clConsole.send("Error Colorlist %s not found on character: %s\n",colorlist,chars[s].name);
		return 0;
	}
	int loopexit=0;
	do
	{
		read1();
		if (script1[0]!='}')
		{
			i++;
		}
	}
	while ( (script1[0]!='}') && (++loopexit < MAXLOOPS) );
	closescript();
	if(i>0)
	{
		i=rand()%i;
		i++;
		openscript("colors.scp");
		if(!i_scripts[colors_script]->find(sect))
		{
			closescript();
			//sprintf(chars[s].name, "Error Colorlist %s Not Found(2)", colorlist);
			clConsole.send("Error Colorlist %s not found on character: %s\n",colorlist,chars[s].name);
			return 0;
		}
		loopexit=0;
		do
		{
			read1();
			if (script1[0]!='}')
			{
				j++;
				if(j==i)
				{
					haircolor=hstr2num(script1);
				}
			}
		}
		while ((script1[0]!='}') && (++loopexit < MAXLOOPS) );
		closescript();
	}
	return (haircolor);
}

void setrandomname(int s, char * namelist)
{
	char sect[512];
	int i=0,j=0;

	sprintf(sect, "RANDOMNAME %s", namelist);
	Script *pScpBase=i_scripts[npc_script];
	Script *pScp=pScpBase->Select(sect,custom_npc_script);
	if (!pScp)
	{
		sprintf(chars[s].name, "Error Namelist %s Not Found", namelist);
		return;
	}

	int loopexit=0;
	do
	{
		pScp->NextLine();
		if (script1[0]!='}')
		{
			i++;
		}
	}
	while ((script1[0]!='}') && (++loopexit < MAXLOOPS) );
	pScp->Close();

	if(i>0)
	{
		i=rand()%(i);
		pScp=pScpBase->Select(sect,custom_npc_script);
		if (!pScp) return;

		loopexit=0;
		do
		{
			pScp->NextLine();
			if (script1[0]!='}')
			{
				if(j==i)
				{
					strcpy(chars[s].name,(char*)script1);
					break;
				}
				else j++;
			}
		}
		while ((script1[0]!='}') && (++loopexit < MAXLOOPS) );
		pScp->Close();
	}
}

void cChar::Init(bool ser)
{
	static unsigned int LastInitTE=0;
	unsigned int i;

	if (this->serial==charcount) charcount++;

	if (ser)
	{
		this->ser1 = static_cast<unsigned char>(charcount2>>24); // Character serial number
		this->ser2 = static_cast<unsigned char>(charcount2>>16);
		this->ser3 = static_cast<unsigned char>(charcount2>>8);
		this->ser4 = static_cast<unsigned char>(charcount2%256);
		this->serial = charcount2;
		setptr(&charsp[charcount2%HASHMAX], DEREF_P_CHAR(this));
		charcount2++;
	}
	else
	{
		this->ser1=0;
		this->ser2=0;
		this->ser3=0;
		this->ser4=0;
		this->serial=-1;
	}
	this->multis=-1;//Multi serial
	this->free = false;
	strcpy(this->name,"Mr. noname");
	strcpy(this->orgname,"Mr. noname");
	this->title[0]=0x00;

	this->antispamtimer=0;//LB - anti spam

	this->unicode = false; // This is set to 1 if the player uses unicode speech, 0 if not
	this->account=-1;
	this->x=100;
	this->y=100;
	this->z=this->dispz=0;
	
	this->oldx=0; // fix for jail bug
	this->oldy=0; // fix for jail bug
	this->oldz=0; // LB, experimental, change back to unsignbed if this give sproblems
	this->race=0; // -Fraz- Race AddOn
	this->dir=0; //&0F=Direction
	this->id1=this->xid1=0x01; // Character body type
	this->id2=this->xid2=0x90; // Character body type
	this->skin = this->xskin = 0x0000; // Skin color
	this->keynumb=-1;  // for renaming keys 
	this->setPriv(0);	// 1:GM clearance, 2:Broadcast, 4:Invulnerable, 8: single click serial numbers
	// 10: Don't show skill titles, 20: GM Pagable, 40: Can snoop others packs, 80: Counselor clearance
	this->priv2=0;	// 1:Allmove, 2: Frozen, 4: View houses as icons, 8: permanently hidden
	// 10: no need mana, 20: dispellable, 40: permanent magic reflect, 80: no need reagents
	for (i=0;i<7;i++)
		this->priv3[i]=0;  // needed for Lord bianrys meta-gm stuff
	this->fonttype=3; // Speech font to use
	this->saycolor=0x1700; // Color for say messages
	this->emotecolor1=0x00; // Color for emote messages
	this->emotecolor2=0x23; // Color for emote messages
	this->st=50; // Strength
	this->st2=0; // Reserved for calculation
	this->dx=50; // Dexterity
	this->dx2=0; // Reserved for calculation
	this->tmpDex=0; // Reserved for calculation
	this->in=50; // Intelligence
	this->in2=0; // Reserved for calculation
	this->hp=50; // Hitpoints
	this->stm=50; // Stamina
	this->mn=50; // Mana
	this->mn2=0; // Reserved for calculation
	this->hidamage=0; //NPC Damage
	this->lodamage=0; //NPC Damage
	this->jailtimer=0; //blackwinds jail system 
    this->jailsecs=0;
	
	this->creationday = getPlatformDay() ;
	for (i=0;i<TRUESKILLS;i++)
	{
		this->baseskill[i]=0;
		this->skill[i]=0;
	}
	this->npc=0;
	this->shop=0; //1=npc shopkeeper
	this->cell=0; // Reserved for jailing players 
	            // bugfix, LB 0= player not in jail !, not -1
	
	this->jailtimer=0; //blackwinds jail system
	this->jailsecs=0;

	this->ownserial=-1; // If Char is an NPC, this sets its owner
	this->tamed = false; // True if NPC is tamed
	this->robe = -1; // Serial number of generated death robe (If char is a ghost)
	this->karma=0;
	this->fame=0;
	this->pathnum = PATHNUM;
	this->kills=0; //PvP Kills
	this->deaths=0;
	this->dead = false; // Is character dead
	this->packitem=-1; // Only used during character creation
	this->fixedlight=255; // Fixed lighting level (For chars in dungeons, where they dont see the night)
	// changed to -1, LB, bugfix
	this->speech=0; // For NPCs: Number of the assigned speech block
	this->weight=0; //Total weight
	this->att=0; // Intrinsic attack (For monsters that cant carry weapons)
	this->def=0; // Intrinsic defense
	this->war=0; // War Mode
	this->targ=-1; // Current combat target
	this->timeout=0; // Combat timeout (For hitting)
	this->timeout2=0;
	this->regen=0;
	this->regen2=0;
	this->regen3=0;//Regeneration times for mana, stamin, and str
	this->runenumb=-1; // Used for naming runes
	this->attacker=-1; // Character who attacked this character
	this->npcmovetime=0; // Next time npc will walk
	this->npcWander=0; // NPC Wander Mode
	this->oldnpcWander=0; // Used for fleeing npcs
	this->ftarg=-1; // NPC Follow Target
	this->fx1=-1; //NPC Wander Point 1 x
	this->fx2=-1; //NPC Wander Point 2 x
	this->fy1=-1; //NPC Wander Point 1 y
	this->fy2=-1; //NPC Wander Point 2 y
	this->fz1=0; //NPC Wander Point 1 z
	this->spawnserial=-1; // Spawned by
	this->hidden=0; // 0 = not hidden, 1 = hidden, 2 = invisible spell
	this->invistimeout=0;
	this->resetAttackFirst(); // 0 = defending, 1 = attacked first
	this->onhorse=false; // On a horse?
	this->hunger=6;  // Level of hungerness, 6 = full, 0 = "empty"
	this->hungertime=0; // Timer used for hunger, one point is dropped every 20 min
	this->smeltitem=-1;
	this->tailitem=-1;
	this->npcaitype=0; // NPC ai
	this->callnum=-1; //GM Paging
	this->playercallnum=-1; //GM Paging
	this->pagegm=0; //GM Paging
	this->region=255;
	this->skilldelay=0;
	this->objectdelay=0;
	this->combathitmessage=0;
	this->making=-1; // skill number of skill using to make item, 0 if not making anything.
	this->blocked=0;
	this->dir2=0;
	this->spiritspeaktimer=0; // Timer used for duration of spirit speak
	this->spattack=0;
	this->spadelay=0;
	this->spatimer=0;
	this->taming=0; //Skill level required for taming
	this->summontimer=0; //Timer for summoned creatures.
	this->trackingtimer=0; // Timer used for the duration of tracking
	this->trackingtarget=0; // Tracking target ID
	for (i=0;i<MAXTRACKINGTARGETS;i++)
		this->trackingtargets[i]=0;
	this->fishingtimer=0; // Timer used to delay the catching of fish

	this->advobj=0; //Has used advance gate?
	
	this->poison=0; // used for poison skill 
	this->poisoned=0; // type of poison
	this->poisontime=0; // poison damage timer
	this->poisontxt=0; // poision text timer
	this->poisonwearofftime=0; // LB, makes poision wear off ...
	
	this->fleeat=0;
	this->reattackat=0;
	this->trigger=0; //Trigger number that character activates
	this->trigword[0]='\x00'; //Word that character triggers on.
	this->disabled=0; //Character is disabled for n cicles, cant trigger.
	this->disabledmsg[0] = 0; //Character disabled message. -- by Magius(CHE) 
	this->envokeid1=0x00; //ID1 of item user envoked
	this->envokeid2=0x00; //ID2 of item user envoked
	this->envokeitem=-1;
	this->split=0;
	this->splitchnc=0;
	this->targtrig=0; //Stores the number of the trigger the character for targeting
	this->ra=0;  // Reactive Armor spell
	this->trainer=0; // Serial of the NPC training the char, -1 if none.
	this->trainingplayerin=0; // Index in skillname of the skill the NPC is training the player in
	this->cantrain=true;
	// Begin of Guild Related Character information (DasRaetsel)
	this->guildtoggle=0;		// Toggle for Guildtitle								(DasRaetsel)
	this->guildtitle[0]='\x00';	// Title Guildmaster granted player						(DasRaetsel)
	this->guildfealty=-1;		// Serial of player you are loyal to (default=yourself)	(DasRaetsel)
	this->guildnumber=0;		// Number of guild player is in (0=no guild)			(DasRaetsel)
	this->GuildTraitor=false; 
	//this->flag=0x04; //1=red 2=grey 4=Blue 8=green 10=Orange
	this->flag=0x02; //1=red 2=grey 4=Blue 8=green 10=Orange // grey as default - AntiChrist
	this->tempflagtime=0;
	// End of Guild Related Character information
	this->murderrate=0; //#of ticks until one murder decays //REPSYS 
	this->crimflag=-1; //Time when No longer criminal -1=Not Criminal
	this->casting=0; // 0/1 is the cast casting a spell?
	this->spelltime=0; //Time when they are done casting....
	this->spell=0; //current spell they are casting....
	this->spellaction=0; //Action of the current spell....
	this->nextact=0; //time to next spell action....
	this->poisonserial=-1; //AntiChrist -- poisoning skill
	
	this->squelched=0; // zippy  - squelching
	this->mutetime=0; //Time till they are UN-Squelched.
	this->med=0; // 0=not meditating, 1=meditating //Morrolan - Meditation 
	this->stealth=-1; //AntiChrist - stealth ( steps already done, -1=not using )
	this->running=0; //AntiChrist - Stamina Loose while running
	this->logout=0;//Time till logout for this char -1 means in the world or already logged out //Instalog
	this->swingtarg=-1; //Tagret they are going to hit after they swing
	this->holdg=0; // Gold a player vendor is holding for Owner
	this->fly_steps=0; //LB -> used for flyging creatures
	this->menupriv=0; // Lb -> menu priv
	this->guarded=false; // True if CHAR is guarded by some NPC
	this->smoketimer=0;
	this->smokedisplaytimer=0;
	this->carve=-1; // AntiChrist - for new carving system
	this->antiguardstimer=0; // AntiChrist - for "GUARDS" call-spawn
	this->polymorph=false;//polymorph - AntiChrist
	this->incognito=false;//incognito - AntiChrist
	this->namedeed=5;
    this->postType = LOCALPOST;
    this->questDestRegion = 0;
    this->questOrigRegion= 0;
    this->questBountyReward= 0;
    this->questBountyPostSerial = 0;
    this->murdererSer = 0;
    this->spawnregion = 0;
    this->npc_type = 0;
    this->stablemaster_serial = 0;
	this->timeused_last = getNormalizedTime();
	this->time_unused = 0;

	for (i=0;i<TRUESKILLS;i++)
	{
		this->baseskill[i]=0;
		this->skill[i]=0;
	}
	for (i = 0; i < ALLSKILLS; i++) 
		this->lockSkill[i]=0;

	for (i = LastInitTE;i<=LastInitTE+5;i++)//Initialize next 5 TempEffects.
	{
		if (i<cmem*5 && i>-1)
		{
			teffects[i].sour1=255;
			teffects[i].sour2=255;
			teffects[i].sour3=255;
			teffects[i].sour4=255;
			teffects[i].dest1=255;
			teffects[i].dest2=255;
			teffects[i].dest3=255;
			teffects[i].dest4=255;
			teffects[i].expiretime=0;
			teffects[i].num=0;
			teffects[i].more1=255;
			teffects[i].more2=255;
			teffects[i].more3=255;
			teffects[i].dispellable=0;
		}
	}
	LastInitTE+=5;
}

void cCharStuff::DeleteChar (int k) // Delete character
{
	int j;//,serial; //Zippy lag
	//int ptr,ci;
	
	removeitem[1]=chars[k].ser1;
	removeitem[2]=chars[k].ser2;
	removeitem[3]=chars[k].ser3;
	removeitem[4]=chars[k].ser4;

	if (chars[k].spawnregion>0 && chars[k].spawnregion<255)
	{
		spawnregion[chars[k].spawnregion].current--;
	}


	removefromptr(&charsp[chars[k].serial%HASHMAX], k);
	
	if (chars[k].spawnserial!=-1) removefromptr(&cspawnsp[chars[k].spawnserial%HASHMAX], k);
	if (chars[k].ownserial!=-1) removefromptr(&cownsp[chars[k].ownserial%HASHMAX], k);
	
	for (j=0;j<now;j++)
	{
		if (perm[j]) Xsend(j, removeitem, 5);		
	}
	
	if (k>-1) mapRegions->RemoveItem(k+CharacterOffset); // taking it out of mapregions BEFORE x,y changed, LB
	
	chars[k].free=true;
	chars[k].x=20+(xcounter++);
	chars[k].y=50+(ycounter);
	chars[k].z=9;
	chars[k].summontimer=0;
	if (xcounter==40)
	{
		ycounter++;
		xcounter=0;
	}
	if (ycounter==80)
	{
		ycounter=0;
		xcounter=0;
	}
	
	if (cmemcheck<300)
	{
		cmemcheck++;
		freecharmem[cmemcheck]=k;
	}
	else cmemover=1;
}

bool cCharStuff::AllocateMemory(int NumberOfChars)
{
	bool memerr = false;
	cmem=NumberOfChars;
	if (cmem<100) cmem=100;
	cmem+=(2*CHAR_RESERVE);	// some reserve so realloc doesn't occur immediately after serverstart(Duke)

	clConsole.send(" Allocating initial dynamic Character memory of %i... ",cmem);
	if ((realchars= (cChar *) malloc(cmem*sizeof(cChar)) )==NULL)
		memerr=true;
	else if ((talkingto = (int *)malloc(cmem*sizeof(int)) )==NULL)
		memerr=1;
	else if ((teffects = (teffect_st *)malloc(cmem*5*sizeof(teffect_st)) )==NULL)//MAXEFFECTS = 5*MAXCHARS
		memerr=1;

	if (memerr)
	{
		clConsole.send("\nERROR: Could not Allocate character memory!\n");
		error=1;
		return false;
	}
	int ilimit=0 ;
	if ((cmem-200) > 0)
		ilimit = cmem-200 ;	
	for (int i=ilimit;i<cmem;i++)
		realchars[i].free=1;

	clConsole.send("Done\n");
	return true;
}

bool cCharStuff::ResizeMemory()
{
	char memerr=0;
	const int slots=4000;   // bugfix for crashes under w95/98, LB never ever touch this number ...
	// it has major influence on performance !! if it too low -> slow and can cause crashes under w95/98.
	// this is because w95/98 can only handle 8196 subsequent realloc calls ( crappy thing...)
	// free() calls DONT help !!!, btw so we have to make that number real big
	// under nt and unix this limit doesnt exist

	if ((realchars = (cChar *)realloc(realchars, (cmem + slots)*sizeof(cChar)))==NULL)
		memerr=1;
	else if ((talkingto = (int *)realloc(talkingto, (cmem + slots)*sizeof(int)))==NULL)
		memerr=1;
	else if ((teffects = (teffect_st *)realloc(teffects, (cmem*5+slots*5)*sizeof(teffect_st)))==NULL)//MAXEFFECTS = 5*MAXCHARS
		memerr=1;
	
	if (memerr)
	{
		LogCriticalVar("Could not reallocate item memory after %i. No more items will be created.\nWOLFPACK may become unstable.",imem);
		cwmWorldState->savenewworld(1);
		return false;
	}
	else
	{
		for (int i=cmem;i<cmem+slots;i++)
			realchars[i].free=1;
		cmem+=slots;
		moreCharMemoryRequested=false;
		return true;
	}
}

void cCharStuff::CheckMemoryRequest()
{
	if (moreCharMemoryRequested)
		ResizeMemory();
}

void cCharStuff::CollectReusableSlots()
{
	if (cmemover!=1)
	{
		cmemover=0;
		cmemcheck++;
		AllCharsIterator iter_char;
		for (iter_char.Begin(); iter_char.GetData() != NULL; iter_char++)
		{
			P_CHAR toCheck = iter_char.GetData();
			if (cmemcheck==300)
			{
				cmemover=1; 
				break;
			}
			if (toCheck->free)
			{
				freecharmem[cmemcheck] = DEREF_P_CHAR(toCheck);
				cmemcheck++;
			}
		}
	}
}

#if 0
int cCharStuff::GetReusableSlot()
{
	int newSlot=-1;
	unsigned int ctime=uiCurrentTime;
	static unsigned int NextMemCheck=0;

	if (cmemcheck==-1 &&						// no free slots on the stack and
		(NextMemCheck<=ctime || (overflow)))	// didn't search for slots in the past minute
	{
		NextMemCheck=ctime+speed.checkmem*60*MY_CLOCKS_PER_SEC;
		CollectReusableSlots();					// go look for slots !
	}

	if (cmemcheck!=-1)
	{
		newSlot=freecharmem[cmemcheck];
		cmemcheck--;
	}

	return newSlot;
}
#else
///////////////////////
// Name:	GetReusableSlot
// history:	by Duke, 6.09.2001
// Purpose:	searches for an empty slot in the chars array
//			It does this by simply searching from the *last* position where it found a slot.
//			If it reaches the end, it will search from the start. A timer prevents too many wrap-arounds.
//
int cCharStuff::GetReusableSlot()
{
	static unsigned int NextMemCheck=0;
	static unsigned int LastFree=0;	// remember this point in the array to continue search from here next time

	unsigned int ctime=uiCurrentTime;
	if (NextMemCheck<=ctime || (overflow))	// didn't wrap around in the past minute
	{
		unsigned int started=LastFree;		// remember where we started the search from here next time
		for (  ;LastFree<charcount;LastFree++)
		{
			if (chars[LastFree].free)
				return LastFree;	
		}
		// we have reached the end so start again from the beginning of the array
		for (LastFree=0;LastFree<started;LastFree++)
		{
			if (chars[LastFree].free)
				return LastFree;	
		}
		NextMemCheck=ctime+speed.checkmem*60*MY_CLOCKS_PER_SEC;	// nothing found, set time for next try
	}
	return -1;
}
#endif

int cCharStuff::MemCharFree()			// Find a free char slot
{
	if (charcount+CHAR_RESERVE >= cmem-C_W_O_1)	//less than 'Reserve' free slots left, so get more memory
		moreCharMemoryRequested=true;

	int c=GetReusableSlot();			// try to use the space of a deleted item
	if (c==-1)
	{
		if (charcount+1>=cmem-C_W_O_1)	//theres no more free sluts.. er slots
		{
			LogCritical("couldn't resize character memory in time");
			return -1;
		}
		c=charcount;
		charcount++;
	}
	return c;
}

#if 0
int cCharStuff::MemCharFree()
{
	unsigned int i, ctime=uiCurrentTime;
	signed int nChar=-1;
	static unsigned int NextMemCheck=0;
	char memerr=0;
	
	if (cmemcheck!=-1)
	{
		nChar=freecharmem[cmemcheck];
		cmemcheck--;
	}
	
	if (nChar==-1)
	{
		if (NextMemCheck<=ctime || (overflow))
		{
			NextMemCheck=ctime+speed.checkmem*60*MY_CLOCKS_PER_SEC; //60 seconds per min
			if (cmemover==1)
			{
				cmemover=0;
				cmemcheck++;
				for (i=0;i<charcount;i++)
				{
					if (cmemcheck==300)
					{
						cmemover=1; 
						break;
					}
					if (chars[i].free)
					{
						if (nChar==-1) nChar=i;
						else {
							freecharmem[cmemcheck]=i;
							cmemcheck++;
						}
					}
				}
			}
		}
	}

	int slots=3000*4;   // bugfix for crashes under w95/98, LB
	                  // never ever touch this number ...
	                  // it has major influence on performance !!
	                  // if it too low -> slow and can cause crashes under
	                  // w95/98. this is because w95/98 can only handle 8196 
	                  // subsequent realloc calls ( crappy thing...)
	                  // free() calls DOESNT help !!!, btw
	                  // so we have to make that number real big
	                  // under nt and unix this limit doesnt exist



	if (nChar==-1 && charcount>=cmem-C_W_O_1) //Lets ASSUME theres no more memory left instead of acctually checking all the items to find a free one.
	{
		
		if ((realchars = (cChar *)realloc(realchars, (cmem + slots)*sizeof(cChar)))==NULL)
			memerr=1;
		else if ((talkingto = (int *)realloc(talkingto, (cmem + slots)*sizeof(int)))==NULL)
			memerr=1;	
		else if ((teffects = (teffect_st *)realloc(teffects, (cmem*5+slots*5)*sizeof(teffect_st)))==NULL)//MAXEFFECTS = 5*MAXCHARS
			memerr=1;
        
		if (memerr)
		{
			clConsole.send("ERROR: Could not reallocate character memory after %i. No more characters will be created.\nWARNING: WOLFPACK may become unstable.\n", cmem);
			cwmWorldState->savenewworld(1);
			NextMemCheck=ctime+speed.checkmem*60*MY_CLOCKS_PER_SEC; //60 seconds per min
			if (cmemover==1)
			{
				cmemover=0;
				cmemcheck++;
				for (i=0;i<charcount;i++)
				{
					if (cmemcheck==300)
					{
						cmemover=1; 
						break;
					}
					if (chars[i].free)
					{
						if (nChar==-1) nChar=i;
						else {
							freecharmem[cmemcheck]=i;
							cmemcheck++;
						}
					}
				}
			}
		} else {
			for (i=cmem;i<cmem+slots;i++)	realchars[i].free = true;
			nChar=cmem-I_W_O_1;
			cmem+=slots;
		}
	} else if (nChar==-1) nChar = charcount++;
	
	return nChar;
}
#endif

int cCharStuff::AddRandomLoot(int s, char * lootlist)
{
	char sect[512];
	int i,j,retitem, storeval,loopexit=0;
	retitem=-1;
	storeval=-1;
	i=0; j=0;

	sprintf(sect, "LOOTLIST %s", lootlist);
	
	Script *pScpBase=i_scripts[npc_script];
	Script *pScp=pScpBase->Select(sect,custom_npc_script);
	if (!pScp) return -1;

	loopexit=0;
	do
	{
		pScp->NextLine();
		if (script1[0]!='}')
		{
			i++; // Count number of entries on list.
		}
	} while ( (script1[0]!='}') && (++loopexit < MAXLOOPS) );
	pScp->Close();

	if(i>0)
	{
		i=rand()%(i);
		pScp=pScpBase->Select(sect,custom_npc_script);

		loopexit=0;
		do
		{
			pScp->NextLine();
			if (script1[0]!='}')
			{
				if(j==i)
				{
					storeval=str2num(script1);	//script1 = ITEM#

					scpMark m=pScp->Suspend();
					retitem=Targ->AddMenuTarget(-1, 0, storeval);
					pScp->Resume(m);

					if(retitem!=-1)
					{
						items[retitem].x=50+(rand()%80);
						items[retitem].y=50+(rand()%80);
						items[retitem].z=9;
						setserial(retitem,s,1);
					}
					break;;    
				}
				else j++;
			}
		}	while ( (script1[0]!='}') && (++loopexit < MAXLOOPS) );
		pScp->Close();
	}
	return retitem;
}

/*** s: socket ***/
int cCharStuff::AddRandomNPC(int s, char * npclist, int spawnpoint)
{
	//This function gets the random npc number from the list and recalls
	//addrespawnnpc passing the new number
	char sect[512];
	unsigned int uiTempList[100];
	int i=0,k=0;
	sprintf(sect, "NPCLIST %s", npclist);

	Script *pScpBase=i_scripts[npc_script];
	Script *pScp=pScpBase->Select(sect,custom_npc_script);
	if (!pScp) return -1;

	int loopexit=0;
	do
	{
		pScp->NextLine();
		if (script1[0]!='}')
		{
			uiTempList[i]=str2num(script1);
			i++;
		}
	}
	while ( (script1[0]!='}') && (++loopexit < MAXLOOPS));
	pScp->Close();

	if(i>0)
	{
		i=rand()%(i);
		k=uiTempList[i];
	}
	if(k!=0)
	{
		if (spawnpoint==-1)
		{
			addmitem[s]=k;
			return Targ->NpcMenuTarget(s);
			//return -1;
		}
		else
		{
			return k; //addrespawnnpc(spawnpoint,k,1);
		}
	}
	return -1;
}

//o---------------------------------------------------------------------------o
//| Function   : AddNPC (3 interfaces)
//| Programmer : Duke, 23.05.2000
//o---------------------------------------------------------------------------o
//| Purpose    : creates the scripted NPC given by npcNum
//|              The position of the NPC can be given in three different ways:
//|				 1. by parms x1 y1 z1 (trigger)
//|				 2. by passing a socket (GM add)
//|				 3. by passing an item index (spawn rune)
//|
//| Remarks    : This function was created from the former AddRespawnNPC() and
//|				 AddNPCxyz() that were 95% identical
//o---------------------------------------------------------------------------o
int cCharStuff::AddRespawnNPC(int s, int npcNum, int type)
{
	if (type == 1)
		return AddNPC(-1, s, npcNum, 0,0,0);	// 's' is an item index
	else
		return AddNPC(s, -1, npcNum, 0,0,0);	// 's' is a socket
}
int cCharStuff::AddNPCxyz(int s, int npcNum, int type, int x1, int y1, signed char z1) //Morrolan - replacement for old Npcs->AddNPCxyz(), fixes a LOT of problems.
{
	if (type == 0)
		return AddNPC(s, -1, npcNum, x1,y1,z1);	// 's' maybe(!) is a socket
	if (type == 1)
		clConsole.send("ERROR: type == 1 not supported!\n");
	return -1;
}

int cCharStuff::AddNPC(int s, int i, int npcNum, int x1, int y1, signed char z1)
{
	int tmp, z,c,n, lovalue, hivalue, mypack, retitem;
	int storeval, shoppack1, shoppack2, shoppack3;
	int k=0, xos=0, yos=0, lb;
	char sect[512];
	int haircolor; //(we need this to remember the haircolor)
	haircolor=-1;
	short postype;				// determines how xyz of the new NPC are set, see below
	short fx1,fx2,fy1,fy2,fz1;	// temp. hold the rectangle or circle for npcwander from script
	fx1=fx2=fy1=fy2=fz1=0;

	if (x1 > 0 && y1 > 0)
 		postype = 3;	// take position from parms
	else if ( s > -1 && i == -1)
		postype = 2;	// take position from socket's buffer
	else if ( s == -1 && i > -1)
		postype = 1;	// take position from items[i]
	else
	{
		clConsole.send("ERROR: bad parms in call to AddNPC\n");
		return -1;
	}

	mypack=-1;
	retitem=-1;
	storeval=-1;
	shoppack1=-1;
	shoppack2=-1;
	shoppack3=-1;
	//
	// First things first...lets find out what NPC# we should spawn
	//
	Script *pScpBase=i_scripts[npc_script];
	sprintf(sect, "NPC %i", npcNum);
	Script *pScp=pScpBase->Select(sect,custom_npc_script);
	if (!pScp) return -1;
	
	int loopexit=0;
	do
	{
		pScp->NextLineSplitted();
		if (script1[0]!='}')
		{
			if (!(strcmp("NPCLIST", (char*)script1)))
			{
				scpMark m=pScp->Suspend();

//				if (postype==1 || postype==3)	// we have a pos from item or parms
//				{
					npcNum=Npcs->AddRandomNPC(s,(char*)script2,1);
					sprintf(sect, "NPC %i", npcNum);
					if (npcNum==-1) 
					{ 
						pScp->Close();
						return -1;
					}
/*				}
				else
				{
					npcNum=Npcs->AddRandomNPC(s,script2,-1);	// ask for position
					if (npcNum==-1) 
					{
						closescript(); // AC
						return -1;
					}
				}
				//AntiChrist */
				pScp->Resume(m);
				break;  //got the NPC number to add stop reading
			}
		}
	} while ( (script1[0]!='}') && (++loopexit < MAXLOOPS) );

	pScp->Close();
	
	//
	// Now lets spawn him/her
	//
	c=Npcs->MemCharFree ();
	if(c==-1) return -1;
	P_CHAR pc_c = MAKE_CHARREF_LRV(c,-1);
	pc_c->Init();
	

	pc_c->setPriv(0x10);
	pc_c->npc=1;
	pc_c->att=1;
	pc_c->def=1;
	pc_c->spawnserial=-1;
	
	pScp=pScpBase->Select(sect,custom_npc_script);
	if (!pScp)
	{
		Npcs->DeleteChar(c);
		return -1;
	}

	loopexit=0;
	do
	{
		pScp->NextLineSplitted();

		if (script1[0]!='}') {
			switch(script1[0])
			{
			case 'A':
			case 'a':
			if (!strcmp("ALCHEMY",(char*)script1))		pc_c->baseskill[ALCHEMY] = getstatskillvalue((char*)script2);
			else if (!strcmp("ANATOMY",(char*)script1))		pc_c->baseskill[ANATOMY] = getstatskillvalue((char*)script2);
			else if (!strcmp("ARCHERY",(char*)script1))		pc_c->baseskill[ARCHERY] = getstatskillvalue((char*)script2);
			else if (!strcmp("ARMSLORE",(char*)script1))		pc_c->baseskill[ARMSLORE] = getstatskillvalue((char*)script2);
			else if (!strcmp("ANIMALLORE",(char*)script1))	pc_c->baseskill[ANIMALLORE] = getstatskillvalue((char*)script2);
			break;

			case 'B':
			case 'b':
			if (!strcmp("BACKPACK", (char*)script1))
			{
				if (mypack==-1)
				{
					scpMark m=pScp->Suspend();
					pc_c->packitem=n=Items->SpawnItem(-1,c,1,"Backpack",0,0x0E,0x75,0,0,0,0);
					if(n==-1)
					{
						Npcs->DeleteChar(c);
						return -1;
					}
					items[n].x=0;
					items[n].y=0;
					items[n].z=0;
					setserial(n,c,4);
					items[n].layer=0x15;
					items[n].type=1;
					items[n].dye=1;
					mypack=n;
					
					retitem=n;
					pScp->Resume(m);
					strcpy((char*)script1, "DUMMY"); // Prevents unexpected matchups...
				}
			}
			else if (!strcmp("BEGGING",(char*)script1))			pc_c->baseskill[BEGGING] = getstatskillvalue((char*)script2);
			else if (!strcmp("BLACKSMITHING",(char*)script1))	pc_c->baseskill[BLACKSMITHING] = getstatskillvalue((char*)script2);
			else if (!strcmp("BOWCRAFT",(char*)script1))			pc_c->baseskill[BOWCRAFT] = getstatskillvalue((char*)script2);
			break;

			case 'C':
			case 'c':

			if (!strcmp("COLOR",(char*)script1)) {
				if (retitem>-1)
				{
					items[retitem].color1=(hstr2num(script2))>>8;
					items[retitem].color2=(hstr2num(script2))%256;
				}
			}
			else if (!strcmp("CARVE",(char*)script1)) pc_c->carve=str2num(script2);
			else if (!strcmp("CAMPING",(char*)script1)) pc_c->baseskill[CAMPING] = getstatskillvalue((char*)script2);
			else if (!strcmp("CARPENTRY",(char*)script1)) pc_c->baseskill[CARPENTRY] = getstatskillvalue((char*)script2);
			else if (!strcmp("CARTOGRAPHY",(char*)script1)) pc_c->baseskill[CARTOGRAPHY] = getstatskillvalue((char*)script2);
			else if (!strcmp("CANTRAIN",(char*)script1)) pc_c->cantrain=true;
			else if (!strcmp("COOKING",(char*)script1)) pc_c->baseskill[COOKING] = getstatskillvalue((char*)script2);
			else if (!strcmp("COLORMATCHHAIR",(char*)script1))
			{
				if (retitem>-1 && haircolor!=-1)
				{
					items[retitem].color1=(haircolor)>>8;
					items[retitem].color2=(haircolor)%256;
				}
			}
			else if (!strcmp("COLORLIST",(char*)script1))
			{
				scpMark m=pScp->Suspend();
				storeval=addrandomcolor(c,(char*)script2);
				if (retitem>-1)
				{
					items[retitem].color1=(storeval)>>8;
					items[retitem].color2=(storeval)%256;
				}
				pScp->Resume(m);
				strcpy((char*)script1, "DUMMY"); // To prevent accidental exit of loop.
			}
			break;

			case 'D':
			case 'd':

			if (!strcmp("DIRECTION",(char*)script1)) {
				if (!strcmp("NE",(char*)script2)) pc_c->dir=1;
				else if (!strcmp("E",(char*)script2)) pc_c->dir=2;
				else if (!strcmp("SE",(char*)script2)) pc_c->dir=3;
				else if (!strcmp("S",(char*)script2)) pc_c->dir=4;
				else if (!strcmp("SW",(char*)script2)) pc_c->dir=5;
				else if (!strcmp("W",(char*)script2)) pc_c->dir=6;
				else if (!strcmp("NW",(char*)script2)) pc_c->dir=7;
				else if (!strcmp("N",(char*)script2)) pc_c->dir=0;
			}
			else if (!strcmp("DEX",(char*)script1) || !strcmp("DEXTERITY",(char*)script1)) 
			{
				pc_c->setDex(getstatskillvalue((char*)script2));
				pc_c->stm = pc_c->realDex();
			}
			else if (!strcmp("DEF",(char*)script1)) pc_c->def = getstatskillvalue((char*)script2);
			else if (!strcmp("DETECTINGHIDDEN",(char*)script1)) pc_c->baseskill[DETECTINGHIDDEN] = getstatskillvalue((char*)script2);
			else if (!strcmp("DAMAGE",(char*)script1) || !strcmp("ATT",(char*)script1)) {
				gettokennum((char*)script2, 0);
				lovalue=str2num(gettokenstr);
				gettokennum((char*)script2, 1);
				hivalue=str2num(gettokenstr);
				pc_c->lodamage = lovalue;
				pc_c->hidamage = lovalue;
				if(hivalue) {
					pc_c->hidamage = hivalue;
				}
			}
			break;

			case 'E':
			case 'e':

			if (!(strcmp("EMOTECOLOR",(char*)script1))) {
				pc_c->emotecolor1=(hstr2num(script2))>>8;
				pc_c->emotecolor2=(hstr2num(script2))%256;
			}
			else if (!strcmp("ENTICEMENT",(char*)script1)) pc_c->baseskill[ENTICEMENT] = getstatskillvalue((char*)script2);
			else if (!strcmp("EVALUATINGINTEL",(char*)script1)) pc_c->baseskill[EVALUATINGINTEL] = getstatskillvalue((char*)script2);
			break;

			case 'F':
			case 'f':

			if (!strcmp("FISHING",(char*)script1)) pc_c->baseskill[FISHING] = getstatskillvalue((char*)script2);
			else if (!strcmp("FORENSICS",(char*)script1)) pc_c->baseskill[FORENSICS] = getstatskillvalue((char*)script2);
			else if (!strcmp("FX1",(char*)script1)) fx1=str2num(script2);  // new NPCWANDER implementation
			else if (!strcmp("FX2",(char*)script1)) fx2=str2num(script2);
			else if (!strcmp("FLEEAT",(char*)script1)) pc_c->fleeat=str2num(script2);
			else if (!strcmp("FAME",(char*)script1)) pc_c->fame=str2num(script2);
			else if (!strcmp("FENCING",(char*)script1)) pc_c->baseskill[FENCING] = getstatskillvalue((char*)script2);
			else if (!strcmp("FY1",(char*)script1)) fy1=str2num(script2);
			else if (!strcmp("FY2",(char*)script1)) fy2=str2num(script2);
			else if (!strcmp("FZ1",(char*)script1)) fz1=str2num(script2);
			break;

			case 'G':
			case 'g':

			if (!strcmp("GOLD", (char*)script1))
			{
				if (mypack!=-1)
				{ 
					scpMark m=pScp->Suspend();
					P_ITEM pGold=Items->SpawnItem(c,1,"#",1,0x0EED,0,1);
					if(!pGold)
					{
						Npcs->DeleteChar(c);
						return -1;
					}
					pScp->Resume(m);

					pGold->priv|=0x01;
					gettokennum((char*)script2, 0);
					lovalue=str2num(gettokenstr);
					gettokennum((char*)script2, 1);
					hivalue=str2num(gettokenstr);
					if (hivalue==0)
					{
						if (lovalue/2!=0) pGold->amount=lovalue/2 + (rand()%(lovalue/2));
						else pGold->amount=0;
					} else
					{
						if (hivalue-lovalue!=0) pGold->amount=lovalue + (rand()%(hivalue-lovalue));
						else pGold->amount=lovalue;
					}
					//setserial(n,mypack,1);
				}
				else
					clConsole.send("Warning: Bad NPC Script %d with problem no backpack for gold.\n", npcNum);
			}
			break;

			case 'H':
			case 'h':

			if (!strcmp("HEALING",(char*)script1)) pc_c->baseskill[HEALING] = getstatskillvalue((char*)script2);
			else if (!strcmp("HIDAMAGE",(char*)script1)) pc_c->hidamage=str2num(script2);
			else if (!strcmp("HERDING",(char*)script1)) pc_c->baseskill[HERDING] = getstatskillvalue((char*)script2);
			else if (!strcmp("HIDING",(char*)script1)) pc_c->baseskill[HIDING] = getstatskillvalue((char*)script2);
			else if (!strcmp("HAIRCOLOR",(char*)script1))
			{
				scpMark m=pScp->Suspend();
				
				if (retitem >-1) // LB, ouple of bugfixes
				{
					haircolor=addrandomhaircolor(c,(char*)script2);
					if (haircolor!=-1)
					{
						items[retitem].color1=(haircolor)>>8;
						items[retitem].color2=(haircolor)%256;
					}
				}
				pScp->Resume(m);
				strcpy((char*)script1, "DUMMY"); // To prevent accidental exit of loop.
			}
			break;

			case 'I':
			case 'i':

			if (!strcmp("ID",(char*)script1)) {
				tmp=hstr2num(script2);
				pc_c->id1=tmp>>8;
				pc_c->id2=tmp%256;
				pc_c->xid1=pc_c->id1;
				pc_c->xid2=pc_c->id2;
			}
			else if (!strcmp("ITEM",(char*)script1)) {
				storeval=str2num(script2);

				scpMark m=pScp->Suspend();
				retitem=Targ->AddMenuTarget(-1, 0, storeval);
				pScp->Resume(m);

				if (retitem!=-1)
				{
					setserial(retitem,c,4);
					if (items[retitem].layer==0) {
						clConsole.send("Warning: Bad NPC Script %d with problem item %d executed!\n", npcNum, storeval);
					}
				}
				strcpy((char*)script1, "DUMMY"); // Prevents unexpected matchups...
			}
			else if (!strcmp("INT",(char*)script1) || !strcmp("INTELLIGENCE",(char*)script1)) {
				pc_c->in  = getstatskillvalue((char*)script2);
				pc_c->in2 = pc_c->in;
				pc_c->mn  = pc_c->in;
			}
			//Done Handling Stats
			//Handle Skills
			else if (!strcmp("ITEMID",(char*)script1)) pc_c->baseskill[ITEMID] = getstatskillvalue((char*)script2);
			else if (!strcmp("INSCRIPTION",(char*)script1)) pc_c->baseskill[INSCRIPTION] = getstatskillvalue((char*)script2);
			break;
			
			case 'K':
			case 'k':
			if (!strcmp("KARMA",(char*)script1)) pc_c->karma=str2num(script2);
			break;

			case 'L':
			case 'l':

			if (!strcmp("LOOT",(char*)script1))
			{
				if (mypack!=-1)
				{
					scpMark m=pScp->Suspend();
					retitem=Npcs->AddRandomLoot(mypack, script2);
					pScp->Resume(m);

					strcpy((char*)script1, "DUMMY"); // Prevents unexpected matchups...
				} else
				{
					clConsole.send("Warning: Bad NPC Script %d with problem no backpack for loot.\n", npcNum);
				}
			}
			else if (!strcmp("LODAMAGE",(char*)script1)) pc_c->lodamage=str2num(script2);
			else if (!strcmp("LUMBERJACKING",(char*)script1)) pc_c->baseskill[LUMBERJACKING] = getstatskillvalue((char*)script2);
			else if (!strcmp("LOCKPICKING",(char*)script1)) pc_c->baseskill[LOCKPICKING] = getstatskillvalue((char*)script2);
			break;

			case 'M':
			case 'm':
			if ((!(strcmp("MACEFIGHTING",(char*)script1)))||(!(strcmp("SKILL41",(char*)script1)))) pc_c->baseskill[MACEFIGHTING] = getstatskillvalue((char*)script2);
			else if ((!(strcmp("MINING",(char*)script1)))||(!(strcmp("SKILL45",(char*)script1)))) pc_c->baseskill[MINING] = getstatskillvalue((char*)script2);
			else if ((!(strcmp("MAGERY",(char*)script1)))||(!(strcmp("SKILL25",(char*)script1)))) pc_c->baseskill[MAGERY] = getstatskillvalue((char*)script2);
			else if ((!(strcmp("MAGICRESISTANCE",(char*)script1)))||(!(strcmp("RESIST",(char*)script1)))||(!(strcmp("SKILL26",(char*)script1)))) pc_c->baseskill[MAGICRESISTANCE] = getstatskillvalue((char*)script2);
			else if ((!(strcmp("MUSICIANSHIP",(char*)script1)))||(!(strcmp("SKILL29",(char*)script1)))) pc_c->baseskill[MUSICIANSHIP] = getstatskillvalue((char*)script2);
			else if ((!(strcmp("MEDITATION",(char*)script1)))||(!(strcmp("SKILL46",(char*)script1)))) pc_c->baseskill[MEDITATION] = getstatskillvalue((char*)script2);
			break;

			case 'N':
			case 'n':

			if (!(strcmp("NAME",(char*)script1))) strcpy(pc_c->name, (char*)script2);
			else if (!(strcmp("NAMELIST", (char*)script1))) {
				scpMark m=pScp->Suspend();
				setrandomname(c,(char*)script2);
				pScp->Resume(m);
				strcpy((char*)script1, "DUMMY"); // To prevent accidental exit of loop.
			}
			else if (!(strcmp((char*)script1, "NOTRAIN"))) pc_c->cantrain=false;
			else if (!(strcmp("NPCWANDER",(char*)script1))) pc_c->npcWander=str2num(script2);
			else if (!(strcmp("NPCAI",(char*)script1))) pc_c->npcaitype=hstr2num(script2);
			break;

			case 'O':
			case 'o':
			if (!(strcmp("ONHORSE",(char*)script1))) pc_c->onhorse=true;
			break;

			case 'P':
			case 'p':

			if (!strcmp("PARRYING",(char*)script1)) pc_c->baseskill[PARRYING] = getstatskillvalue((char*)script2);
			else if (!(strcmp("PRIV1",(char*)script1))) pc_c->setPriv(str2num(script2));
			else if (!(strcmp("PRIV2",(char*)script1))) pc_c->priv2=str2num(script2);
			else if (!(strcmp("POISON",(char*)script1))) pc_c->poison=str2num(script2);
			else if ((!(strcmp("PEACEMAKING",(char*)script1)))||(!(strcmp("SKILL9",(char*)script1)))) pc_c->baseskill[PEACEMAKING] = getstatskillvalue((char*)script2);
			else if ((!(strcmp("PROVOCATION",(char*)script1)))||(!(strcmp("SKILL22",(char*)script1)))) pc_c->baseskill[PROVOCATION] = getstatskillvalue((char*)script2);
			else if ((!(strcmp("POISONING",(char*)script1)))||(!(strcmp("SKILL30",(char*)script1)))) pc_c->baseskill[POISONING] = getstatskillvalue((char*)script2);
			else if (!(strcmp("PACKITEM",(char*)script1)))
			{
				if (mypack!=-1) {
					storeval=str2num(script2);

					scpMark m=pScp->Suspend();
					retitem=Targ->AddMenuTarget(-1, 0, storeval);
					pScp->Resume(m);

					if (retitem!=-1)
					{
						setserial(retitem,mypack,1);
						items[retitem].x=50+(rand()%80);
						items[retitem].y=50+(rand()%80);
						items[retitem].z=9;
					}
					strcpy((char*)script1, "DUMMY"); // Prevents unexpected matchups...
				} else
				{
					clConsole.send("Warning: Bad NPC Script %d with problem no backpack for packitem.\n", npcNum);
				}
			}
			break;

			case 'R':
			case 'r':
			if (!(strcmp("RACE",(char*)script1))) pc_c->race=str2num(script2);
			else if (!(strcmp("REATTACKAT",(char*)script1))) pc_c->reattackat=str2num(script2);
			else if ((!(strcmp("REMOVETRAPS",(char*)script1)))||(!(strcmp("SKILL48",(char*)script1)))) pc_c->baseskill[REMOVETRAPS] = getstatskillvalue((char*)script2);
			else if (!(strcmp("RSHOPITEM",(char*)script1)))
			{
				if (shoppack1==-1)
				{
					for(z=0;z<itemcount;z++)
					{
						if (!items[z].free)
						{
							if (pc_c->Wears(&items[z]) &&
								items[z].layer==0x1A)
							{
								shoppack1=z;
								break;
							}
						}
					}
					//if (shoppack1 == -1)
					  //LogError("Error creating shoppack1\n");
				}
				if (shoppack1!=-1)
				{
					storeval=str2num(script2);

					scpMark m=pScp->Suspend();
					retitem=Targ->AddMenuTarget(-1, 0, storeval);
					pScp->Resume(m);

					if (retitem!=-1)
					{
						setserial(retitem,shoppack1,1);
						items[retitem].x=50+(rand()%80);
						items[retitem].y=50+(rand()%80);
						items[retitem].z=9;
						if (items[retitem].name2 && (strcmp(items[retitem].name2,"#"))) strcpy(items[retitem].name,items[retitem].name2); // Item identified! -- by Magius(CHE)					}
					}
					strcpy((char*)script1, "DUMMY"); // Prevents unexpected matchups...
				} else
				{
					clConsole.send("Warning: Bad NPC Script %d with problem no shoppack1 for item.\n", npcNum);
				}
			}
			break;

			case 'S':
			case 's':

			if (!(strcmp("SKIN",(char*)script1))) {
				pc_c->skin = pc_c->xskin = hstr2num(script2);
			}
			else if (!(strcmp("SHOPKEEPER", (char*)script1))) {
				scpMark m=pScp->Suspend();
				Commands->MakeShop(c); 
				pScp->Resume(m);
			}
			else if (!(strcmp("SELLITEM",(char*)script1))) {
				if (shoppack3==-1) {
					for(z=0;z<itemcount;z++) {
						if (!items[z].free)
						{
							if (pc_c->Wears(&items[z]) &&
								items[z].layer==0x1C)
							{
								shoppack3=z;
								break;
							}
						}
					}
				}
				if (shoppack3!=-1) {
					storeval=str2num(script2);

					scpMark m=pScp->Suspend();
					retitem=Targ->AddMenuTarget(-1, 0, storeval);
					pScp->Resume(m);

					if (retitem!=-1)
					{
						setserial(retitem,shoppack3,1);
						items[retitem].value=items[retitem].value/2;
						items[retitem].x=50+(rand()%80);
						items[retitem].y=50+(rand()%80);
						items[retitem].z=9;
						if (items[retitem].name2 && (strcmp(items[retitem].name2,"#"))) strcpy(items[retitem].name,items[retitem].name2); // Item identified! -- by Magius(CHE)					}
					}
					strcpy((char*)script1, "DUMMY"); // Prevents unexpected matchups...
				} else
				{
					clConsole.send("Warning: Bad NPC Script %d with problem no shoppack3 for item.\n", npcNum);
				}
			}
			else if (!(strcmp("SHOPITEM",(char*)script1)))
			{
				if (shoppack2==-1)
				{
					for(z=0;z<itemcount;z++)
					{
						if (!items[z].free)
						{
							if (pc_c->Wears(&items[z]) && items[z].layer==0x1B)
							{
								shoppack2=z;
								break;
							}
						}
					}
				}
				if (shoppack2!=-1)
				{
					storeval=str2num(script2);

					scpMark m=pScp->Suspend();
					retitem=Targ->AddMenuTarget(-1, 0, storeval);
					pScp->Resume(m);

					if (retitem!=-1)
					{
						setserial(retitem,shoppack2,1);
						items[retitem].x=50+(rand()%80);
						items[retitem].y=50+(rand()%80);
						items[retitem].z=9;
						if (items[retitem].name2 && (strcmp(items[retitem].name2,"#"))) strcpy(items[retitem].name,items[retitem].name2); // Item identified! -- by Magius(CHE)					}
					}
					strcpy((char*)script1, "DUMMY"); // Prevents unexpected matchups...
				} else
				{
					clConsole.send("Warning: Bad NPC Script %d with problem no shoppack2 for item.\n", npcNum);
				}
			}
			else if (!(strcmp("SPATTACK",(char*)script1))) pc_c->spattack=str2num(script2);
			else if (!(strcmp("SPEECH",(char*)script1))) pc_c->speech=str2num(script2);
			else if (!(strcmp("SPLIT",(char*)script1))) pc_c->split=str2num(script2);
			else if ((!(strcmp("STR",(char*)script1)))||(!(strcmp("STRENGTH",(char*)script1)))) {
				pc_c->st  = getstatskillvalue((char*)script2);
				pc_c->st2 = pc_c->st;
				pc_c->hp  = pc_c->st;
			}
			else if (!(strcmp("SPLITCHANCE",(char*)script1))) pc_c->splitchnc=str2num(script2);
			else if (!(strcmp("SAYCOLOR",(char*)script1))) 			pc_c->saycolor = static_cast<UI16>(hstr2num(script2));
			else if (!(strcmp("SPADELAY",(char*)script1))) pc_c->spadelay=str2num(script2);
			else if ((!(strcmp("SPIRITSPEAK",(char*)script1)))||(!(strcmp("SKILL32",(char*)script1)))) pc_c->baseskill[SPIRITSPEAK] = getstatskillvalue((char*)script2);
			else if ((!(strcmp("STEALTH",(char*)script1)))||(!(strcmp("SKILL47",(char*)script1)))) pc_c->baseskill[STEALTH] = getstatskillvalue((char*)script2);
			else if ((!(strcmp("SWORDSMANSHIP",(char*)script1)))||(!(strcmp("SKILL40",(char*)script1)))) pc_c->baseskill[SWORDSMANSHIP] = getstatskillvalue((char*)script2);
			else if ((!(strcmp("SNOOPING",(char*)script1)))||(!(strcmp("SKILL28",(char*)script1)))) pc_c->baseskill[SNOOPING] = getstatskillvalue((char*)script2);
			else if ((!(strcmp("STEALING",(char*)script1)))||(!(strcmp("SKILL33",(char*)script1)))) pc_c->baseskill[STEALING] = getstatskillvalue((char*)script2);
			else if (!(strcmp("SKINLIST",(char*)script1)))
			{
				scpMark m=pScp->Suspend();
				pc_c->xskin = pc_c->skin = addrandomcolor(c,(char*)script2);
				pScp->Resume(m);
				strcpy((char*)script1, "DUMMY"); // To prevent accidental exit of loop.
			}
			else if (!(strcmp("SKILL", (char*)script1)))
			{
				gettokennum((char*)script2, 0);
				z=str2num(gettokenstr);
				gettokennum((char*)script2, 1);
				pc_c->baseskill[z]=str2num(gettokenstr);
			}

            else if (!(strcmp("STABLEMASTER",(char*)script1))) pc_c->npc_type=1;
			break;

			case 'T':
			case 't':
			if (!(strcmp("TITLE",(char*)script1))) strcpy(pc_c->title, script2);
			else if ((!(strcmp("TOTAME", (char*)script1)))||(!(strcmp("TAMING", (char*)script1)))) pc_c->taming=str2num(script2);
			else if (!(strcmp("TRIGGER",(char*)script1)))	pc_c->trigger=str2num(script2);
			else if (!(strcmp("TRIGWORD",(char*)script1)))	strcpy(pc_c->trigword,(char*)script2);
			else if ((!(strcmp("TACTICS",(char*)script1)))||(!(strcmp("SKILL27",(char*)script1)))) pc_c->baseskill[TACTICS] = getstatskillvalue((char*)script2);
			else if ((!(strcmp("TAILORING",(char*)script1)))||(!(strcmp("SKILL34",(char*)script1)))) pc_c->baseskill[TAILORING] = getstatskillvalue((char*)script2);
			else if ((!(strcmp("TAMING",(char*)script1)))||(!(strcmp("SKILL35",(char*)script1)))) pc_c->baseskill[TAMING] = getstatskillvalue((char*)script2);
			else if ((!(strcmp("TASTEID",(char*)script1)))||(!(strcmp("SKILL36",(char*)script1)))) pc_c->baseskill[TASTEID] = getstatskillvalue((char*)script2);
			else if ((!(strcmp("TINKERING",(char*)script1)))||(!(strcmp("SKILL37",(char*)script1)))) pc_c->baseskill[TINKERING] = getstatskillvalue((char*)script2);
			else if ((!(strcmp("TRACKING",(char*)script1)))||(!(strcmp("SKILL38",(char*)script1)))) pc_c->baseskill[TRACKING] = getstatskillvalue((char*)script2);
			break;

			case 'V':
			case 'v':
			if (!(strcmp("VALUE",(char*)script1))) if (retitem!=-1) items[retitem].value=(str2num(script2));
			else if (!strcmp("VETERINARY",(char*)script1)) pc_c->baseskill[VETERINARY] = getstatskillvalue((char*)script2);
			break;
			
			case 'W':
			case 'w':
			if ((!(strcmp("WRESTLING",(char*)script1)))||(!(strcmp("SKILL43",(char*)script1)))) pc_c->baseskill[WRESTLING] = getstatskillvalue((char*)script2);
			break;

			default:
				clConsole.send("Warning: Fall out of switch statement in npcs.cpp AddNPC()\n");
			}
			
			//Done Handling Skills
			//Handle Extras

			//Done Handling Obsolete Stuff
			//--------------- DONE NEW STAT & SKILL FORMAT ---------------------
      }
   }
   while ( (script1[0]!='}') && (++loopexit < MAXLOOPS) );
   pScp->Close();

   // Now that we have created the NPC, lets place him
   switch (postype)
   {
   case 1:					// take position from (spawning) item
	   if (triggerx)
	   {
		   pc_c->x=triggerx;
		   pc_c->y=triggery;
		   pc_c->dispz=pc_c->z=triggerz;
		   triggerx=c;
	   } else
	   {
	   /*Zippy's Code chages for area spawns --> (Type 69) xos and yos (X OffSet, Y OffSet) 
	   are used to find a random number that is then added to the spawner's x and y (Using 
	   the spawner's z) and then place the NPC anywhere in a square around the spawner. 
	   This square is random anywhere from -10 to +10 from the spawner's location (for x and 
	   y) If the place chosen is not a valid position (the NPC can't walk there) then a new 
	   place will be chosen, if a valid place cannot be found in a certain # of tries (50), 
		   the NPC will be placed directly on the spawner and the server op will be warned. */
		   
		   if ((items[i].type==69 || items[i].type==125)&& items[i].isInWorld())
		   {
			   if (items[i].more3==0) items[i].more3=10;
			   if (items[i].more4==0) items[i].more4=10;
			   //signed char z, ztemp, found;
	   
			   k=0;
			   do
			   {
				   if (k>=50) //this CAN be a bit laggy. adjust as nessicary
				   {
					   clConsole.send("WOLFPACK: Problem area spawner found at [%i,%i,%i]. NPC placed at default location.\n",items[i].x,items[i].y,items[i].z);
					   xos=0;
					   yos=0;
					   break;
				   }
				   xos=RandomNum(-items[i].more3,items[i].more3);
				   yos=RandomNum(-items[i].more4,items[i].more4);
				   // clConsole.send("Spawning at Offset %i,%i (%i,%i,%i) [-%i,%i <-> -%i,%i]. [Loop #: %i]\n",xos,yos,items[i].x+xos,items[i].y+yos,items[i].z,items[i].more3,items[i].more3,items[i].more4,items[i].more4,k); /** lord binary, changed %s to %i, crash when uncommented ! **/
				   k++;
				   
				   if ((items[i].x+xos<1) || (items[i].y+yos<1)) lb=0; /* lord binary, fixes crash when calling npcvalid with negative coordiantes */
				   else lb=validNPCMove(items[i].x+xos,items[i].y+yos,items[i].z,c);				 
				   
				   //Bug fix Monsters spawning on water:
				   MapStaticIterator msi(items[i].x + xos, items[i].y + yos);

				   staticrecord *stat;
				   loopexit=0;
				   while ( (stat = msi.Next()) && (++loopexit < MAXLOOPS) )
				   {
					   tile_st tile;
					   msi.GetTile(&tile);
					   if(!(strcmp((char *) tile.name, "water")))//Water
					   {//Don't spawn on water tiles... Just add other stuff here you don't want spawned on.
						   lb=0;
					   }
				   }
			   } while (!lb);
		   } // end Zippy's changes (exept for all the +xos and +yos around here....)

		   pc_c->x=items[i].x+xos;
		   pc_c->y=items[i].y+yos;
		   pc_c->dispz=pc_c->z=items[i].z;
		   setserial(c,i,6);
		} // end of if !triggerx
		break;
	case 2: // take position from Socket
		if (s!=-1)
		{
			pc_c->x=(buffer[s][11]<<8)+buffer[s][12];
			pc_c->y=(buffer[s][13]<<8)+buffer[s][14];
			pc_c->dispz=pc_c->z=buffer[s][16]+Map->TileHeight((buffer[s][17]<<8)+buffer[s][18]);
		}
		break;
	case 3: // take position from Parms
		pc_c->x=x1;
		pc_c->y=y1;
		pc_c->dispz=pc_c->z=z1;
		break;
	} // no default coz we tested on entry to function

	// now we have a position, let's set the borders
	switch (pc_c->npcWander)
	{
	case 2:		// circle
		pc_c->fx1=pc_c->x;
		pc_c->fy1=pc_c->y;
		pc_c->fz1=pc_c->z;
		pc_c->fx2=(fx2>=0) ? fx2 : 2;	// radius; if not given from script,default=2
		break;
	case 3:		// box
		if (fx1 || fx2 || fy1 || fy2)	// any offset for rectangle given from script ?
		{
			pc_c->fx1=pc_c->x+fx1;
			pc_c->fx2=pc_c->x+fx2;
			pc_c->fy1=pc_c->y+fy1;
			pc_c->fy2=pc_c->y+fy2;
			pc_c->fz1= -1;			// irrelevant for box
		}
		break;
	//default: do nothing
	}
   
	pc_c->region=calcRegionFromXY(pc_c->x, pc_c->y);
   
   //Now find real 'skill' based on 'baseskill' (stat modifiers)
   for(z=0;z<TRUESKILLS;z++)
   {
	   Skills->updateSkillLevel(c,z);
   }
   
   updatechar(c);

   // Dupois - Added April 4, 1999
   // After the NPC has been fully initialized, then post the message (if its a quest spawner) type==125
   if (postype==1) // lb crashfix
   {
      if ( items[i].type == 125 )
	  {
          MsgBoardQuestEscortCreate( c );
	  }
   }
   // End - Dupois

   //Char mapRegions
   mapRegions->RemoveItem(c+CharacterOffset);
   mapRegions->AddItem(c+CharacterOffset);
   return c;
}

void cCharStuff::Split(int k) // For NPCs That Split during combat
{
	int c,serial,z;
	
	c=Npcs->MemCharFree ();
	
	P_CHAR pc_c = MAKE_CHARREF_LR(c);
	pc_c->Init();
	P_CHAR pc_k = MAKE_CHARREF_LR(k);
	serial=pc_c->serial;
	memcpy(&chars[c],&chars[k],sizeof(cChar));
	pc_c->ser1=serial>>24;
	pc_c->ser2=serial>>16;
	pc_c->ser3=serial>>8;
	pc_c->ser4=serial%256;
	pc_c->serial=serial;
	pc_c->ftarg=-1;
	mapRegions->RemoveItem(c+CharacterOffset);
	pc_c->x=pc_k->x+1;
	pc_c->y=pc_k->y;
	mapRegions->AddItem(c+CharacterOffset);
	pc_c->kills=0;
	pc_c->hp=pc_k->st;
	pc_c->stm=pc_k->realDex();
	pc_c->mn=pc_k->in;
	z=rand()%35;
	if (z==5) pc_c->split=1; else pc_c->split=0;	
	updatechar(DEREF_P_CHAR(pc_c));
}

///////////////////////
// Name:	cChar::day
// history:	by punt, 15.4.2001
// Purpose:	return the day this was created
//
unsigned long cChar::day()
{
	return creationday ;
}
///////////////////////
// Name:	cChar::day(unsigned long)
// history:	by punt, 15.4.2001
// Purpose:	set the day this was created
//
void cChar::day(unsigned long CreateDay)
{
	creationday = CreateDay ;
}

///////////////////////
// Name:	GetItemOnLayer
// history:	by Duke, 26.3.2001
// Purpose:	returns the item on the given layer, if any
//
P_ITEM cChar::GetItemOnLayer(unsigned char layer)
{
	P_ITEM pi;
	int ci=0,loopexit=0;
	while ( ((pi=ContainerSearch(serial,&ci)) != NULL) && (++loopexit < MAXLOOPS) )
	{
		if (pi->layer==layer)
			return pi;
	}
	return NULL;
}

///////////////////////
// Name:	GetItemOnLayer
// history:	by Duke, 26.3.2001, touched by Correa, 21.04.2001
// Purpose:	Return the bank box. If banktype == 1, it will return the Item's bank box, else, 
//          gold bankbox is returned. 
//
P_ITEM cChar::GetBankBox( short banktype )			
{
	P_ITEM pi;
	int ci=0,loopexit=0;
	while ( ((pi=ContainerSearch(serial,&ci)) != NULL) && (++loopexit < MAXLOOPS) )
	{
		if (pi->type == 1 && pi->morex == 1)
			if ( banktype == 1 && pi->morez == 123 && SrvParms->usespecialbank) 
				return pi;
			else if ( banktype != 1 || !SrvParms->usespecialbank)
				return pi;
	}
	// If we reach this point, bankbox wasn't found == wasn't created yet.

	sprintf((char*)temp, "%s's bank box.", name);
	CHARACTER i = calcCharFromSer(serial);
	UOXSOCKET s = calcSocketFromChar(i);
	pi = Items->SpawnItem(i,1,(char*)temp,0,0x09AB,0,0);
	if(pi == NULL) 
		return NULL;
	ITEM c = calcItemFromSer(pi->serial);
	pi->layer=0x1d;
	setserial(c,i,3);
	setserial(c,i,4);
	pi->morex=1;
	if(SrvParms->usespecialbank && banktype == 1)//AntiChrist - Special Bank
		pi->morey=123;//gold only bank
	pi->type=1;
	if (s != -1)
		wearIt(s,pi);

	return pi;
}


///////////////////////
// Name:	disturbMed
// history:	by Duke, 17.3.2001
// Purpose:	stops meditation if necessary. Displays message if a socket is passed
//
void cChar::disturbMed(UOXSOCKET s)
{
	if (this->med) //Meditation
	{
		this->med=0;
		if (s != -1)
			sysmessage(s, "You break your concentration.");
	}
}

///////////////////////
// Name:	unhide
// history:	by Duke, 17.3.2001
// Purpose:	reveals the char if he was hidden
//
void cChar::unhide()
{
	if (this->isHidden() && !(this->priv2&8))	//if hidden but not permanently
	{
		this->stealth=-1;
		this->hidden=0;
		updatechar(DEREF_P_CHAR(this));	// LB, necassary for client 1.26.2
		if (this->isGM())
			tempeffect(DEREF_P_CHAR(this), DEREF_P_CHAR(this), 34, 3, 0, 0); 
	}
}

///////////////////////
// Name:	setNextMoveTime
// history:	by Duke, 20.3.2001
// Purpose:	sets the move timer. tamediv can shorten the time for tamed npcs
//
void cChar::setNextMoveTime(short tamediv)
{
	if (!tamediv) return;	// MUST be nonzero
	if(this->tamed)
		this->npcmovetime=(unsigned int)((uiCurrentTime+double(NPCSPEED*MY_CLOCKS_PER_SEC/tamediv)));
	else
		this->npcmovetime=(unsigned int)((uiCurrentTime+double(NPCSPEED*MY_CLOCKS_PER_SEC)));
}

///////////////////////
// Name:	fight
// history:	by Duke, 20.3.2001
// Purpose:	makes a character fight the other
//
void cChar::fight(P_CHAR other)
{
	CHARACTER opp=DEREF_P_CHAR(other);
	this->targ=opp;
	this->unhide();
	this->disturbMed();	// Meditation
	this->attacker=opp;
	if (this->npc)
	{
		if (!this->war)
			npcToggleCombat(DEREF_P_CHAR(this));
		this->setNextMoveTime();
	}
}

///////////////////////
// Name:	CountItems
// history:	by Duke, 26.3.2001
// Purpose:	searches the character recursively,
//			counting the items of the given ID and (if given) color
//
int cChar::CountItems(short ID, short col)
{
	P_ITEM pi=this->getBackpack();
		
	int number = 0 ;
	if (pi != NULL)
		number = pi->CountItems(ID, col);
	return number ;
}

int cChar::CountBankGold()
{
	P_ITEM pi = GetBankBox(1); //we want gold bankbox.
	if (!pi) return 0;
	return pi->CountItems(0x0EED);
}

///////////////////////
// Name:	CountItems
// history:	by Duke, 13.5.2001
// Purpose:	assigns the halo of the given item to a character
//
void cChar::addHalo(P_ITEM pi)
{
	setptr(&glowsp[this->serial%HASHMAX],DEREF_P_ITEM(pi));
}

void cChar::removeHalo(P_ITEM pi)
{
	removefromptr(&glowsp[this->serial%HASHMAX],DEREF_P_ITEM(pi));
}

void cChar::glowHalo(P_ITEM pi)
{
	if (pi->glow>0)
	{
		P_ITEM pHalo=FindItemBySerial(pi->glow);
		if (!pHalo) return;
		
		pHalo->layer=pi->layer; // copy layer information of the glowing item to the invisible light emitting object
		
		if(pHalo->layer==0 && pi->isInWorld()) // unequipped -> light source coords = item coords
		{
			pHalo->dir=29;
			pHalo->x=pi->x;
			pHalo->y=pi->y;
			pHalo->z=pi->z;
		} else if (pHalo->layer==0 && !pi->isInWorld()) // euqipped -> light source coords = players coords
		{
			pHalo->x=this->x;
			pHalo->y=this->y;
			pHalo->z=this->z+4;
			pHalo->dir=99; // gives no light in backpacks
		} else
		{
			pHalo->x=this->x;
			pHalo->y=this->y;
			pHalo->z=this->z+4;
			pHalo->dir=29;
		}
		RefreshItem(pHalo);//AntiChrist
	}
}

///////////////////////
// Name:	getWeapon
// history:	moved here from combat.cpp by Duke, 20.5.2001
// Purpose:	finds the equipped weapon of a character
//
P_ITEM cChar::getWeapon()
{
	int ci=0,loopexit=0;
	P_ITEM pi;
	while ( ((pi=ContainerSearch(serial,&ci)) != NULL) && (++loopexit < MAXLOOPS) )
	{
		if ((pi->layer==1 && pi->type!=9)		// not a spellbook (hozonko)
			|| (pi->layer==2 && !getShield()) ) //Morrolan don't check for shields
		{
			return pi;
		}
	}
	return NULL;
}

///////////////////////
// Name:	getShield
// history:	by Duke, 20.5.2001
// Purpose:	finds the equipped shield of a character
//
P_ITEM cChar::getShield()
{
	P_ITEM pi=GetItemOnLayer(2);
	if (pi && IsShield(pi->id()) )
		return pi;
	else
		return NULL;
}

P_ITEM Packitem(P_CHAR pc) // Find packitem
{
	if(pc==NULL) return NULL;
	int i=pc->packitem;
	if (i>-1)
	{
		const P_ITEM pi=MAKE_ITEMREF_LRV(i,NULL);	// on error return -1
		if (pc->Wears(pi) && pi->layer==0x15)
		{
			return pi;
		}
	}

	// - For some reason it's not defined, so go look for it.
	int ci=0,loopexit=0;
	P_ITEM pi;
	while ( ((pi=ContainerSearch(pc->serial,&ci)) != NULL) && (++loopexit < MAXLOOPS) )
	{
		if (pi->layer==0x15)
		{
			pc->packitem=DEREF_P_ITEM(pi);	//Record it for next time
			return (pi);
		}
	}
	return NULL;
}

P_ITEM cChar::getBackpack()	{return Packitem(this);}

///////////////////////
// Name:	setters for various serials
// history:	by Duke, 2.6.2001
// Purpose:	encapsulates revoval/adding to the pointer arrays
//
void cChar::setOwnSerialOnly(long ownser)
{
	ownserial=ownser;
}

void cChar::SetOwnSerial(long ownser)
{
	if (ownserial!=-1)	// if it was set, remove the old one
		removefromptr(&cownsp[ownserial%HASHMAX], DEREF_P_CHAR(this));
	
	setOwnSerialOnly(ownser);
	if (ownser != serial && ownser != -1)
		tamed = true;
	else
		tamed = false;

	if (ownser!=-1)		// if there is an owner, add it
		setptr(&cownsp[ownserial%HASHMAX], DEREF_P_CHAR(this));
}

void cChar::SetSpawnSerial(long spawnser)
{
	if (spawnserial!=-1)	// if it was set, remove the old one
		removefromptr(&cspawnsp[spawnserial%HASHMAX], DEREF_P_CHAR(this));

	spawnserial=spawnser;

	if (spawnser!=-1)		// if there is a spawner, add it
		setptr(&cspawnsp[spawnserial%HASHMAX], DEREF_P_CHAR(this));
}

void cChar::SetMultiSerial(long mulser)
{
	if (multis!=-1)	// if it was set, remove the old one
		removefromptr(&cmultisp[multis%HASHMAX], DEREF_P_CHAR(this));

	multis=mulser;

	if (mulser!=-1)		// if there is multi, add it
		setptr(&cmultisp[multis%HASHMAX], DEREF_P_CHAR(this));
}

void cChar::MoveToXY(short newx, short newy)
{
	this->MoveTo(newx,newy,z);	// keep the old z value
}

void cChar::MoveTo(short newx, short newy, signed char newz)
{
	// Avoid crash if go to 0,0
	if (newx < 1 || newy < 1)
		return;

	int c = DEREF_P_CHAR(this);
	mapRegions->RemoveItem(c+CharacterOffset);
	x = newx;
	y = newy;
	z = dispz=newz;
	mapRegions->AddItem(c+CharacterOffset);
}

int cChar::getSkillSum()
{
	int sum=0,a;
	for (a=0;a<ALLSKILLS;a++)
	{
		sum+=this->baseskill[a];
	}
	return sum;		// this *includes* the decimal digit ie. xxx.y
}

///////////////////////
// Name:	getTeachingDelta
// history:	by Duke, 27.7.2001
// Purpose:	calculates how much the given player can learn from this teacher
//
int cChar::getTeachingDelta(cChar* pPlayer, int skill, int sum)
{
	int delta = min(250,this->baseskill[skill]/2);		// half the trainers skill, but not more than 250
	delta -= pPlayer->baseskill[skill];					// calc difference
	if (delta <= 0)
		return 0;

	if (sum+delta >= SrvParms->skillcap * 10)			// would new skill value be above cap ?
		delta = (SrvParms->skillcap * 10) - sum;		// yes, so reduce it
	return delta;
}

////////////
// Name:	removeItemBonus
// history:	by Duke, 19.8.2001
// Purpose:	removes boni given by an item
//
void cChar::removeItemBonus(cItem* pi)
{
	this->st -= pi->st2;
	this->chgDex(-1 * pi->dx2);
	this->in -= pi->in2;
}
