
// -- Region class  Added by Tauriel 3/6/1999 To lookup items by region
//									This should help for now. BTW- my first attempt at C++
//									So forgive any newbie mistakes :)
//									-- Side note, I wanted regions to be more generic, but
//									now that I have to do this, time doesn't allow for it yet.


#include "wolfpack.h"
#include "debug.h"

#undef  DBGFILE
#define DBGFILE "regions.cpp"

cRegion::cRegion() //constructor
{
	int i=0;
	GridSize=32;
	ColSize=128;
	
	for (i=0;i<33000;i++)  // AntiChrist -- trying to use LordB values ( 33000 )
	{
		int memerrflg = 0;
		//if ((MapCells[i].pointer = (int *) malloc(1 * sizeof(int)))== NULL)
		//	memerrflg=1;
		MapCells[i].pointer=new int[25];
		if (MapCells[i].pointer==NULL) memerrflg=1;

		if (!memerrflg)
		{
			MapCells[i].max=25;
			//for (a=0;a<25;a++) MapCells[i].pointer[a]=-1; // this is way slow - fur
			memset(MapCells[i].pointer, 0xFF, 25 * sizeof(int));
		} else {
			clConsole.send("Error allocating mapRegion memory!\n");
			return;
		}
	}
}

cRegion::~cRegion() //destructor
{
  for (int i = 0; i < 33000; ++i)
    delete [] MapCells[i].pointer;
}

// - Adds the item to a cell
SI16 cRegion::AddItem(unsigned long nItem) //Char mapRegions		// was unsigned int
{
	//unsigned int uiCell = GetCell(items[nItem].x,items[nItem].y); //Zippy
	int z=0;
	unsigned int uiCell;
	if(nItem<CharacterOffset) 
	{
		if (nItem>=imem ) return -1;
		uiCell = GetCell(items[nItem].x,items[nItem].y);
	} else {
	   z=nItem-CharacterOffset;
	   if (z>=cmem || z<0) return -1;
	   uiCell = GetCell(chars[z].x,chars[z].y); //
	}

    //	clConsole.send("item# %i added to mapcell %i [%i,%i,%i]\n", nItem, uiCell, items[nItem].x, items[nItem].y, items[nItem].z);
	
    if (uiCell<=32999) 
	{
	  setptr(&MapCells[uiCell], nItem); //set item in pointer array
	  return 0;
	} else return -1;
}

// - Removes the item from a cell
SI16 cRegion::RemoveItem(unsigned long nItem)//Char mapRegions	// was unsigned int
{
	int z=0;
	unsigned int uiCell;
	if(nItem<CharacterOffset) 
	{ 
		if ((nItem>=imem) ) return -1;
		uiCell = GetCell(items[nItem].x,items[nItem].y);
	} else {
	   z=nItem-CharacterOffset;
	   if ((z>=cmem) || (z<0))  return -1;
	   uiCell = GetCell(chars[z].x,chars[z].y);		
	}

	if(uiCell<=32999)
	{
		// clConsole.send("item# %i removed from mapcell %i [%i,%i,%i]\n", nItem, uiCell, items[nItem].x, items[nItem].y, items[nItem].z);
		removefromptr(&MapCells[uiCell], nItem);
	} else return -1;
	
	return 0;
}

//- Returns the cell the character/item is in
unsigned int cRegion::GetCell(unsigned int x, unsigned int y)
{
	int cell = myGridx(x) + myGridy(y) + (myGridx(x) * (ColSize-1));
	return (unsigned int) ((cell<0) ? 0 : cell);  // - Return 0 if negative otherwise cell #
}

// - Get the next item pointer in a cell return -1 if done
long cRegion::GetNextItem(unsigned int cell, unsigned int Last)
{
	if (Last==-1) Last=0;
	else Last++;
	if (cell>32998 ) return -1;
	for (int i=Last;i<MapCells[cell].max;i++)
	{
		if (MapCells[cell].pointer[i] != -1) return i;
	}
	return -1; //didn't find another one
}

// - Get an item in a cell return -1 if done
long cRegion::GetItem(unsigned int cell, unsigned int item)
{
	if (cell>32999 ) return -1;
	/*clConsole.send("Map region %i dump.\n", cell);
	UI16 i;
	for (i=0;i<MapCells[cell].max;i++)
		clConsole.send("   %i: %i\n", i, MapCells[cell].pointer[i]);
	clConsole.send("Done.\n");*/
	if (item>MapCells[cell].max ) return -1;
	return MapCells[cell].pointer[item];
}

// - Get starting grid for lookup 96x96 box
// - (we check the 8 surrounding cells and the cell char/item is in)
unsigned int cRegion::StartGrid(unsigned int x, unsigned int y)
{
	int gridx=myGridx(x)-1, gridy=myGridy(y)-1;
	if (gridx<0) gridx=0;
	if (gridy<0) gridy=0;
	return (unsigned int) (gridx + gridy + (gridx * (ColSize-1)));
}


RegionIterator::RegionIterator(int myX, int myY, RegionIteratorDomain dm) :
	x(myX), y(myY), mapitemptr(-1), mapitem(-1), domain(dm)
{
	getcell = mapRegions->GetCell(x,y);
}

int RegionIterator::First()
{
	mapitemptr = mapitem = -1;
	return Next();
}

int RegionIterator::Next()
{
	mapitemptr = mapRegions->GetNextItem(getcell, mapitemptr);
	if (mapitemptr==-1) 
		return -1;

	mapitem = mapRegions->GetItem(getcell, mapitemptr);
	if (domain == ItemsOnly && !IsItem())
		return Next();
	if (domain == CharsOnly && !IsChar())
		return Next();
	return mapitem;
}

bool RegionIterator::End()
{
	return (mapitem == -1);// || mapitemptr == -1 );
}

bool RegionIterator::IsItem() const
{
	return mapitem >= 0 && mapitem < CharacterOffset;
}

bool RegionIterator::IsChar() const
{
	return mapitem >= CharacterOffset;
}

bool RegionIterator::IsMulti() const
{
	return items[mapitem].id1 >= 0x40;
}

////////////////////
// name:	RegCellIterator4Items
// history:	by Duke, 28.10.2000
// Purpose:	iterates through one cell of the region grid,
//			returning only items (as a pointer, not an index)
//
P_ITEM RegCellIterator4Items::First()
{
	mapitemptr = mapitem = -1;
	return Next();
}

P_ITEM RegCellIterator4Items::Next()
{
	mapitemptr = mapRegions->GetNextItem(getcell, mapitemptr);
	if (mapitemptr==-1) 
		return NULL;

	mapitem = mapRegions->GetItem(getcell, mapitemptr);
	if (domain == ItemsOnly && !IsItem())
		return Next();
	return MAKE_ITEMREF_LRV(mapitem,NULL);
}

////////////////////
// name:	RegGrid3x3Iterator4Items
// history:	by Duke, 28.10.2000
// Purpose:	iterates through one cell plus the eight surroundung cells of the region grid,
//			returning only items (as a pointer, not an index)
// Remark:	I know there is a problem with the edges & borders of the grid,
//			but as in the normal UO map there's only water there ....
//
RegGrid3x3Iterator4Items::RegGrid3x3Iterator4Items(int myX, int myY) : RegionIterator(myX,myY,ItemsOnly)
{
	GridColSize=128;
	orgCell=getcell;	// remember it
	if (orgCell >= GridColSize)
		getcell-=GridColSize;
	if (getcell >= 1) 
		getcell-=1;
}

P_ITEM RegGrid3x3Iterator4Items::NextCell()
{
	getcell++;	//adjacent cell
	if (getcell%GridColSize > orgCell%GridColSize+1)
		getcell+=GridColSize-3;	//next col
	if (getcell > orgCell+GridColSize+1)
		return NULL;	// upper right corner of the box reached
	return Next();
}

P_ITEM RegGrid3x3Iterator4Items::Next()
{
	mapitemptr = mapRegions->GetNextItem(getcell, mapitemptr);
	if (mapitemptr==-1) 
		return NextCell();

	mapitem = mapRegions->GetItem(getcell, mapitemptr);
	if (domain == ItemsOnly && !IsItem())
		return Next();
	return MAKE_ITEMREF_LRV(mapitem,NULL);
}

////////////////////
// name:	RegGrid3x3Iterator4Chars
// history:	by Duke, 18.11.2000
// Purpose:	iterates through one cell plus the eight surroundung cells of the region grid,
//			returning only items (as a pointer, not an index)
// Remark:	I know there is a problem with the edges & borders of the grid,
//			but as in the normal UO map there's only water there ....
//
RegGrid3x3Iterator4Chars::RegGrid3x3Iterator4Chars(int myX, int myY) : RegionIterator(myX,myY,CharsOnly)
{
	GridColSize=128;
	orgCell=getcell;	// remember it
	if (orgCell >= GridColSize)
		getcell-=GridColSize;
	if (getcell >= 1) 
		getcell-=1;
}

P_CHAR RegGrid3x3Iterator4Chars::NextCell()
{
	getcell++;	//adjacent cell
	if (getcell%GridColSize > orgCell%GridColSize+1)
		getcell+=GridColSize-3;	//next col
	if (getcell > orgCell+GridColSize+1)
		return NULL;	// upper right corner of the box reached
	return Next();
}

P_CHAR RegGrid3x3Iterator4Chars::Next()
{
	mapitemptr = mapRegions->GetNextItem(getcell, mapitemptr);
	if (mapitemptr==-1) 
		return NextCell();

	mapitem = mapRegions->GetItem(getcell, mapitemptr);
	if (domain == CharsOnly && !IsChar())
		return Next();
	return MAKE_CHARREF_LRV(mapitem-CharacterOffset,NULL);
}


/*
 * 
 *		Correa's new Region stuff... this will replace the current cRegion Implementation!
 *
 *
 */

cNewRegion::cNewRegion() //constructor
{
	GridSize=32;
	ColSize=128;
}

cNewRegion::~cNewRegion() //destructor
{
}

// - Adds the item to a cell
SI16 cNewRegion::Add(P_ITEM pi) 
{
	unsigned int uiCell;
	if (pi == NULL) 
		return -1;
	uiCell = GetCell(pi->x, pi->y);

    if (uiCell<=32999) 
	{
		MapCells.setData(uiCell, pi->serial); //set item in pointer array
		return 0;
	} else return -1;
}

SI16 cNewRegion::Add(P_CHAR pc) 
{
	unsigned int uiCell;
	if (pc == NULL) 
		return -1;
	uiCell = GetCell(pc->x, pc->y);

    if (uiCell<=32999) 
	{
		MapCells.setData(uiCell, pc->serial); //set item in pointer array
		return 0;
	} else return -1;
}

// - Removes the item from a cell
SI16 cNewRegion::Remove(P_ITEM pi)
{
	unsigned int uiCell;
	if (pi == NULL)
		return -1;
	uiCell = GetCell(pi->x, pi->y);

	if(uiCell<=32999)
	{
		// clConsole.send("item# %i removed from mapcell %i [%i,%i,%i]\n", nItem, uiCell, items[nItem].x, items[nItem].y, items[nItem].z);
		MapCells.remove(uiCell, pi->serial);
	} else return -1;

	return 0;
}

// - Removes the item from a cell
SI16 cNewRegion::Remove(P_CHAR pc)
{
	unsigned int uiCell;
	if (pc == NULL)
		return -1;
	uiCell = GetCell(pc->x, pc->y);

	if(uiCell<=32999)
	{
		// clConsole.send("item# %i removed from mapcell %i [%i,%i,%i]\n", nItem, uiCell, items[nItem].x, items[nItem].y, items[nItem].z);
		MapCells.remove(uiCell, pc->serial);
	} else return -1;

	return 0;
}


//- Returns the cell the character/item is in
unsigned int cNewRegion::GetCell(unsigned int x, unsigned int y)
{
	int cell = myGridx(x) + myGridy(y) + (myGridx(x) * (ColSize-1));
	return (unsigned int) ((cell<0) ? 0 : cell);  // - Return 0 if negative otherwise cell #
}

vector<int> cNewRegion::GetCellEntries(unsigned int cell)
{
	return MapCells.getData(cell);
}

// - Get starting grid for lookup 96x96 box
// - (we check the 8 surrounding cells and the cell char/item is in)
unsigned int cNewRegion::StartGrid(unsigned int x, unsigned int y)
{
	int gridx=myGridx(x)-1, gridy=myGridy(y)-1;
	if (gridx<0) gridx=0;
	if (gridy<0) gridy=0;
	return (unsigned int) (gridx + gridy + (gridx * (ColSize-1)));
}

/*
RegionIterator::RegionIterator(int myX, int myY, RegionIteratorDomain dm) :
	x(myX), y(myY), mapitemptr(-1), mapitem(-1), domain(dm)
{
	getcell = mapRegions->GetCell(x,y);
}

int RegionIterator::First()
{
	mapitemptr = mapitem = -1;
	return Next();
}

int RegionIterator::Next()
{
	mapitemptr = mapRegions->GetNextItem(getcell, mapitemptr);
	if (mapitemptr==-1) 
		return -1;

	mapitem = mapRegions->GetItem(getcell, mapitemptr);
	if (domain == ItemsOnly && !IsItem())
		return Next();
	if (domain == CharsOnly && !IsChar())
		return Next();
	return mapitem;
}

bool RegionIterator::End()
{
	return (mapitem == -1);// || mapitemptr == -1 );
}

bool RegionIterator::IsItem() const
{
	return mapitem >= 0 && mapitem < CharacterOffset;
}

bool RegionIterator::IsChar() const
{
	return mapitem >= CharacterOffset;
}

bool RegionIterator::IsMulti() const
{
	return items[mapitem].id1 >= 0x40;
}

////////////////////
// name:	RegCellIterator4Items
// history:	by Duke, 28.10.2000
// Purpose:	iterates through one cell of the region grid,
//			returning only items (as a pointer, not an index)
//
P_ITEM RegCellIterator4Items::First()
{
	mapitemptr = mapitem = -1;
	return Next();
}

P_ITEM RegCellIterator4Items::Next()
{
	mapitemptr = mapRegions->GetNextItem(getcell, mapitemptr);
	if (mapitemptr==-1) 
		return NULL;

	mapitem = mapRegions->GetItem(getcell, mapitemptr);
	if (domain == ItemsOnly && !IsItem())
		return Next();
	return MAKE_ITEMREF_LRV(mapitem,NULL);
}

////////////////////
// name:	RegGrid3x3Iterator4Items
// history:	by Duke, 28.10.2000
// Purpose:	iterates through one cell plus the eight surroundung cells of the region grid,
//			returning only items (as a pointer, not an index)
// Remark:	I know there is a problem with the edges & borders of the grid,
//			but as in the normal UO map there's only water there ....
//
RegGrid3x3Iterator4Items::RegGrid3x3Iterator4Items(int myX, int myY) : RegionIterator(myX,myY,ItemsOnly)
{
	GridColSize=128;
	orgCell=getcell;	// remember it
	if (orgCell >= GridColSize)
		getcell-=GridColSize;
	if (getcell >= 1) 
		getcell-=1;
}

P_ITEM RegGrid3x3Iterator4Items::NextCell()
{
	getcell++;	//adjacent cell
	if (getcell%GridColSize > orgCell%GridColSize+1)
		getcell+=GridColSize-3;	//next col
	if (getcell > orgCell+GridColSize+1)
		return NULL;	// upper right corner of the box reached
	return Next();
}

P_ITEM RegGrid3x3Iterator4Items::Next()
{
	mapitemptr = mapRegions->GetNextItem(getcell, mapitemptr);
	if (mapitemptr==-1) 
		return NextCell();

	mapitem = mapRegions->GetItem(getcell, mapitemptr);
	if (domain == ItemsOnly && !IsItem())
		return Next();
	return MAKE_ITEMREF_LRV(mapitem,NULL);
}

////////////////////
// name:	RegGrid3x3Iterator4Chars
// history:	by Duke, 18.11.2000
// Purpose:	iterates through one cell plus the eight surroundung cells of the region grid,
//			returning only items (as a pointer, not an index)
// Remark:	I know there is a problem with the edges & borders of the grid,
//			but as in the normal UO map there's only water there ....
//
RegGrid3x3Iterator4Chars::RegGrid3x3Iterator4Chars(int myX, int myY) : RegionIterator(myX,myY,CharsOnly)
{
	GridColSize=128;
	orgCell=getcell;	// remember it
	if (orgCell >= GridColSize)
		getcell-=GridColSize;
	if (getcell >= 1) 
		getcell-=1;
}

P_CHAR RegGrid3x3Iterator4Chars::NextCell()
{
	getcell++;	//adjacent cell
	if (getcell%GridColSize > orgCell%GridColSize+1)
		getcell+=GridColSize-3;	//next col
	if (getcell > orgCell+GridColSize+1)
		return NULL;	// upper right corner of the box reached
	return Next();
}

P_CHAR RegGrid3x3Iterator4Chars::Next()
{
	mapitemptr = mapRegions->GetNextItem(getcell, mapitemptr);
	if (mapitemptr==-1) 
		return NextCell();

	mapitem = mapRegions->GetItem(getcell, mapitemptr);
	if (domain == CharsOnly && !IsChar())
		return Next();
	return MAKE_CHARREF_LRV(mapitem-CharacterOffset,NULL);
}
*/
