#ifndef __SCRIPTC_H__
#define __SCRIPTC_H__

#include "stl_headers_start.h"
#include <map>
#include <string>
#include "stl_headers_end.h"

using namespace std ;
typedef unsigned long scpMark;

// One entry in the cache
struct ScriptEntry {
	std::string name;
    unsigned long offset;
};


bool openscript (char *name, bool shutdownonfail = true);
void closescript ();
void read1 ();
void read2 ();
extern char script1[512];

#define SCP_PRELOADABLE	0x0008
#define SCP_PRELOADED	0x0004

#ifndef _MSC_VER
typedef long int _off_t ;
#endif


class Script
{
public:
    Script(const char *_filename, short _flags=0);
	~Script();
	bool Open();
	void Close() {if (!(flags & SCP_PRELOADED)) closescript();}
	Script* Select(char* sect, short custom);
	scpMark Suspend();
	void Resume(scpMark mark);
	bool NextLine();
	void NextLineSplitted();
	int  CmpTok1(char* comp) {return strcmp((char*)script1,comp);}

    char find(const char *section);
    char isin(const char *section);
        
    
private:
	bool preload();
    void reload();
	bool ReadMemLine();
	void MakeIndexForFile();
	void MakeIndexForMem();
    
	std::map<std::string, ScriptEntry> entries;
    time_t last_modification;
    char *filename;
	char *img;
	_off_t scpsize;
	char *curmempos;	// current read position for preloaded files
	short flags;
};

#endif
