#include "speech.h"

#undef  DBGFILE
#define DBGFILE "speech.cpp"

// right place ?

// return values:
// 0 -> no stable substring
// 1 -> no stablemaster
// 2 -> no pet
// 3 -> successful stabling
int stabling(CHARACTER petowner, char* command)
{

	char search1[50], search3[50];
	char *response1;
	char *response3;
	const P_CHAR pc_petowner = MAKE_CHARREF_LRV(petowner, -1);
	bool found=false;
	int stablemaster_serial=-1,s,stablemaster,pet,id1,id2;
	PC_CHAR pc_stablemaster;
	P_CHAR p_pet;

	///////////////////////////////////////////////////////////////////////////////////////
	///// First lets check if the keyword stable is in the commandstring, if not return !
	////////////////////////////////////////////////////////////////////////////////////////

	strcpy(search1,"STABLE");
    response1=(strstr( command, search1));
    if (response1 && online(petowner) && (!(pc_petowner->dead))) { ; } else { return 0; }

	/////////////////////////////////////////////////////////
	///// Now lets check for stable masters @ players mapregion, 
	///// if non around, return
    /////////////////////////////////////////////////////////

	int x=pc_petowner->x;
	int y=pc_petowner->y;	
	int k;
	int getcell=mapRegions->GetCell(x,y);
	int mapitem=-1;
	int mapitemptr=-1;
	int mapchar=-1;

	int loopexit=0;
	do
	{
		mapitemptr=mapRegions->GetNextItem(getcell, mapitemptr);
		if (mapitemptr==-1) break;
		mapitem=mapRegions->GetItem(getcell, mapitemptr);
		if (mapitem>999999) mapchar=mapitem-CharacterOffset;
		if (mapitem!=-1 && mapitem>=CharacterOffset)
		{
			k=mapchar;
			if (chardist(k,petowner)<=5)
			{
               pc_stablemaster = MAKE_CHARREF_LOGGED(k, err);
			   if (err) break;
			   if (pc_stablemaster->npc && !pc_stablemaster->free && pc_stablemaster->npc_type==1 )
			   {
			      //clConsole.send("found stablemaster: %s\n",pc_stablemaster->name);
				  found=true;
				  stablemaster_serial=pc_stablemaster->serial;
				  stablemaster=k;
				  break;
				  
			   }
			}
		}
	} while ( (mapitem!=-1) && (++loopexit < MAXLOOPS) );

    s=calcSocketFromChar(petowner);
	if (s!=-1 && !found) 
	{ 
		sysmessage(s,"no stablemaster around");
		return 1;
	} else if (s==-1) return 1;
      
	/////////////////////////////////////////////////////////////////////
	//// so far we have found a stablemaster! lets see if the caller has a pet
	//// if so check if the pets name is in the commandstring
	//// if not return
    ///////////////////////////////////////////////////////////////////
	
	getcell=mapRegions->GetCell(x,y);
	mapitem=-1;
	mapitemptr=-1;
	mapchar=-1;
	found=false;

	loopexit=0;
	do 
	{
		mapitemptr=mapRegions->GetNextItem(getcell, mapitemptr);
		if (mapitemptr==-1) break;
		mapitem=mapRegions->GetItem(getcell, mapitemptr);
		if (mapitem>999999) mapchar=mapitem-CharacterOffset;
		if (mapitem!=-1 && mapitem>=CharacterOffset)
		{
			k=mapchar;
			if (chardist(k,petowner)<=8)
			{
               p_pet = MAKE_CHARREF_LOGGED(k, err);
			   if (err) break;
			   if (pc_petowner->Owns(p_pet) && p_pet->stablemaster_serial==0) //owner of the pet ? and not already stabled ?
			   {
		           strcpy(search3,p_pet->name);
		           strupr(search3);
		           response3=(strstr( command, search3));
		           if (response3) //if petname is in
				   {
			           found=true;
					   pet=k;
					   //clConsole.send("found pet: %s\n",p_pet->name);
					   break;
				   }
			   }
	
			 
			}

		}
	}  while ((mapitem!=-1) && (++loopexit < MAXLOOPS) );

	if (!found) 
	{ 
		npctalk(s,stablemaster,"which pet?",0);
		return 2;
	} 

	/////////////////////////////////////////////////////////////
	/// now we have a pet and stablemaster -> time to STABLE :-)
    ////////////////////////////////////////////////////////////
	
    // set stablesp && pets stablemaster serial
	
	// remove it from screen!
	int xx=p_pet->x;
	int yy=p_pet->y;
	id1=p_pet->id1; 
	id2=p_pet->id2;
	p_pet->id1=0; 
	p_pet->id2=0;
	p_pet->x=0;
	p_pet->y=0;

	for (int ch=0; ch<now; ch++)
	{	
	  if (perm[ch]) impowncreate(ch, pet, 0); 
	}

	p_pet->id1=id1;
	p_pet->id2=id2;
	p_pet->war=0;
	//p_pet->ftarg=-1;
	//p_pet->targ=-1;
	p_pet->attacker=-1;
	pc_petowner->war=0;
	pc_petowner->targ=-1;
	p_pet->x=xx;
	p_pet->y=yy;

	mapRegions->RemoveItem(pet+CharacterOffset);

	p_pet->stablemaster_serial=stablemaster_serial; // set stablemaster serial

	// set timer for fee calculation

    p_pet->time_unused=0;
	p_pet->timeused_last = getNormalizedTime();

    setptr(&stablesp[stablemaster_serial%HASHMAX], pet);

	sprintf((char*)temp,"Your pet is now stabled, say claim %s to claim your pet",p_pet->name);
	npctalk(s,stablemaster,(char*)temp,0);

	return 3;
}


int un_stabling(CHARACTER petowner, char* command)
{
	
	float f_fee;
	char search1[50], search3[50];
	char *response1;
	char *response3;
	const P_CHAR p_petowner = MAKE_CHARREF_LRV(petowner, -1);
	bool found=false,paid=false;
	int stablemaster_serial=-1,s,stablemaster,pet,i,ci,serhash,fee,pack,ptr,cont_item,gold,gold2;
	PC_CHAR pc_stablemaster;
	P_CHAR  p_pet;
	P_ITEM  p_contItem;
	PC_ITEM pc_pack;

	///////////////////////////////////////////////////////////////////////////////////////
	///// First lets check if the keyword claim is in the commandstring, if not return !
	////////////////////////////////////////////////////////////////////////////////////////

	strcpy(search1,"CLAIM");
    response1=(strstr( command, search1));
    if (response1 && online(petowner) && (!(p_petowner->dead))) { ; } else { return 0; }

	/////////////////////////////////////////////////////////
	///// Now lets check for stable masters @ players mapregion, 
	///// if non around, return
    /////////////////////////////////////////////////////////

	int x=p_petowner->x;
	int y=p_petowner->y;	
	int k;
	int getcell=mapRegions->GetCell(x,y);
	int mapitem=-1;
	int mapitemptr=-1;
	int mapchar=-1;

	int loopexit=0;
	do
	{
		mapitemptr=mapRegions->GetNextItem(getcell, mapitemptr);
		if (mapitemptr==-1) break;
		mapitem=mapRegions->GetItem(getcell, mapitemptr);
		if (mapitem>999999) mapchar=mapitem-CharacterOffset;
		if (mapitem!=-1 && mapitem>=CharacterOffset)
		{
			k=mapchar;
			if (chardist(k,petowner)<=5)
			{
               pc_stablemaster = MAKE_CHARREF_LOGGED(k, err);
			   if (err) break;
			   if (pc_stablemaster->npc && !pc_stablemaster->free && pc_stablemaster->npc_type==1 )
			   {
			      //clConsole.send("found stablemaster: %s\n",pc_stablemaster->name);
				  found=true;
				  stablemaster_serial=pc_stablemaster->serial;
				  stablemaster=k;
				  break;
				  
			   }
			}
		}
	} while ((mapitem!=-1) && (++loopexit < MAXLOOPS) );

    s=calcSocketFromChar(petowner);
	if (s!=-1 && !found) 
	{ 
		sysmessage(s,"no stablemaster around");
		return 1;
	} else if (s==-1) return 1;
      
	/////////////////////////////////////////////////////////////////////
	//// so far we have found a stablemaster! lets see if the stablemaster has a pet
	//// stabled the petowner owns
	//// if not return
    ///////////////////////////////////////////////////////////////////
	
	found=false;
    serhash=stablemaster_serial%HASHMAX;

    for (ci=0;ci<stablesp[serhash].max;ci++)
	{
		i=stablesp[serhash].pointer[ci];
		if (i!=-1)
		{
			 p_pet = MAKE_CHARREF_LOGGED(i, err);
			 if (err) break;			

			 if (p_petowner->Owns(p_pet) && p_pet->stablemaster_serial!=0) // already stabled and owned by claimer ?
			   {
		           strcpy(search3,p_pet->name);
		           strupr(search3);
		           response3=(strstr( command, search3));			
		           if (response3) //if petname is in
				   {
			           found=true;
					   pet=i;
					   //clConsole.send("found pet: %s\n",p_pet->name);
					   break;
				   }
			   }
	

		}
	}


	if (!found) 
	{ 
		npctalk(s,stablemaster,"sorry, I can't return that pet",0);
		return 2;
	} 

	/////////////////////////////////////////////////////////////
	/// now we have the claimed pet and stablemaster -> time to UNSTABLE :-)
    ////////////////////////////////////////////////////////////

	/// calc fee
	f_fee = ( (p_pet->time_unused) / 600.0f) * SrvParms->stablingfee ; // (fee per 10 minutes) * number of 10 minute blocks
	fee = ( (int) f_fee) + 5; // 5 basefee

	//clConsole.send("fee: %i\n",fee);

	sprintf((char*)temp,"That's %i gold pieces",fee);
	npctalk(s,stablemaster,(char*)temp,0);

	/////////// check if costumer can pay ! ///////////////    
	gold=0;
	pack = packitem(DEREF_P_CHAR(p_petowner));
	paid=false;
	if (pack<0)
	{
		paid=false;
	} else
	{
	   pc_pack = MAKE_ITEMREF_LOGGED(pack, err)
	   if (err) 
		   paid = false ;
	   else
		   gold = p_petowner->CountGold();
	}

	gold2=0;
	if (gold<fee) // not enogh gold in bp, dont try to subtract gold !
	{
		paid=false;
	}
	else
	{
		 serhash = pc_pack->serial%HASHMAX; 
	     for(ptr=0;ptr<contsp[serhash].max;ptr++)
		   {
		      cont_item=contsp[serhash].pointer[ptr];
		      if (cont_item!=-1)
			  { 			
	             p_contItem = MAKE_ITEMREF_LOGGED(cont_item, err);
			     if (err) break;					
		         if (p_contItem->contserial==pc_pack->serial && p_contItem->id()==0x0EED) 
				 {										
					 if (p_contItem->amount > fee) 
					 {
						 p_contItem->amount-=fee;
						 RefreshItem(cont_item);
						 paid=true;
						 break;
					 } else
					 {
						 gold2+=p_contItem->amount;
						 Items->DeleItem(cont_item);
						 RefreshItem(cont_item);					

					 }

					 if (gold2 >= fee) { paid=true; break; }
			          					 				 					 
				 }
			  }
		   }
	}
		
    //// if paid -> return pet
	if (paid)
	{

	  // remove from hash table
	  removefromptr(&stablesp[stablemaster_serial%HASHMAX], pet);

	  p_pet->stablemaster_serial=0; // actual unstabling

	  p_pet->timeused_last=getNormalizedTime();
	  p_pet->time_unused=0;

	  mapRegions->RemoveItem(pet + CharacterOffset);	
	  mapRegions->AddItem( pet +CharacterOffset);

	  for (int ch=0; ch<now; ch++)
	  {	
	     if (perm[ch]) impowncreate(ch, pet, 0); 
	  }

	  npctalk(s,stablemaster,"Thx! Here's your pet",0);

	} else 
	{
		sprintf((char*)temp,"you can't affort that %i",fee);
		npctalk(s,stablemaster,(char*)temp,0);
		return 3;
	}

   return 4;
}


// about 90% of the charcount loops can and should be replaced by mapregions for speedup !
// there are too many of them here !
// please get rid of them asap, but I didnt have time cause too busy getting 11.8 out!
// perhaps a complete rewrite ....
// LB 10'th october 2000
int response(UOXSOCKET s)
{
	static char buffer1[MAXBUFFER_REAL]; // static because close to stack size limit on win machines
	int i,j;
	int k, skill=-1;
	char *comm;
	
	char *response1;
	char *response2;
	char *response3;
	
	char search1[50];
	char search2[50];
	char search3[50];
	
//	unsigned char nonuni[512];
	static unsigned char nonuni[MAXBUFFER_REAL];
	char temp[512];
	char temp2[512];
	int x=-1;
	int y=0;

	P_CHAR pc_currchar = MAKE_CHARREF_LRV(currchar[s],1);
	
	if(pc_currchar->unicode)
		for (i=13;i<(buffer[s][1]<<8)+buffer[s][2];i=i+2)
		{
			nonuni[(i-13)/2]=buffer[s][i];
		} 
		
	if(!(pc_currchar->unicode))
	{
		for (i=7; i < MAXBUFFER_REAL; i++)
		{
			tbuffer[i]=buffer1[i];
			buffer1[i]=toupper(buffer[s][i]);
		}
	}
	else
	{
		for (i=0; i < MAXBUFFER_REAL-8; i++)
		{
			tbuffer[i+8]=buffer1[i+8];
			buffer1[i+8]=toupper(nonuni[i]);
		}
	}
		
	comm=&buffer1[8];

    if ( stabling(currchar[s], comm) ) return 1; // LB's stabling stuff
	if ( un_stabling(currchar[s], comm) ) return 1;
	   
	strcpy(search1,"CHAOS SHIELD"); //Ripper...if in chaos guild get a new shield.
	response1=(strstr( comm, search1));
	if (response1 && online(currchar[s]) && (!(pc_currchar->dead)))
		// if they say chaos shield and if online and not dead.
	{
		for(unsigned int i = 0; i < charcount; i++)// lets search for a chaos guard.
		{
			if(chars[i].npc && chars[i].npcaitype == 6)
				// npc and chaos guard
			{
				if(chardist(i, currchar[s])<=3)
					// lets be close to talk :)
				{
					if(pc_currchar->guildnumber==0)
						// if not in a guild.
					{
						npctalk(s,i,"You must be in a chaos guild to get a shield!",1);
						return 0;
					}
					else if(Guilds->GetType(pc_currchar->guildnumber)==1)
						// if they are in a order guild.
					{
						npctalk(s,i,"Sorry but you are in a order guild!",1);
						return 0;
					}
					else if(Guilds->GetType(pc_currchar->guildnumber)==2)
						// if they are in a chaos guild.
					{
						if(getamount(currchar[s],0x1BC3)>0)
							// if they have a chaos shield in their pack lets stop here.
						{
							npctalk(s,i,"you already have a shield!",1);
							return 0;
						}
						else
						{
							cwmWorldState->RemoveItemsFromCharBody(currchar[s],0x1B, 0xC3);
							// if they are wearing a chaos shield lets just delete it.
							Items->SpawnItemBackpack2( s,28,1 );
							// lets give them a new chaos shield.
							npctalk(s,i,"Hi fellow guild member,here is your new shield.",1);
							return 1;
						}
					}
				}
			}
		}
	}
	strcpy(search1,"ORDER SHIELD"); //Ripper...if in order guild get a new shield.
	response1=(strstr( comm, search1));
	if (response1 && online(currchar[s]) && (!(pc_currchar->dead)))
		// if they say order shield and if online and not dead.
	{
		for(unsigned int i = 0; i < charcount; i++)
			// lets search for a order guard.
		{
			if(chars[i].npc && chars[i].npcaitype == 7)
				// npc and order guard
			{
				if(chardist(i, currchar[s])<=3)
					// lets be close to talk :)
				{
					if(pc_currchar->guildnumber==0)
						// if not in a guild.
					{
						npctalk(s,i,"You must be in a order guild to get a shield!",1);
						return 0;
					}
					else if(Guilds->GetType(pc_currchar->guildnumber)==2)
						// if they are in a chaos guild.
					{
						npctalk(s,i,"Sorry but you are in a chaos guild!",1);
						return 0;
					}
					else if(Guilds->GetType(pc_currchar->guildnumber)==1)
						// if they are in a order guild.
					{
						if(getamount(currchar[s],0x1BC4)>0)
							// if they have a order shield in thier pack lets stop here.
						{
							 npctalk(s,i,"you already have a shield!",1);
							 return 0;
						}
						else
						{
							cwmWorldState->RemoveItemsFromCharBody(currchar[s],0x1B, 0xC4);
							// if they are wearing a order shield lets just delete it.
							Items->SpawnItemBackpack2( s,29,1 );
							// lets give them a new order shield.
							npctalk(s,i,"Hi fellow guild member,here is your new shield.",1);
							return 1;
						}
					}
				}
			}
		}
	}

    response1=(strstr( comm, "#EMPTY"));
    if (response1 && online(currchar[s]) && !pc_currchar->dead && pc_currchar->isGM())
	{ // restricted to GMs for now. It's too powerful (Duke, 5.6.2001)
		target(s, 0, 1, 0, 71, "Select container to empty:");
		return 1;
	}

	// redundant chacunt loop !

	strcpy(search1,"NAME"); //Ripper...say name and a npc will tell you there name :).
    response1=(strstr( comm, search1));
    if (response1 && online(currchar[s]) && (!(pc_currchar->dead)))
	{
		for( unsigned int i = 0; i < charcount; i++)
		{
			if(chars[i].npc==1 && chars[i].npcaitype!=2 && chars[i].id1==0x01 && (chars[i].id2==0x90 || chars[i].id2==0x91))
			{
				if(chardist(i, currchar[s])<=3)
				{ 
					sprintf(temp, "hello my name is %s.", chars[i].name);
					npctalkall(i,temp,0);
					return 1;
				}
			}
		}
	}

	// redundant charcount loop !

	strcpy(search1,"TIME"); //Ripper...say time and the npc gives the time.
    response1=(strstr( comm, search1));
    if (response1 && online(currchar[s]) && (!(pc_currchar->dead)))
	{
		for( unsigned int i = 0; i < charcount; i++)
		{
			if(chars[i].npc==1 && chars[i].npcaitype!=2 && chars[i].npcaitype!=17 && chars[i].id1==0x01 && (chars[i].id2==0x90 || chars[i].id2==0x91))
			{
				if(chardist(i, currchar[s])<=3)
				{ 
					if (ampm || (!ampm && hour==12))
						sprintf(temp, "%s %2.2d : %2.2d %s", "it is now", hour, minute, "in the evening.");
					else
						sprintf(temp, "%s %2.2d : %2.2d %s", "it is now", hour, minute, "in the morning.");
					npctalkall(i,temp,0);
					return 1;
				}
			}
		}
	}

	// redundant charcount loop !

	strcpy(search1,"LOCATION"); //Ripper...gives location of char.
	strcpy(search2,"WHERE AM I");
    response1=(strstr( comm, search1));
	response2=(strstr( comm, search2));
    if ((response1 || response2) && online(currchar[s]) && (!(pc_currchar->dead)))
	{
		for( unsigned int j = 0; j < charcount; j++)
		{
			if(chars[j].npc==1 && chars[j].npcaitype!=2 && chars[j].npcaitype!=17 && chars[j].id1==0x01 && (chars[j].id2==0x90 || chars[j].id2==0x91))
			{
				if(chardist(j, currchar[s])<=3)
				{				
					if (strlen(region[pc_currchar->region].name)>0)
						sprintf(temp, "You are in %s",region[pc_currchar->region].name); 
					else strcpy(temp,"You are in the wilderness");
					npctalkall(j,temp,0);
					
					sprintf(temp, "%i %i (%i)",pc_currchar->x,pc_currchar->y,pc_currchar->z); 
					npctalkall(j,temp,0);
					return 1;
				}
			}
		}
	}

	// redundant charcount loop !

    strcpy(search1,"PACKUP"); //Ripper...Packup a player vendor without redeeding house.
    response1=(strstr( comm, search1));
    if (response1 && online(currchar[s]) && (!(pc_currchar->dead)))
    {
       int pvDeed;
       for( unsigned int i = 0; i < charcount; i++)
       {
           if(chars[i].npc)
           {
               if(chardist(s,i)<=3) // must be with in 3 tiles.
               {
                   if(pc_currchar->Owns(&chars[i])) // you own the vendor
                   {
                      if( chars[i].npcaitype == 17 ) // player vendor
                      {
                                                          // lets make the deed and place in your pack and delete vendor.
                              //sprintf( temp, "A vendor deed for %s", chars[i].name );
                           strcpy( temp, "employment deed" );
                           pvDeed = Items->SpawnItem( -1,s, 1, temp, 0, 0x14, 0xF0, 0, 0, 1, 0 );
                           items[pvDeed].type = 217;
                           items[pvDeed].value = 2000;
                           RefreshItem( pvDeed );
                           sprintf(temp, "Packed up vendor %s.", chars[i].name);
                           Npcs->DeleteChar( i );
                           sysmessage(s, temp);
                           return 1;
					  }
                } return 0;
             }

		   }
        }
    }

	x=pc_currchar->x;
	y=pc_currchar->y;

	
	// there are like 10 charcount LOOPs insde a mapregions loop
	// Needs CHECKING if redundant ( think so) !!!

	//Char mapRegions
	int getcell=mapRegions->GetCell(x,y);
	int mapitem=-1;
	int mapitemptr=-1;
	int mapchar=-1;
	int loopexit=0;
	do //check all items in this cell
	{
		mapitemptr=mapRegions->GetNextItem(getcell, mapitemptr);
		if (mapitemptr==-1) break;
		mapitem=mapRegions->GetItem(getcell, mapitemptr);
		if (mapitem>999999) mapchar=mapitem-CharacterOffset;
		if (mapitem!=-1 && mapitem>=CharacterOffset)
		{
			k=mapchar;
			if (abs(pc_currchar->x-chars[k].x)<=4 &&
				abs(pc_currchar->y-chars[k].y)<=4 &&
				abs(pc_currchar->z-chars[k].z)<=5)
			{

				if (chars[k].trigger)
				{
					if (strlen(chars[k].trigword))
					{
						strcpy(search1, chars[k].trigword);
						strupr(search1);
						response1=(strstr( comm, search1));
						if (response1 && (!(pc_currchar->dead)))
						{
							if (chars[k].disabled>0 && chars[k].disabled>uiCurrentTime)//AntiChrist
							{
								npctalkall(k,"I'm a little busy now! Leave me be!",0);
							} else {
								triggernpc(s,k,1);
							}
							return 1;
						}
					}
				}
			}

        // Dupois - Added Dec 20, 1999
        // Escort text matches
        strcpy(search1,"I WILL TAKE THEE");
        strcpy(search2,"DESTINATION");
        response1=(strstr( comm, search1));
        response2=(strstr( comm, search2));
        
        // If either of the above responses match, then find the NPC we are talking to
        if ( response1 || response2 )
        {
        // If the PC is dead then break out, The dead cannot accept quests
        if ( pc_currchar->dead ) return 0;
        
        // Search for the NPC we are talking to
        for (k=0;k<charcount;k++)
        {
          // If this is an NPC then check it 
          if ( chars[k].npc == 1 )
          {
            // I WILL TAKE THEE
            // If this is a request for hire and the PC is within range of the NPC and the NPC is waiting for an ESCORT
            if ( (response1 && (chardist(k, currchar[s])<=1) && (chars[k].questType==ESCORTQUEST) && (chars[k].ftarg==-1)) )
            {
              // Set the NPC to follow the PC
              chars[k].ftarg = currchar[s];
            
              // Set the NPC to wander freely
              chars[k].npcWander = 1;
        
              // Set the expire time if nobody excepts the quest
              chars[k].summontimer = ( uiCurrentTime + ( MY_CLOCKS_PER_SEC * SrvParms->escortactiveexpire ) );
        
              // Send out the rant about accepting the escort
              sprintf(temp, "Lead on! Payment shall be made when we arrive at %s.", region[chars[k].questDestRegion].name);
              npctalkall(k,temp, 0);
        
              // Remove post from message board (Mark for deletion only - will be cleaned during cleanup)
              MsgBoardQuestEscortRemovePost( k );
            
              // Return 1 so that we indicate that we handled the message
              return 1;
            }
            else if ( (response1 && (chardist(k, currchar[s])<=1) && (chars[k].questType==ESCORTQUEST)) )
            {
              // If the current NPC already has an ftarg then respond to query for quest
              response2 = response1;
            }
        
            // DESTINATION
            // If this is a request to find out where a NPC wants to go and the PC is within range of the NPC and the NPC is waiting for an ESCORT
            if ( (response2 && (chardist(k, currchar[s])<=1) && (chars[k].questType==ESCORTQUEST)) )
            {
              if ( chars[k].ftarg == currchar[s] )
              {
                // Send out the rant about accepting the escort
                sprintf(temp, "Lead on to %s. I shall pay thee when we arrive.", region[chars[k].questDestRegion].name);
                npctalkall(k,temp, 0);
              }
              else if ( chars[k].ftarg == -1 )  // If nobody has been accepted for the quest yet
              {
                // Send out the rant about accepting the escort
                sprintf(temp, "I am seeking an escort to %s. Wilt thou take me there?", region[chars[k].questDestRegion].name);
                npctalkall(k,temp, 0);
              }
              else // The must be enroute
              {
                // Send out a message saying we are already being escorted
                sprintf(temp, "I am already being escorted to %s by %s.", region[chars[k].questDestRegion].name, chars[chars[k].ftarg].name );
                npctalkall(k,temp, 0);
              }
        
              // Return success ( we handled the message )
              return 1;
            }
          }
         }
        }// Dupois - End

	strcpy(search1,"BANK");
    strcpy(search2,"BALANCE");
    response1=(strstr( comm, search1));
    response2=(strstr( comm, search2));
    if (response1 && (!(pc_currchar->dead)) && inbankrange(currchar[s]))
	{
		openbank(s, currchar[s]);
	}
    if (response2 && (!(pc_currchar->dead)) && inbankrange(currchar[s]))
	{
			bool found = false;
			int counter2 = 0, loopexit2=0;
			while( (!found) && (counter2 < charcount) && (++loopexit2 < MAXLOOPS) )
			{
				if( chars[counter2].npcaitype == 8 && chardist( currchar[s], counter2 ) <= 12 ) // 12 for bank?
				{
			       found = true;
			       sprintf(temp, "%s's balance as of now is %i.", pc_currchar->name, pc_currchar->CountBankGold());
			       npctalkall(counter2, temp, 1);
				}
				else
				{
				  counter2++;
				}
			}
		}

				
	//this only if specialbank is enabled - AntiChrist
	if(SrvParms->usespecialbank)
	{
		strcpy(search1, SrvParms->specialbanktrigger);
		response1=(strstr( comm, search1));
		if (response1 && (!(pc_currchar->dead)) && inbankrange(currchar[s]))
		{
			openspecialbank(s, currchar[s]);
		}
	}
			    strcpy(search1,"TRAIN");
                strcpy(search2,"TEACH");
                strcpy(search3,"LEARN");
                response1=(strstr( comm, search1));
                response2=(strstr( comm, search2));
                response3=(strstr( comm, search3));
                if (response1 || response2 || response3) //if the player wants to train
				{
                   unsigned int nChar=currchar[s];  //for the chars[] #
                   chars[nChar].trainer=-1; //this is to prevent errors when a player says "train <skill>" then doesn't pay the npc
                   for(i=0;i<ALLSKILLS;i++)
				   {
                      if(strstr(comm, skillname[i]))
					  {
                        skill=i;  //Leviathan fix
                        break;
					  }
				   }
              if(skill==-1) // Didn't ask to be trained in a specific skill - Leviathan fix
			  {
                 if(chars[nChar].trainer==-1) //not being trained, asking what skills they can train in
				 {
                   for (k=0;k<charcount;k++)
				   {
                      if (chars[k].npc)
					  {
                         if (chardist(k, currchar[s])<=3
							 && chars[k].id1==0x01 && (chars[k].id2==0x90 || chars[k].id2==0x91)) // human ?
						 {
							chars[k].trainingplayerin='\xFF'; // Like above, this is to prevent  errors when a player says "train <skill>" then doesn't pay the npc
							strcpy(temp,"I can teach thee the following skills: ");
							for(j=0;j<ALLSKILLS;j++)
							  {
								 if(chars[k].baseskill[j]>=10 && pc_currchar->baseskill[j]<250)
								 {
							      sprintf(temp2,"%s, ", strlwr(skillname[j]));
							      strupr(skillname[j]); // I found out strlwr changes the actual  string permanently, so this undoes that
							      if(!y) temp2[0]=toupper(temp2[0]); // If it's the first skill,  capitalize it.
							      strcat(temp,temp2);
							      y++;
								  }
							  }
							if(y && chars[k].cantrain) // skills and a trainer ?
							{
							  temp[strlen(temp)-2]='.'; // Make last character a . not a ,  just to look nicer
							  npctalk(s, k, temp,0);
							}
							else
							{
							   npctalk(s, k, "I am sorry, but I have nothing to teach thee",0);
							}
							return 1;
						 }
					  }
				   }
				 } // End it .trainer if statement
			  } // The if for if they are asking to train in a specific skill
              else // They do want to learn a specific skill
			  {
              for (k=0;k<charcount;k++)
			  {
                if (chars[k].npc)
				{
                   if (chardist(k, nChar)<=3 && chars[k].id1==0x01 && (chars[k].id2==0x90 || chars[k].id2==0x91))
				   {
                     if(chars[k].baseskill[skill]>10 && chars[k].cantrain)
					 {
                        x=skill;
                        sprintf(temp,"Thou wishest to learn of  %s?",strlwr(skillname[x]));
                        strupr(skillname[x]); // I found out strlwr changes the actual string permanently, so this undoes that
                        if(chars[nChar].baseskill[x]>=250)
						{
                           strcat(temp, " I can teach thee no more than thou already knowest!");
						}
						else
						{
							int sum = chars[nChar].getSkillSum();
							if (sum >= SrvParms->skillcap * 10)
								strcat(temp, " I can teach thee no more. Thou already knowest too much!");
							else
							{
								int delta = chars[k].getTeachingDelta(&chars[nChar], skill, sum);
								int perc = (chars[nChar].baseskill[x] + delta)/10;

								sprintf(temp2, " Very well I, can train thee up to the level of %i percent for %i gold. Pay for less and I shall teach thee less.",perc,delta);
								strcat(temp, temp2);
								chars[nChar].trainer=chars[k].serial;
								chars[k].trainingplayerin=x;
							}
						}
						npctalk(s, k, temp,0);
						return 1;
					 } // They cannot teach x skill
					else
					{npctalk(s, k, "I am sorry but I cannot train thee in that skill.",0); return 1; }
				   }
				}
			  }
			 } // end the else
			}

				
				strcpy(search1," FOLLOW");
				strcpy(search2," ME");
				response1=(strstr( comm, search1));
				response2=(strstr( comm, search2));
				
				if (response1) //if follow
				{
					//taken from 6904t2(5/10/99) - AntiChrist
					pc_currchar->guarded = false;
					for (k=0;k<charcount;k++)
					{
						if (pc_currchar->Owns(&chars[k]) || (pc_currchar->isGM())) //owner of the char || a GM
						{
							strcpy(search3,chars[k].name);
							strupr(search3);
							response3=(strstr( comm, search3));
							if (response3) //if petname is in
							{
								if (chars[k].npcaitype==17) return 0; //ripper
								if (chardist(k, currchar[s])<=7)
								{
									if (response2) //if me is in
									{
										chars[k].ftarg=(currchar[s]);
										chars[k].npcWander=1;
										playmonstersound(k, chars[k].id1, chars[k].id2, SND_STARTATTACK);
										return 1;
									}
									else
									{
										//add pet follow code here
										addid1[s]=chars[k].ser1;
										addid2[s]=chars[k].ser2;
										addid3[s]=chars[k].ser3;
										addid4[s]=chars[k].ser4;
										target(s, 0, 1, 0, 117, "Click on the target to follow.");
										return 1;
									}
								}
							}
						}
					}
				}
				strcpy(search1," KILL");
				strcpy(search2," ATTACK");
				response1=(strstr( comm, search1));
				response2=(strstr( comm, search2));
				if ((response1)||(response2)) //if kill||attack
				{
					//taken from 6904t2(5/10/99) - AntiChrist
					pc_currchar->guarded = false;
					for (k=0;k<charcount;k++)
					{
						if (chardist(k, currchar[s])<=7)
						{
							if (pc_currchar->Owns(&chars[k]) || (pc_currchar->isGM()))
							{
								strcpy(search3,chars[k].name);
								strupr(search3);
								response3=(strstr( comm, search3));
								if (response3) //if petname is in
								{
									if (chars[k].inGuardedArea()) // Ripper..No pet attacking in town.
									{
										sysmessage(s,"You cant have pets attack in town!");
										return 0;
									}
									if (chars[k].npcaitype==17)
										return 0; //ripper
									addid1[s]=chars[k].ser1;
									addid2[s]=chars[k].ser2;
									addid3[s]=chars[k].ser3;
									addid4[s]=chars[k].ser4;
									//pet kill code here
									target(s, 0, 1, 0, 118, "Select the target to attack.");//AntiChrist
									return 1;
								}
							}
						}
					}
				}
				strcpy(search1," FETCH");
				strcpy(search2," GET");
				response1=(strstr( comm, search1));
				response2=(strstr( comm, search2));
				if ((response1)||(response2)) //if fetch||get
				{
					//taken from 6904t2(5/10/99) - AntiChrist
					pc_currchar->guarded = false;
					for (k=0;k<charcount;k++)
					{
						if (pc_currchar->Owns(&chars[k]) || (pc_currchar->isGM()))
						{
							strcpy(search3,chars[k].name);
							strupr(search3);
							response3=(strstr( comm, search3));
							if (response3) //if petname is in
							{
								if (chars[k].npcaitype==17) return 0; //ripper
								if (chardist(k, currchar[s])<=7)
								{
									addid1[s]=chars[k].ser1;
									addid2[s]=chars[k].ser2;
									addid3[s]=chars[k].ser3;
									addid4[s]=chars[k].ser4;
									//pet fetch code here
									target(s, 0, 1, 0, 124, "Click on the object to fetch.");
									return 1;
								}
							}
						}
					}
				}
				
				strcpy(search1," COME");
				response1=(strstr( comm, search1));
				if (response1) //if come
				{
					//taken from 6904t2(5/10/99) - AntiChrist
					pc_currchar->guarded = false;
					int k;
					for (k=0;k<charcount;k++)
					{
						if (pc_currchar->Owns(&chars[k]) || (pc_currchar->isGM()))
						{
							strcpy(search3,chars[k].name);
							strupr(search3);
							response3=(strstr( comm, search3));
							if (response3) //if petname is in
							{
								if (chars[k].npcaitype==17) return 0; //ripper
								if (chardist(k, currchar[s])<=7)
								{
									chars[k].ftarg=(currchar[s]);
									chars[k].npcWander=1;
									sysmessage(s, "Your pet begins following you.");
									return 1;
								}
							}
						}
					}
				}
				
				//taken from 6904t2(5/10/99) - AntiChrist
				strcpy(search2," ME");
				response2=(strstr( comm, search2));
				if (strstr(comm," GUARD")) //if guard
				{
					for (k=0;k<charcount;k++)
					{
						if (pc_currchar->Owns(&chars[k]) || pc_currchar->isGM())
						{
							strcpy(search3,chars[k].name);
							strupr(search3);
							response3=(strstr( comm, search3));
							if (response3) //if petname is in
							{
								if (chars[k].npcaitype==17) return 0; //ripper
								if (chardist(k, currchar[s])<=7)
								{
									addx[s] = chars[k].serial;	// the pet's serial
									addy[s] = 0;
									if (response2)	//if me is in
										addy[s]=1;	// indicates we already know whom to guard (for future use)
													// for now they still must click on themselves (Duke)
									target(s, 0, 1, 0, 120, "Click on the char to guard.");
									return 1;
								}
							}
						}
					}
				}
				
				strcpy(search1," STOP");
				strcpy(search2," STAY");
				response1=(strstr( comm, search1));
				response2=(strstr( comm, search2));
				if ((response1)||(response2)) //if stop||stay
				{
					//taken from 6904t2(5/10/99) - AntiChrist
					pc_currchar->guarded = false;
					for (k=0;k<charcount;k++)
					{
						if (pc_currchar->Owns(&chars[k]) || pc_currchar->isGM())
						{
							strcpy(search3,chars[k].name);
							strupr(search3);
							response3=(strstr( comm, search3));
							if (response3) //if petname is in
							{
								if (chars[k].npcaitype==17) return 0; //ripper
								if (chardist(k, currchar[s])<=7)
								{
									//pet stop code here
									chars[k].ftarg=-1;
									chars[k].targ=-1;
									if (chars[k].war) npcToggleCombat(k);
									chars[k].npcWander=0;
									return 1;
								}
							}
						}
					}
				}
				strcpy(search1," TRANSFER");
				response1=(strstr( comm, search1));
				if (response1) //if transfer
				{
					//taken from 6904t2(5/10/99) - AntiChrist
					pc_currchar->guarded = false;
					for (k=0;k<charcount;k++)
					{
						if (pc_currchar->Owns(&chars[k]) || pc_currchar->isGM())
						{
							strcpy(search3,chars[k].name);
							strupr(search3);
							response3=(strstr( comm, search3));
							if (response3) //if petname is in
							{
								if (chars[k].npcaitype==17) return 0; //ripper
								if (chardist(k, currchar[s])<=7)
								{
									//pet transfer code here
									addid1[s]=chars[k].ser1;
									addid2[s]=chars[k].ser2;
									addid3[s]=chars[k].ser3;
									addid4[s]=chars[k].ser4;
									target(s, 0, 1, 0, 119, "Select character to transfer your pet to.");
									return 1;
								}
							}
						}
					}
				}
				strcpy(search1," RELEASE");
				response1=(strstr( comm, search1));
				if (response1) //if transfer
				{
					//taken from 6904t2(5/10/99) - AntiChrist
					pc_currchar->guarded = false;
					for (k=0;k<charcount;k++)
					{
						if (pc_currchar->Owns(&chars[k]))
						{
							strcpy(search3,chars[k].name);
							strupr(search3);
							response3=(strstr( comm, search3));
							if (response3) //if petname is in
							{
								if (chars[k].npcaitype==17) return 0; //ripper
								if (chardist(k, currchar[s])<=7)
								{
									if (chars[k].summontimer)
									{
										chars[k].summontimer=uiCurrentTime;
									}
									//pet release code here
									chars[k].ftarg=-1;
									chars[k].npcWander=2;
									chars[k].SetOwnSerial(-1);
									//taken from 6904t2(5/10/99) - AntiChrist
									chars[k].tamed = false;
									sprintf(temp, "*%s appears to have decided that it is better off without a master *", chars[k].name);
									npctalkall(k,temp,0);
									{
										soundeffect2(k, 0x01, 0xFE);
										if(SrvParms->tamed_disappear==1)
										Npcs->DeleteChar(k) ;
									}
									return 1;
								}
							}
						}
					}
				}
				
			}//if !=-1
	} while ( (mapitem!=-1) && (++loopexit < MAXLOOPS));
	return 0;
}

void PlVGetgold(int s, int v)//PlayerVendors
{
	unsigned int pay=0, give=chars[v].holdg, t=0;

	P_CHAR pc_currchar = MAKE_CHARREF_LR(currchar[s]);
	
	if (pc_currchar->Owns(&chars[v]))
	{
		if (chars[v].holdg<1)
		{
			npctalk(s,v,"I have no gold waiting for you.",0);
			chars[v].holdg=0;
			return;
		} else if(chars[v].holdg<=65535)
		{
			if (chars[v].holdg>9)
			{
				pay=(int)(chars[v].holdg*.1);
				give-=pay;
			} else {
				pay=chars[v].holdg;
				give=0;
			}
			chars[v].holdg=0;
		} else {
			t=chars[v].holdg-65535;
			chars[v].holdg=65535;
			pay=6554;
			give=58981;
		}
		if (give)
			Items->SpawnItem(s,currchar[s],give,"#",1,0x0E,0xED,0,0,1,1);
		sprintf((char*)temp, "Today's purchases total %i gold. I am keeping %i gold for my self. Here is the remaining %i gold. Have a nice day.",chars[v].holdg,pay,give);
		npctalk(s,v,(char*)temp,0);
		chars[v].holdg=t;
	} else npctalk(s,v,"I don't work for you!",0);
}

// further Bugfixing, Speedup and Reorganization by LB 1.1.2000

void responsevendor(UOXSOCKET s, int vendor) 
{
	CHARACTER cc=currchar[s];
	
	P_CHAR pc_currchar = MAKE_CHARREF_LR(currchar[s]);
	
	static char buffer1[MAXBUFFER_REAL]; // static becasue maxbuffer_ral close to stack limit of win-machines
	int i;
	char *comm;
	
	char *response1;
	char *response2;
	char *response3;
	char *response4;
	
	char search1[50];
	char search2[50];
	char search3[50];
	char search4[50];
	
//	char nonuni[512];
	static char nonuni[MAXBUFFER_REAL];

	int getcell,mapitem,mapitemptr,mapchar,StartGrid,increment,checkgrid,a;
	int k;
	
	if(pc_currchar->unicode)
	{
		wchar2char((char*) &buffer[s][13]);
		strcpy(nonuni, (char*)temp);
	}
		
	int MB = MAXBUFFER_REAL;
	if (server_data.packetsendstyle==PSS_UOX3) MB = MAXBUFFER_ASYNCH;

	////////// ouch, this hurts !!!

	if(!(pc_currchar->unicode))
	{
		for (i=7; i < MB; i++)
		{
			tbuffer[i]=buffer1[i];
			buffer1[i]=toupper(buffer[s][i]);
		}
	}
	else
	{
		for (i=0; i < MB-8; i++)
		{
			tbuffer[i+8]=buffer1[i+8];
			buffer1[i+8]=toupper(nonuni[i]);
		}
	}
	
	/// end of that hurts
	
	comm=&buffer1[8];

		////// Player said vendor BUY or vendor sell 
		////// In that case we alerady have the vendor-number from hte calling function 
		////// and dont need to search again
		////// Speedup by LB
		
		strcpy(search1, "VENDOR");
		strcpy(search2, "SHOPKEEPER");
		strcpy(search4, " BUY");
		response1=(strstr(comm, search1));
		response2=(strstr(comm, search2));
		response4=(strstr(comm, search4));
		
		if (response4)//AntiChrist
		{		
			if (response2 || response1)
			{
				if(chars[vendor].npcaitype==17)
				{					
					addx[s]=vendor;
					npctalk(s,vendor,"What would you like to buy?",0);
					target(s,0,1,0,224," ");
					return; // lb bugfix
				} else if(Targ->BuyShop(s, vendor)) return; // lb bugfix
			}
		}
		
		//PlayerVendors
		response4=0;
		strcpy(search4, " GOLD");
		response4=(strstr( comm, search4));
		if (response4)//AntiChrist
		{
			if (response2 || response1)
			{
				if (chars[vendor].npcaitype==17)
				{
					PlVGetgold(s, vendor);
					return;
				}
			}
		}
			
		//end PlayerVendors --^
		
		response4=0;
		strcpy(search4, " SELL");
		response4=(strstr( comm, search4));
		if (response4)//AntiChrist
		{						
			if (response2 || response1)
			{												
				sellstuff(s, vendor);						
				return;
			}
		}


		// IF vendors are referred by NAME the vendor number passed by
		// doesnt have to be correct, thus we have to search again.
		// LB

		response4=strstr(comm," BUY");
		
		int loopexit=0;
		if (response4)//AntiChrist
		{
			P_CHAR pc;
			RegGrid3x3Iterator4Chars rg3ic(pc_currchar->x, pc_currchar->y);
			while((pc = rg3ic.Next()) != NULL && (++loopexit < MAXLOOPS) )
			{
				if (chardist(DEREF_P_CHAR(pc),cc) >= 2)
					continue;
				strcpy(search3,pc->name);
				strupr(search3);
				response3=(strstr( comm, search3));
				if (response3)
				{
					int vi=DEREF_P_CHAR(pc);	// the vendor index
					if(pc->npcaitype==17)
					{
						addx[s]=vi;
						npctalk(s,vi,"What would you like to buy?",0);
						target(s,0,1,0,224," ");
						return;
					}
					else
						if(Targ->BuyShop(s, vi))
							return;						
				}
			}
		} // if response4
	
					
		//PlayerVendors
		response4=0;
		strcpy(search4, " GOLD");
		response4=(strstr( comm, search4));

		if (response4)//AntiChrist
		{
	      
		  StartGrid=mapRegions->StartGrid(pc_currchar->x,pc_currchar->y);
	      getcell=mapRegions->GetCell(pc_currchar->x,pc_currchar->y);
						
		  increment=0;
	
		  for (checkgrid=StartGrid+(increment*mapRegions->GetColSize());increment<3;increment++, checkgrid=StartGrid+(increment*mapRegions->GetColSize()))
		  {	
			for (a=0;a<3;a++)
			{					
				mapitemptr=-1;
				mapitem=-1;
				mapchar=-1;
				loopexit=0;
				do //check all items in this cell
				{
					mapchar=-1;
					mapitemptr=mapRegions->GetNextItem(checkgrid+a, mapitemptr);
					if (mapitemptr==-1) break;
					mapitem=mapRegions->GetItem(checkgrid+a, mapitemptr);
					if(mapitem>999999) mapchar=mapitem-CharacterOffset;
					if (mapitem!=-1 && mapitem>=CharacterOffset)
					{

					  k=mapchar;
					  strcpy(search3,chars[k].name);
					  strupr(search3);
					  response3=(strstr( comm, search3));
					  if (response3)
					  {					
						 if (chars[k].npcaitype==17)
						 {
							PlVGetgold(s, k);
							return;
						 }						
					  }
					   

					}
				} while ( (mapitem!=-1) && (++loopexit < MAXLOOPS) );			
			}
				
		  }
		} // if response4

						
		//end PlayerVendors --^
			
		response4=0;
		strcpy(search4, " SELL");
		response4=(strstr( comm, search4));

		if (response4)//AntiChrist
		{
	      
		  StartGrid=mapRegions->StartGrid(pc_currchar->x,pc_currchar->y);
	      getcell=mapRegions->GetCell(pc_currchar->x,pc_currchar->y);
						
		  increment=0;
	
		  for (checkgrid=StartGrid+(increment*mapRegions->GetColSize());increment<3;increment++, checkgrid=StartGrid+(increment*mapRegions->GetColSize()))
		  {	
			for (a=0;a<3;a++)
			{					
				mapitemptr=-1;
				mapitem=-1;
				mapchar=-1;
				loopexit=0;
				do //check all items in this cell
				{
					mapchar=-1;
					mapitemptr=mapRegions->GetNextItem(checkgrid+a, mapitemptr);
					if (mapitemptr==-1) break;
					mapitem=mapRegions->GetItem(checkgrid+a, mapitemptr);
					if(mapitem>999999) mapchar=mapitem-CharacterOffset;
					if (mapitem!=-1 && mapitem>=CharacterOffset)
					{
						k=mapchar;
					    strcpy(search3,chars[k].name);
					    strupr(search3);
					    response3=(strstr( comm, search3));
					    if (response3)
						{													
							sellstuff(s, k);
							return;						
						}
					 					  
					}
				} while ((mapitem!=-1) && (++loopexit < MAXLOOPS) );			
			}
				
		  }
		} // if response4
										
  return;		
}

void talking(int s, string speech) // PC speech
{
/*
	Unicode speech format
	byte = char, short = char[2], int = char[4], wchar = char[2] = unicode character

	Message Sent By Client:
	0xAD - Unicode Speech Request
	BYTE cmd(0xAD)
	short msgsize 1, 2
	byte type(0 = say, 2 = emote, 8 = whisper, 9 = yell) 3
	short color 4, 5
	short font 6, 7
	BYTE[4] lang(null terminated, "enu " for US english.) 8, 9, 10, 11
	wchar[?] text(null terminated, ?=(msgsize - 12)/2) 13
  
	Message Sent By Server:
	0xAE - Unicode Speech Message
	BYTE cmd(0xAE) 0
	short msgsize 1, 2
	BYTE[4] ser(ser of speaker, all 0xFF if none) 3, 4, 5, 6
	BYTE[2] model(id of speaker, all 0xFF if none)7, 8
	BYTE type 9
	short color 10, 11
	short font 12, 13
	BYTE[4] language(same as before) 14, 15, 16, 17
	BYTE[30] speaker's name(normal chars, not wchars) 18 - 48
	WCHAR[?] text(null terminated, ?=(msgsize - 48)/2

    Importnat note regarding 0xAD: since 2.0.7 clients send between lang and text 0...10 bytes. (we can ignore them safely)
	Those bytes get cut out in network.cpp correctly, so the buffer THIS functions sees is actualy what is written above.
    The actual data the client sends is differently though.
	Just noted this to prevent from debugging if somebody finds out client data doesn't fit to this description (LB) 

*/
	
	int mapitemptr, mapitem, mapchar, a, checkgrid, increment, StartGrid, getcell, ab, loopexit = 0;
	int tl, i, j, resp, found, x1, x2, y1, y2, match, m2, sml;
	char sect[512];
	char nonuni[512];
	unsigned char talk2[19];
	char unicodetext[512];
	char lang[4];
	char name[30] = {0,};	// it **IS** important to 0 out the remaining gaps
	
	P_CHAR pc_currchar = MAKE_CHARREF_LR(currchar[s]);	
	strcpy(nonuni, speech.c_str());

	// len+font+color+type = same postion for non unicode and unicode speech packets
	// but 8 ... x DIFFER a lot for unicode and non unicode packets !!!

//	memset(name, 0, 30); 
	strcpy(name, pc_currchar->name);

	char speech_type       = buffer[s][3]; 
	UI16 speech_color	   = ShortFromCharPtr(&buffer[s][4]);
	char speech_fontbyte1  = buffer[s][6];
	char speech_fontbyte2  = buffer[s][7];

	int ucl = ( strlen ( nonuni ) * 2 ) + 2 ;	
	tl = ucl + 48 ;

	bool uc = pc_currchar->unicode ;

	if (uc)
	{
       lang[0]=buffer[s][8];
	   lang[1]=buffer[s][9];
	   lang[2]=buffer[s][10];
	   lang[3]=buffer[s][11];

	   memcpy(unicodetext, &buffer[s][12], ucl);

	}
	else
	{
	   lang[0]='E';
	   lang[1]='N';
	   lang[2]='U';
	   lang[3]=0;

	   char2wchar(nonuni);              // we are sending unicode response no matter if the speech request was non unicode or not
	                                    // so convert to uni-text in case of non unicode
	   memcpy(unicodetext, temp, ucl);  
	}

	/*
	clConsole.send("speech: %s\n",nonuni);
	clConsole.send("unicode speech:\n");
	for ( a=0; a < tl-48; a++) clConsole.send("%02i ",unicodetext[a]);
	clConsole.send("\n");*/

	//// Very important: do not use buffer[s][] anymore in this function !!!!
	//// unicode text that gets send is in unicodetext, nonunicode text for normal string processing in non uni code

	if (pc_currchar->fx2 == 17)// Pricing an item //PlayerVendors
	{
		int i = str2num((char*)nonuni);
		if (i>0)
		{
			items[pc_currchar->fx1].value = i;
			pc_currchar->fx2 = 18;
			sprintf((char*)temp, "This item's price has been set to %i.", i);
			sysmessage(s, (char*)temp);
			sysmessage(s, "Enter a description for this item.");
		}
		else 
		{
			pc_currchar->fx2 = 18;
			sprintf((char*)temp, "No price entered, this item's price has been set to %i.", items[pc_currchar->fx1].value);
			sysmessage(s, (char*)temp);
			sysmessage(s, "Enter a description for this item.");
		}
		return;
	}
	else if (pc_currchar->fx2 == 18)// Describing an item
	{
		strcpy(items[pc_currchar->fx1].desc, (char*)nonuni);
		pc_currchar->fx1 = pc_currchar->fx2=-1;
		sprintf((char*)temp, "This item is now described as %s, ", nonuni);
		sysmessage(s, (char*)temp);
		return;
	}
	else if (pc_currchar->runenumb!=-1)
	{
		sprintf(items[pc_currchar->runenumb].name, "Rune to %s", nonuni);
		sprintf((char*)temp, "Rune renamed to: Rune to %s", nonuni);
		sysmessage(s, (char*)temp);
		pc_currchar->runenumb=-1;
		return;
	}
	else if (pc_currchar->namedeed != 5) // eagle rename deed
	{
		strcpy(items[pc_currchar->namedeed].name, (char*)nonuni);
		strcpy(pc_currchar->name, items[pc_currchar->namedeed].name);
		sprintf((char*)temp, "Your new name is: %s", nonuni);
		sysmessage(s, (char*)temp);
		pc_currchar->namedeed = 5;
		return;
	}
	else if (pc_currchar->keynumb!=-1) // Morrolan key rename stuff
	{
		strcpy(items[pc_currchar->keynumb].name, (char*)nonuni);
		sprintf((char*)temp, "Renamed to: %s", nonuni);
		sysmessage(s, (char*)temp);
		pc_currchar->keynumb=-1;
		return;
	}
	else if (pc_currchar->pagegm == 1)
	{
		int a1, a2, a3, a4;
		a1 = pc_currchar->ser1;
		a2 = pc_currchar->ser2;
		a3 = pc_currchar->ser3;
		a4 = pc_currchar->ser4;
		strcpy(gmpages[pc_currchar->playercallnum].reason, (char*)nonuni);
		sprintf((char*)temp, "GM Page from %s [%x %x %x %x]: %s",
		pc_currchar->name, a1, a2, a3, a4, gmpages[pc_currchar->playercallnum].reason);
		int x = 0;
		for (i = 0; i < now; i++)
		{
			if ((chars[currchar[i]].isGM()) && perm[i])
			{
				x = 1;
				sysmessage(i, (char*)temp);
			}
		}
		if (x == 1)
		{
			sysmessage(s, "Available Game Masters have been notified of your request.");
		}
		else 
			sysmessage(s, "There was no Game Master available to take your call.");
		pc_currchar->pagegm = 0;
		return;
	}
	else if (pc_currchar->pagegm == 2) // Counselor page
	{
		int a1, a2, a3, a4;
		a1 = pc_currchar->ser1;
		a2 = pc_currchar->ser2;
		a3 = pc_currchar->ser3;
		a4 = pc_currchar->ser4;
		strcpy(counspages[pc_currchar->playercallnum].reason, (char*)nonuni);
		sprintf((char*)temp, "Counselor Page from %s [%x %x %x %x]: %s",
			pc_currchar->name, a1, a2, a3, a4, counspages[pc_currchar->playercallnum].reason);
		int x = 0;
		for (i = 0; i < now; i++)
		{
			if (chars[currchar[i]].isCounselor() && perm[i])
			{
				x = 1;
				sysmessage(i, (char*)temp);
			}	
		}
		if (x == 1)
		{
			sysmessage(s, "Available Counselors have been notified of your request.");
		}
		else 
			sysmessage(s, "There was no Counselor available to take your call.");
		pc_currchar->pagegm = 0;
		return;
	}
	else
	{// Squelch
		if (pc_currchar->squelched)
		{
			sysmessage(s, "You have been squelched.");
			return;
		}
	}
			
	// AntiChrist
	pc_currchar->unhide();
		
	if (nonuni[0] == SrvParms->commandPrefix )
		Commands->Command(s, speech);
	else
	{
		resp = response(s);
		
		if (( speech_type == '\x09') && (pc_currchar->canBroadcast()))
		{
			broadcast(s);
		}
		else
		{
			
			if (!strcmp(strupr(nonuni), "I RESIGN FROM MY GUILD")) Guilds->Resign(s);

			talk2[0] = 0xAE;
			talk2[1] = tl >> 8;
			talk2[2] = tl&0xFF;
			talk2[3] = pc_currchar->ser1;
			talk2[4] = pc_currchar->ser2;
			talk2[5] = pc_currchar->ser3;
			talk2[6] = pc_currchar->ser4;
			talk2[7] = pc_currchar->id1;
			talk2[8] = pc_currchar->id2;

			talk2[9] =  speech_type;
			ShortToCharPtr(speech_color, &talk2[10]);
			talk2[12] = speech_fontbyte1;
			talk2[13] = speech_fontbyte2;

			talk2[14] = lang[0];
			talk2[15] = lang[1];
			talk2[16] = lang[2];
			talk2[17] = lang[3];

			Xsend(s, talk2, 18);
			Xsend(s, name, 30);   
			Xsend(s, unicodetext, ucl);   
					
			if (speech_type == 0 || speech_type == 2)
			{
				pc_currchar->saycolor = speech_color;
			}
			if (SrvParms->speech_log) // Logging bugfixed by LB
			{
				char temp2[512];
				sprintf(temp2, "%s.speech_log", pc_currchar->name);
				sprintf((char*)temp, "%s [%x %x %x %x] [%i] said:\n%s\n", pc_currchar->name, pc_currchar->ser1, pc_currchar->ser2, pc_currchar->ser3, pc_currchar->ser4, pc_currchar->account, nonuni);
				savelog((char*)temp, (char*)temp2);
			}
			
			if (resp != 0)
				return;  // Vendor responded already
			
			// taken from 6904t2(5/10/99) - AntiChrist
			char search1[10];
			strcpy(search1, "GUARDS");
			char *response1;
			char str[256];
			strcpy(str, nonuni);
			strupr(str);
			response1 = (strstr(str, search1));
			if (response1)
				callguards(currchar[s]);
			
			// Boats->Speech(s,nonuni);//Boats
			char bb = Boats->Speech(s, nonuni);		
			// clConsole.send("bb: %i\n",bb);
			if (bb) return;
			
			
			house_speech(s, nonuni); // houses crackerjack 8/12/99			
			
			for (i = 0; i < now; i++)
			{
				// AntiChrist - don't check line of sight for talking!!!
				if (inrange1(i, s) && perm[i] && i!=s)//&&line_of_sight(s, pc_currchar->x, pc_currchar->y, pc_currchar->z, chars[currchar[i]].x, chars[currchar[i]].y, chars[currchar[i]].z, WALLS_CHIMNEYS + DOORS + FLOORS_FLAT_ROOFING))
				{
					Xsend(i, talk2, 18);
					Xsend(i, name, 30);
					// modified by AntiChrist
					if (!(chars[currchar[i]].isGMorCounselor()) && chars[currchar[i]].spiritspeaktimer == 0)// GM/Counselors can see ghosts talking always  Seers?
					{
						if (pc_currchar->dead && !chars[currchar[i]].dead)  // Ghost can talk normally to other ghosts
						{
							// -2: dont override /0 /0 terminator !
							unsigned char ghostspeech[512];
							memcpy(&ghostspeech, &unicodetext, ucl);
							for (j = 1; j < ucl-2 ; j += 2)
							{
								if (ghostspeech[j] == 32)
								{
									;
								}
								else if (ghostspeech[j]%2)     
									ghostspeech[j] = 'O';
								else
									ghostspeech[j] = 'o';
							}
							Xsend(i, ghostspeech, ucl);
							continue;
						}
					}
									
					Xsend(i, unicodetext, ucl);   
					    
				}
			}

			if (pc_currchar->dead) return; // this makes it so npcs do not respond to dead people
				
			found = 0;
			x1 = pc_currchar->x;
			y1 = pc_currchar->y;
			
			StartGrid = mapRegions->StartGrid(pc_currchar->x, pc_currchar->y);
			getcell = mapRegions->GetCell(pc_currchar->x, pc_currchar->y);
			
			increment = 0;
			ab = 0;
			for (checkgrid = StartGrid +(increment*mapRegions->GetColSize()); increment < 3; increment++, checkgrid = StartGrid +(increment*mapRegions->GetColSize()))
			{	
				for (a = 0; a < 3; a++)
				{					
					mapitemptr=-1;
					mapitem=-1;
					mapchar=-1;
					loopexit = 0;
					do // check all items in this cell
					{
						mapchar=-1;
						mapitemptr = mapRegions->GetNextItem(checkgrid + a, mapitemptr);
						if (mapitemptr==-1)
							break;
						mapitem = mapRegions->GetItem(checkgrid + a, mapitemptr);
						if (mapitem>999999)
							mapchar = mapitem - CharacterOffset;
						if (mapitem!=-1 && mapitem >= CharacterOffset)
						{
							i = mapchar;			
							
							if ((i != currchar[s]) &&(chars[i].npc))
							{
								x2 = chars[i].x;
								y2 = chars[i].y;
								if ((abs(x1 - x2) <= 2) &&(abs(y1 - y2) <= 2)) 
								{
									found = i + 1;
									ab = 1;
									break;
								}
							}
						}
					} while (mapitem!=-1  &&(++loopexit < MAXLOOPS));
					if (ab)
						break;
				}
				if (ab)
					break;
			}
			if ((found>0) &&(chars[found - 1].speech))
			{
				responsevendor(s, found - 1);
				found--;
				for (i = 0; i < strlen(&nonuni[0]); i++)
					nonuni[i] = toupper(nonuni[i]);
				talkingto[found] = currchar[s];
				openscript("speech.scp");
				sprintf(sect, "SPEECH %i", chars[found].speech);
				if (!i_scripts[speech_script]->find(sect))
				{
					closescript();
					return;
				}
				match = 0;
				strcpy(sect, "NO DEFAULT TEXT DEFINED");
				int loopexit2 = 0, loopexit = 0;
				do
				{
					read2();
					if (script1[0] != '}')
					{
						if (!(strcmp("DEFAULT", (char*)script1)))
						{
							strcpy(sect, (char*)script2);
						}
						if (!(strcmp("ON", (char*)script1)))
						{
							j = 0;
							loopexit = 0;
							do
							{
								m2 = 1;
								sml = strlen((char*)script2);
								if (strlen((char*)&nonuni[j]) < sml)
								{
									m2 = 0;
								}
								else
									for (i = 0; i < sml; i++)
									{
										if (nonuni[i + j] != toupper(script2[i]))
										{
											m2 = 0;
										}
									}
									j++;
							}
							while ((j < strlen(&nonuni[0])) &&(m2 == 0)  &&(++loopexit < MAXLOOPS));
							if (m2 == 1)
								match = 1;
						}
						if (!(strcmp("SAY", (char*)script1)))
						{
							if (match == 1)
							{
								npctalk(s, found, (char*)script2, 0);
								match = 2;
							}
						}
						
						if (!(strcmp("TRG", (char*)script1))) // Added by Magius(CHE) 
						{							  
							if (match == 1)
							{
								chars[found].trigger = str2num(script2);
								int pos = ftell(scpfile);
								closescript();
								
								triggernpc(s, found, 1);
								
								// AntiChrist 
								openscript("speech.scp");
								fseek(scpfile, pos, SEEK_SET);
								strcpy((char*)script1, "DUMMY");
								
								match = 2;
							}
						}
					}
				}
				while ((script1[0] != '}')  && (++loopexit2 < MAXLOOPS));
				if (match == 0)
				{
					npctalk(s, found, sect, 0);
				}
				closescript();
			}
		}
	}
}


/* wchar2char and char2wchar converts between ANSI char and Wide Chars
used by UO Client. Be aware, those functions returns their results in
temp[1024] global variable */
void wchar2char (const char* str)
{
	memset(&temp[0], 0, 1024);
	bool end = false;
	for (int i = 0; !end && i<1022 ; i++)
	{
		if (str[i] == 0 && str[i+1] == 0) end = true; // bugfix LB ... was str[i-1] not so good for i=0
		temp[i] = str[i*2];
	}
}

void char2wchar (const char* str)
{
	memset(&temp[0], 0, 1024);
	unsigned int size = strlen(str);
	
	// client wants to have a 0 as very fist byte.
	// after that 0 the unicode text
	// after it two(!) 0's as termintor

	unsigned int j=1;
	// temp[0]=0; //redundant, plz leave as comment

	for (unsigned int i = 0; i < size; i++) // bugfix LB ... temp[i+1] = str[i] .... wrong
	{
		temp[j]   = str[i];
		// temp[j+1] = 0; // redundant line, plz leave as comment
		j+=2;
	}

	// basicly redundant as well, plz leave as comment
	// temp[j]=0;
	// temp[j+1]=0;
}
