#include "storage.h" 

template<class T> Storage_cl<T>::Storage_cl()
{
}

template<class T> Storage_cl<T>::~Storage_cl()
{
	//We need to delete the items we contain as well
	
	for (iterData=mapData.begin(); iterData != mapData.end(); iterData++)
	{
		delete iterData->second ;
	}
	mapData.clear() ;
}

template<class T> int Storage_cl<T>::Count(void)
{
	return mapData.size();
}

template<class T> bool Storage_cl<T>::insert(T& cData, int serial) 
{
	indices.push_back(serial);
	return mapData.insert(make_pair(serial,&cData));
}
template<class T> bool Storage_cl<T>::insert(T* ptrData, int serial) 
{
	indices.push_back(serial);
	return mapData.insert(make_pair(serial,ptrData)) ;
}

template<class T> T* Storage_cl<T>::getPtr(int serial)
{

	iterData = mapData.find(serial) ;
	T* ptrData = NULL ;
	if (iterData != mapData.end())
		ptrData = iterData->second ;
	return ptrData ;
}

template<class T> void Storage_cl<T>::remove(int serial) 
{
	// First find the ptr
	iterData = mapData.find(serial) ;
	if (iterData != mapData.end())
	{
		// Delete the actual object
		delete iterData->second ;
		// Erase it out of the map
		mapData.erase(iterData) ;
	}
}

template<class T> T* Storage_cl<T>::Next(int &offset)
{
	iterData = mapData.begin();
	advance(iterData, offset);
	if (iterData != mapData.end())
	{
		offset++;
		T* ptrData = NULL;
		ptrData = iterData->second;
		return ptrData;
	}
	else
		return NULL;
}

template<class T> T* Storage_cl<T>::operator[](long index)
{
	iterData = mapData.begin();
	T* ptrData = iterData->second;
	if(index < 0 || index >=indices.size())
	{
		LogError("Error in chars[] index!\n");
		return ptrData;
	}
	
	interData = mapData.find(indices[index]);
	if (interData == mapData.end())
	{
		LogError("Error in chars[] index!\n");
		return ptrData;
	}
	ptrData = iterData->second;
	return ptrData;
}

Container_cl::Container_cl() 
{
}
Container_cl::~Container_cl() 
{
	mapData.clear() ;
}
bool Container_cl::setData(int serContainer, int serObject) 
{
	bool bStatus = false ;
	if (!find(serContainer,serObject))
	{
		// We dont want to insert the same association twice
		mapData.insert(make_pair(serContainer,serObject)) ;
		bStatus = true ;
	}
	return bStatus ;
}

bool Container_cl::find(int serContainer, int serObject)
{
	bool bStatus = false ;
	for(iterData = mapData.lower_bound(serContainer); iterData != mapData.upper_bound(serContainer); iterData++)
	{
		if (iterData->second == serObject)
		{
			bStatus = true ;
			break ;
		}
	}
	return bStatus;
}

bool Container_cl::remove(int serContainer, int serObject)
{
	bool bStatus = false ;
	for(iterData = mapData.lower_bound(serContainer); iterData != mapData.upper_bound(serContainer); iterData++)
	{
		if (iterData->second == serObject)
		{
			mapData.erase(iterData);
			bStatus = true;
			break ;
		}
	}
	return bStatus;
}

vector<int> Container_cl::getData(int serContainer) 
{
	vector<int> vecValue;
	
	for (iterData=mapData.lower_bound(serContainer); iterData!=mapData.upper_bound(serContainer); iterData++)
	{
		vecValue.push_back(iterData->second) ;
	}
	return vecValue;
}


