
#if !defined(__STORAGE_H__)
#define __STORAGE_H__
/*
#pragma warning(disable: 4786) //Gets rid of BAD stl warnings
#pragma warning(disable: 4503)
*/

// Platform specifics
#include "platform.h"

//System includes

#include "stl_headers_start.h"
#include <iostream>
#include <map>
#include <vector>
#include "stl_headers_end.h"

using namespace std;

// Forward class definition


// wolfpack includes


// Class definition


template<class T> class Storage_cl
{
public:
	Storage_cl() ;
	~Storage_cl() ;
	bool insert(T& cData, int serial) ;
	bool insert(T* ptrData, int serial) ;
	int Count(void);
	T* getPtr(int serial) ;
	T* Next(int &offset);

	void remove(int serial);
	T* operator[](long index);

private:
	map<int,T*> mapData ;
	map<int,T*>::iterator iterData;
	vector<int> indices;

	

};

class Container_cl
{
public:
	Container_cl() ;
	~Container_cl() ;
	bool setData(int serContainer, int serObject) ;
	vector<int> getData(int serContainer) ;
	bool find(int serContainer, int serObject) ;
	bool remove(int serContainer, int serObject) ;

private:
	multimap<int,int> mapData ;
	multimap<int,int>::iterator iterData ;
};

#endif // __STORAGE_H__

