#ifndef __VERINFO_H
#define __VERINFO_H

/* Correa's note:
We are getting close to finish moving chars and hopefully items to STL. Unfortunally the move isn't as 
smooth as I wish... it introduced a crash bug, possibly not easy to reproduce in all machines. :(

It's regarding the pointers to chars/items. If a function creates a new char/item and it requires
more memory than the currently avaliable, it will call realloc, which will invalidate all pointers
causing the server to crash.

Please, do not release until we finish this STL moving.

*/

// changed all the #defines dealing with verison stuff to a struct, LB
struct wp_version_info
{
    public:
	   bool  FORCEXWOLF;
	   bool  ILSHENAR;

	   int   vernumber;

	   std::string verstring; 
	   std::string productstring;
	   std::string betareleasestring;
	   std::string clientsupportedstring;
	   std::string timezonestring;
	   std::string compiledbystring;
	   std::string codersstring;
	   std::string emailstring;

	   wp_version_info()
	   {		   
		 

		   FORCEXWOLF = false;        // for linux verison that's ignored.
		                          // for iwndows version this determines if X-Wolf debugger is required for starting

		   ILSHENAR = false;      // currently ignored. 
		                          // for *later* use if ILSHANR MAP stuff is handled in server.cpt - hopefully one day. 
		                          // instead off compiling two differnt verisons (that's the way it is done currently)

		   vernumber = 125701;     // number-representation of version number (for XIP)
		                           // basicly verstring without "."'s + two digits at the end to indicate private / subversions
		                           // 00:  not allowed
		                           // 01:  official wolfpack release - release
		                           // 02:  official wolfpack beta    - release
		                           // 03-99: private extensions .. FOR NON WOLFPACK TEAM BUILDS !!! PLZ DO USE !!!


		   verstring = "12.6";  // Wolfpack version 

		   clientsupportedstring = "3.0.0c";

		   // SUPPORTED_CLIENT is part of the client version control system.
           // this is NOT necassairily the lastest client.
           // don't change it unless you are sure that its packets structure is in synch with network.cpp etc.
           // until I (LB) don't leave the wolfpack project, I want to be the only(!) one who
           // changes that value. thx for your understanding =:)

		   productstring = "Wolfpack"; // selfexplainatory, isnt't it :)
		   betareleasestring = "Release"; // release status

		   timezonestring = "GMT+1";   // your timezone

		   #ifdef __unix__
             compiledbystring = "punt" ;  // person that compiled linux version
             codersstring = "Duke, Ripper, Correa, punt, Lord Binary" ;
           #else
             compiledbystring = "Ripper" ; // person that cpompiled windows version
             codersstring = "Duke, Ripper, Correa, punt, Lord Binary" ;
           #endif

           emailstring = " ";		  
	   }

	   virtual ~wp_version_info() { ; }
};


#define ILSHENAR 0

// 0 -> compiles an old map (BRITANNIA) shard executable/binary
// 1 -> compiles  a new map (ILSHENAR)  shard executable/binary

#endif
