// WorldMain.h: interface for the CWorldMain class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(__WORLDMAIN_H__)
#define __WORLDMAIN_H__ 

// Platform Specifics 
#include "platform.h"


// System includes


#include "stl_headers_start.h"
#include <iostream>
#include "stl_headers_end.h"

using namespace std ;

// forward class declaration

class CWorldMain ;

//Wolfpack Includes
#include "wolfpack.h"
#include "verinfo.h"
#include "SndPkg.h"
#include "sregions.h"
#include "debug.h"
#include "utilsys.h"


class CWorldMain  
{
public:
	virtual int announce();
	virtual void announce(int choice);
	virtual void loadnewworld();
	virtual void savenewworld(char x);
	CWorldMain();
	virtual ~CWorldMain();

	void SetLoopSaveAmt( long toSet );
	long LoopSaveAmt( void );
	bool Saving( void );
	bool RemoveItemsFromCharBody(int charserial, int type1, int type2);
private:
	bool isSaving;
	int DisplayWorldSaves;
	FILE *iWsc, *cWsc;
	unsigned long Cur, Max;
	long PerLoop;

	void SaveChar( CHARACTER i );
	void SaveItem( long i, P_ITEM pDefault );
};

#endif //
 
